/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.standard.provider;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.ui.provider.PropertySource;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProvider;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapter;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapterFactory;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.provider.StandardItemProviderAdapterFactory;
import org.eclipse.stem.diseasemodels.standard.util.StandardAdapterFactory;

public class StandardRelativeValueProviderAdapterFactory
extends StandardAdapterFactory
implements RelativeValueProviderAdapterFactory {
    protected ComposedAdapterFactory parentAdapterFactory;
    protected IChangeNotifier changeNotifier = new ChangeNotifier();
    private static StandardItemProviderAdapterFactory itemProviderFactory;

    public StandardRelativeValueProviderAdapterFactory() {
        RelativeValueProviderAdapterFactory.INSTANCE.addAdapterFactory((AdapterFactory)this);
    }

    public Adapter createDiseaseModelLabelAdapter() {
        return new DiseaseModelLabelRelativeValueProvider();
    }

    public Adapter createDiseaseModelLabelValueAdapter() {
        return new DiseaseModelLabelValueRelativeValueProvider();
    }

    public void addListener(INotifyChangedListener iNotifyChangedListener) {
        this.changeNotifier.addListener(iNotifyChangedListener);
    }

    public void fireNotifyChanged(Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);
        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    public void removeListener(INotifyChangedListener iNotifyChangedListener) {
        this.changeNotifier.removeListener(iNotifyChangedListener);
    }

    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    public void setParentAdapterFactory(ComposedAdapterFactory composedAdapterFactory) {
        this.parentAdapterFactory = composedAdapterFactory;
    }

    public boolean isFactoryForType(Object object) {
        return object == RelativeValueProvider.class || super.isFactoryForType(object);
    }

    public void dispose() {
    }

    private static RelativeValueProviderAdapterFactory getRelativeValueProviderAdapterFactory() {
        return RelativeValueProviderAdapterFactory.INSTANCE;
    }

    private static StandardItemProviderAdapterFactory getItemProviderFactory() {
        if (itemProviderFactory == null) {
            itemProviderFactory = new StandardItemProviderAdapterFactory();
        }
        return itemProviderFactory;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DiseaseModelLabelRelativeValueProvider
    extends RelativeValueProviderAdapter
    implements RelativeValueProvider {
        public List<IItemPropertyDescriptor> getProperties() {
            DiseaseModelLabel diseaseModelLabel = (DiseaseModelLabel)this.getTarget();
            RelativeValueProvider relativeValueProvider = (RelativeValueProvider)StandardRelativeValueProviderAdapterFactory.getRelativeValueProviderAdapterFactory().adapt((Notifier)diseaseModelLabel.getCurrentValue(), RelativeValueProvider.class);
            return relativeValueProvider.getProperties();
        }

        public double getRelativeValue(EStructuralFeature eStructuralFeature) {
            DiseaseModelLabel diseaseModelLabel = (DiseaseModelLabel)this.getTarget();
            RelativeValueProvider relativeValueProvider = (RelativeValueProvider)StandardRelativeValueProviderAdapterFactory.getRelativeValueProviderAdapterFactory().adapt((Notifier)diseaseModelLabel.getCurrentValue(), RelativeValueProvider.class);
            return relativeValueProvider.getRelativeValue(eStructuralFeature);
        }

        public double getDenominator(EStructuralFeature eStructuralFeature) {
            DiseaseModelLabel diseaseModelLabel = (DiseaseModelLabel)this.getTarget();
            StandardDiseaseModelLabelValue standardDiseaseModelLabelValue = (StandardDiseaseModelLabelValue)diseaseModelLabel.getCurrentValue();
            standardDiseaseModelLabelValue.getPopulationCount();
            return standardDiseaseModelLabelValue.getPopulationCount();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DiseaseModelLabelValueRelativeValueProvider
    extends RelativeValueProviderAdapter
    implements RelativeValueProvider {
        public List<IItemPropertyDescriptor> getProperties() {
            ArrayList<IItemPropertyDescriptor> arrayList = new ArrayList<IItemPropertyDescriptor>();
            StandardItemProviderAdapterFactory standardItemProviderAdapterFactory = StandardRelativeValueProviderAdapterFactory.getItemProviderFactory();
            DiseaseModelLabelValue diseaseModelLabelValue = (DiseaseModelLabelValue)this.getTarget();
            IItemPropertySource iItemPropertySource = (IItemPropertySource)standardItemProviderAdapterFactory.adapt((Notifier)diseaseModelLabelValue, (Object)PropertySource.class);
            List list = iItemPropertySource.getPropertyDescriptors(null);
            for (IItemPropertyDescriptor iItemPropertyDescriptor : list) {
                EStructuralFeature eStructuralFeature = (EStructuralFeature)iItemPropertyDescriptor.getFeature(null);
                int n = eStructuralFeature.getFeatureID();
                if (n == 0 || n == 1) continue;
                arrayList.add(iItemPropertyDescriptor);
            }
            return arrayList;
        }

        public double getRelativeValue(EStructuralFeature eStructuralFeature) {
            DiseaseModelLabelValue diseaseModelLabelValue = (DiseaseModelLabelValue)this.getTarget();
            double d = (Double)diseaseModelLabelValue.eGet(eStructuralFeature);
            double d2 = diseaseModelLabelValue.getPopulationCount();
            double d3 = d2 == 0.0 ? 0.0 : d / d2;
            return d3;
        }

        public double getDenominator(EStructuralFeature eStructuralFeature) {
            DiseaseModelLabelValue diseaseModelLabelValue = (DiseaseModelLabelValue)this.getTarget();
            diseaseModelLabelValue.getPopulationCount();
            return diseaseModelLabelValue.getPopulationCount();
        }
    }
}

