/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.populationmodels.standard.impl;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.impl.NodeDecoratorImpl;
import org.eclipse.stem.definitions.labels.PopulationLabel;
import org.eclipse.stem.populationmodels.standard.PopulationModel;
import org.eclipse.stem.populationmodels.standard.PopulationModelLabel;
import org.eclipse.stem.populationmodels.standard.PopulationModelLabelValue;
import org.eclipse.stem.populationmodels.standard.StandardPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PopulationModelImpl
extends NodeDecoratorImpl
implements PopulationModel {
    protected static final String POPULATION_IDENTIFIER_EDEFAULT = "human";
    protected String populationIdentifier = "human";
    protected static final String NAME_EDEFAULT = "HumanPopulationModel";
    protected String name = "HumanPopulationModel";

    protected EClass eStaticClass() {
        return StandardPackage.Literals.POPULATION_MODEL;
    }

    @Override
    public String getPopulationIdentifier() {
        return this.populationIdentifier;
    }

    @Override
    public void setPopulationIdentifier(String string) {
        String string2 = this.populationIdentifier;
        this.populationIdentifier = string;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)string2, (Object)this.populationIdentifier));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        String string2 = this.name;
        this.name = string;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)string2, (Object)this.name));
        }
    }

    public void decorateGraph() {
        for (PopulationLabel populationLabel : this.getPopulationLabels(this.getPopulationIdentifier(), this.getGraph())) {
            if (!this.getPopulationIdentifier().equals(populationLabel.getPopulationIdentifier())) continue;
            PopulationModelLabel populationModelLabel = this.createPopulationLabel();
            populationModelLabel.setPopulationLabel(populationLabel);
            this.getLabelsToUpdate().add((Object)populationModelLabel);
            populationLabel.getNode().getLabels().add((Object)populationModelLabel);
            populationModelLabel.setNode(populationLabel.getNode());
            this.getGraph().putNodeLabel((NodeLabel)populationModelLabel);
        }
        this.resetLabels();
    }

    protected Collection<PopulationLabel> getPopulationLabels(String string, Graph graph) {
        ArrayList<PopulationLabel> arrayList = new ArrayList<PopulationLabel>();
        EList eList = graph.getNodeLabelsByTypeURI(PopulationLabel.URI_TYPE_POPULATION_LABEL);
        for (NodeLabel nodeLabel : eList) {
            PopulationLabel populationLabel = (PopulationLabel)nodeLabel;
            if (!populationLabel.getPopulationIdentifier().equals(string) || populationLabel.getNode() == null) continue;
            arrayList.add(populationLabel);
        }
        return arrayList;
    }

    public abstract PopulationModelLabel createPopulationLabel();

    public abstract PopulationModelLabelValue createPopulationLabelValue();

    public Object eGet(int n, boolean bl, boolean bl2) {
        switch (n) {
            case 8: {
                return this.getPopulationIdentifier();
            }
            case 9: {
                return this.getName();
            }
        }
        return super.eGet(n, bl, bl2);
    }

    public void eSet(int n, Object object) {
        switch (n) {
            case 8: {
                this.setPopulationIdentifier((String)object);
                return;
            }
            case 9: {
                this.setName((String)object);
                return;
            }
        }
        super.eSet(n, object);
    }

    public void eUnset(int n) {
        switch (n) {
            case 8: {
                this.setPopulationIdentifier(POPULATION_IDENTIFIER_EDEFAULT);
                return;
            }
            case 9: {
                this.setName(NAME_EDEFAULT);
                return;
            }
        }
        super.eUnset(n);
    }

    public boolean eIsSet(int n) {
        switch (n) {
            case 8: {
                return POPULATION_IDENTIFIER_EDEFAULT == null ? this.populationIdentifier != null : !POPULATION_IDENTIFIER_EDEFAULT.equals(this.populationIdentifier);
            }
            case 9: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
        }
        return super.eIsSet(n);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(" (populationIdentifier: ");
        stringBuffer.append(this.populationIdentifier);
        stringBuffer.append(", name: ");
        stringBuffer.append(this.name);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

