/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.populationmodels.standard.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.IntegrationLabel;
import org.eclipse.stem.core.graph.LabelValue;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.graph.SimpleDataExchangeLabelValue;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.populationmodels.standard.PopulationModelLabel;
import org.eclipse.stem.populationmodels.standard.PopulationModelLabelValue;
import org.eclipse.stem.populationmodels.standard.StandardFactory;
import org.eclipse.stem.populationmodels.standard.StandardPackage;
import org.eclipse.stem.populationmodels.standard.StandardPopulationModel;
import org.eclipse.stem.populationmodels.standard.StandardPopulationModelLabel;
import org.eclipse.stem.populationmodels.standard.StandardPopulationModelLabelValue;
import org.eclipse.stem.populationmodels.standard.impl.PopulationModelImpl;
import org.eclipse.stem.populationmodels.standard.impl.StandardPopulationModelLabelImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardPopulationModelImpl
extends PopulationModelImpl
implements StandardPopulationModel {
    protected static final double BIRTH_RATE_EDEFAULT = 0.0;
    protected double birthRate = 0.0;
    protected static final double DEATH_RATE_EDEFAULT = 0.0;
    protected double deathRate = 0.0;
    protected static final long TIME_PERIOD_EDEFAULT = 86400000L;
    protected long timePeriod = 86400000L;

    @Override
    protected EClass eStaticClass() {
        return StandardPackage.Literals.STANDARD_POPULATION_MODEL;
    }

    @Override
    public double getBirthRate() {
        return this.birthRate;
    }

    @Override
    public void setBirthRate(double d) {
        double d2 = this.birthRate;
        this.birthRate = d;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, d2, this.birthRate));
        }
    }

    @Override
    public double getDeathRate() {
        return this.deathRate;
    }

    @Override
    public void setDeathRate(double d) {
        double d2 = this.deathRate;
        this.deathRate = d;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, d2, this.deathRate));
        }
    }

    @Override
    public long getTimePeriod() {
        return this.timePeriod;
    }

    @Override
    public void setTimePeriod(long l) {
        long l2 = this.timePeriod;
        this.timePeriod = l;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, l2, this.timePeriod));
        }
    }

    @Override
    public void decorateGraph() {
        super.decorateGraph();
    }

    @Override
    public Object eGet(int n, boolean bl, boolean bl2) {
        switch (n) {
            case 10: {
                return new Double(this.getBirthRate());
            }
            case 11: {
                return new Double(this.getDeathRate());
            }
            case 12: {
                return new Long(this.getTimePeriod());
            }
        }
        return super.eGet(n, bl, bl2);
    }

    @Override
    public void eSet(int n, Object object) {
        switch (n) {
            case 10: {
                this.setBirthRate((Double)object);
                return;
            }
            case 11: {
                this.setDeathRate((Double)object);
                return;
            }
            case 12: {
                this.setTimePeriod((Long)object);
                return;
            }
        }
        super.eSet(n, object);
    }

    @Override
    public void eUnset(int n) {
        switch (n) {
            case 10: {
                this.setBirthRate(0.0);
                return;
            }
            case 11: {
                this.setDeathRate(0.0);
                return;
            }
            case 12: {
                this.setTimePeriod(86400000L);
                return;
            }
        }
        super.eUnset(n);
    }

    @Override
    public boolean eIsSet(int n) {
        switch (n) {
            case 10: {
                return this.birthRate != 0.0;
            }
            case 11: {
                return this.deathRate != 0.0;
            }
            case 12: {
                return this.timePeriod != 86400000L;
            }
        }
        return super.eIsSet(n);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(" (birthRate: ");
        stringBuffer.append(this.birthRate);
        stringBuffer.append(", deathRate: ");
        stringBuffer.append(this.deathRate);
        stringBuffer.append(", timePeriod: ");
        stringBuffer.append(this.timePeriod);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    @Override
    public PopulationModelLabel createPopulationLabel() {
        return StandardFactory.eINSTANCE.createStandardPopulationModelLabel();
    }

    @Override
    public PopulationModelLabelValue createPopulationLabelValue() {
        return StandardFactory.eINSTANCE.createStandardPopulationModelLabelValue();
    }

    public void calculateDelta(STEMTime sTEMTime, long l, EList<DynamicLabel> eList) {
        double d = this.adjustRate(this.getBirthRate(), this.getTimePeriod(), l);
        double d2 = this.adjustRate(this.getDeathRate(), this.getTimePeriod(), l);
        for (DynamicLabel dynamicLabel : eList) {
            StandardPopulationModelLabelImpl standardPopulationModelLabelImpl = (StandardPopulationModelLabelImpl)dynamicLabel;
            StandardPopulationModelLabelValue standardPopulationModelLabelValue = standardPopulationModelLabelImpl.getDeltaValue();
            StandardPopulationModelLabelValue standardPopulationModelLabelValue2 = standardPopulationModelLabelImpl.getProbeValue();
            double d3 = standardPopulationModelLabelValue2.getCount();
            double d4 = d3 * d;
            double d5 = d3 * d2;
            standardPopulationModelLabelValue.setIncidence(d4 - d5);
            standardPopulationModelLabelValue.setCount(d4 - d5);
            standardPopulationModelLabelValue.setBirths(d4);
            standardPopulationModelLabelValue.setDeaths(d5);
        }
    }

    public void applyExternalDeltas(STEMTime sTEMTime, long l, EList<DynamicLabel> eList) {
        for (StandardPopulationModelLabel standardPopulationModelLabel : eList) {
            StandardPopulationModelLabelValue standardPopulationModelLabelValue = standardPopulationModelLabel.getDeltaValue();
            Node node = standardPopulationModelLabel.getNode();
            EList eList2 = node.getLabels();
            for (NodeLabel nodeLabel : eList2) {
                if (!(nodeLabel instanceof IntegrationLabel) || nodeLabel.equals(standardPopulationModelLabel)) continue;
                SimpleDataExchangeLabelValue simpleDataExchangeLabelValue = (SimpleDataExchangeLabelValue)((IntegrationLabel)nodeLabel).getDeltaValue();
                double d = simpleDataExchangeLabelValue.getAdditions();
                double d2 = simpleDataExchangeLabelValue.getSubstractions();
                standardPopulationModelLabelValue.setCount(standardPopulationModelLabelValue.getCount() + d);
                standardPopulationModelLabelValue.setCount(standardPopulationModelLabelValue.getCount() - d2);
            }
        }
    }

    private double adjustRate(double d, long l, long l2) {
        return d * ((double)l2 / (double)l);
    }

    public void doModelSpecificAdjustments(LabelValue labelValue) {
    }
}

