/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.populationmodels.standard.impl;

import java.util.Random;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.stem.core.graph.LabelValue;
import org.eclipse.stem.populationmodels.standard.StandardPackage;
import org.eclipse.stem.populationmodels.standard.StandardPopulationModelLabelValue;
import org.eclipse.stem.populationmodels.standard.StochasticStandardPopulationModel;
import org.eclipse.stem.populationmodels.standard.impl.StandardPopulationModelImpl;

public class StochasticStandardPopulationModelImpl
extends StandardPopulationModelImpl
implements StochasticStandardPopulationModel {
    protected static double MAX_GAIN = 0.02;
    protected static final double GAIN_EDEFAULT = 0.01;
    protected double gain = 0.01;
    Random rand = new Random();

    protected EClass eStaticClass() {
        return StandardPackage.Literals.STOCHASTIC_STANDARD_POPULATION_MODEL;
    }

    public double getGain() {
        return this.gain;
    }

    public void doModelSpecificAdjustments(LabelValue labelValue) {
        StandardPopulationModelLabelValue standardPopulationModelLabelValue = (StandardPopulationModelLabelValue)labelValue;
        standardPopulationModelLabelValue.getCount();
        double d = standardPopulationModelLabelValue.getIncidence();
        double d2 = d * this.computeNoise();
        double d3 = d2 - d;
        double d4 = standardPopulationModelLabelValue.getCount() + d3;
        double d5 = standardPopulationModelLabelValue.getBirths() + d3 / 2.0;
        double d6 = standardPopulationModelLabelValue.getDeaths() + d3 / 2.0;
        standardPopulationModelLabelValue.setCount(d4);
        standardPopulationModelLabelValue.setBirths(d5);
        standardPopulationModelLabelValue.setDeaths(d6);
    }

    protected double computeNoise() {
        return this.computeNoise(this.getGain(), this.rand);
    }

    protected double computeNoise(double d, Random random) {
        assert (d <= MAX_GAIN) : "STOCHASTIC NOISE must be 'small', therefore gain parameter must be < MAX_GAIN=" + MAX_GAIN;
        double d2 = 2.0 * random.nextDouble() - 1.0;
        d2 *= d;
        assert ((d2 += 1.0) > 0.0 && d2 < 2.0) : "random noise should be a small perturbation Gain factor, g,  must 0.0 < g << 1.0 ";
        return d2;
    }

    public void setGain(double d) {
        double d2 = this.gain;
        this.gain = d;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, d2, this.gain));
        }
    }

    public Object eGet(int n, boolean bl, boolean bl2) {
        switch (n) {
            case 13: {
                return new Double(this.getGain());
            }
        }
        return super.eGet(n, bl, bl2);
    }

    public void eSet(int n, Object object) {
        switch (n) {
            case 13: {
                this.setGain((Double)object);
                return;
            }
        }
        super.eSet(n, object);
    }

    public void eUnset(int n) {
        switch (n) {
            case 13: {
                this.setGain(0.01);
                return;
            }
        }
        super.eUnset(n);
    }

    public boolean eIsSet(int n) {
        switch (n) {
            case 13: {
                return this.gain != 0.01;
            }
        }
        return super.eIsSet(n);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(" (gain: ");
        stringBuffer.append(this.gain);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

