/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.internal.data.geography.models;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.stem.core.graph.GraphPackage;
import org.eclipse.stem.data.geography.ISOKey;
import org.eclipse.stem.internal.data.ModelGenerator;
import org.eclipse.stem.internal.data.generatedplugin.DublinCore;
import org.eclipse.stem.internal.data.generatedplugin.Extension;
import org.eclipse.stem.internal.data.generatedplugin.GeneratedpluginFactory;
import org.eclipse.stem.internal.data.generatedplugin.Plugin;
import org.eclipse.stem.internal.data.generatedplugin.StemCategory;
import org.eclipse.stem.internal.data.geography.specifications.AdminLevel;
import org.eclipse.stem.internal.data.geography.specifications.AdminLevelSet;
import org.eclipse.stem.internal.data.geography.specifications.CountryGraphPropertyFileSpecification;
import org.eclipse.stem.internal.data.specifications.GeographicModelSpecification;
import org.eclipse.stem.internal.data.specifications.GraphPropertyFileSpecification;
import org.eclipse.stem.internal.data.specifications.ModelSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeographyModelGenerator
extends ModelGenerator {
    public static final String ID_MODEL_GEOGRAPHY_CATEGORY = "org.eclipse.stem.core.model.geography";
    public static final String ID_MODEL_GEOGRAPHY_POLITICAL_CATEGORY = "org.eclipse.stem.core.model.geography.political";
    public static final String ID_MODEL_GEOGRAPHY_POLITICAL_COUNTRIES_CATEGORY = "org.eclipse.stem.core.model.geography.political.countries";
    private static final Subject REGION_SUBJECT = new Subject("region");
    private static final Subject AREA_SUBJECT = new Subject("area");
    private static final Subject COMMON_BORDER_SUBJECT = new Subject("commonborder");
    private static final Subject RELATIVE_PHYSICAL_EDGE_NAME_SUBJECT = new Subject("relativephysical");

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.err.println("Missing specification of the plugin file");
        } else {
            String string = stringArray[0];
            String string2 = stringArray[1];
            String string3 = String.valueOf(string) + File.separator + "resources" + File.separator + "data";
            File file = new File(".." + File.separator + string2 + File.separator + "plugin.xml");
            URI uRI = URI.createFileURI((String)file.getAbsolutePath());
            GeographyModelGenerator geographyModelGenerator = new GeographyModelGenerator();
            Map<ISOKey, List<GeographicModelSpecification>> map = geographyModelGenerator.processFiles(uRI);
            for (ISOKey plugin2 : GeographyModelGenerator.sortISOKeys(map)) {
                for (ModelSpecification modelSpecification : map.get(plugin2)) {
                    try {
                        modelSpecification.serialize(string3);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
            Plugin plugin = GeneratedpluginFactory.eINSTANCE.createPlugin();
            Extension extension = GeneratedpluginFactory.eINSTANCE.createExtension();
            extension.setPoint("org.eclipse.stem.core.model");
            GeographyModelGenerator.addCatagoriesToExtension(extension);
            plugin.getExtensionelement().add((Object)extension);
            for (ISOKey iSOKey : GeographyModelGenerator.sortISOKeys(map)) {
                StemCategory stemCategory = GeneratedpluginFactory.eINSTANCE.createStemCategory();
                String string4 = "org.eclipse.stem.core.model.geography.political.countries." + iSOKey.toString().toLowerCase();
                stemCategory.setId(string4);
                stemCategory.setName(iSOKey.toString());
                stemCategory.setParentId(ID_MODEL_GEOGRAPHY_POLITICAL_COUNTRIES_CATEGORY);
                extension.getCategories().add((Object)stemCategory);
                for (ModelSpecification modelSpecification : map.get(iSOKey)) {
                    DublinCore dublinCore = GeneratedpluginFactory.eINSTANCE.createDublinCore();
                    dublinCore.setCategoryId(string4);
                    extension.getDublinCores().add((Object)GeographyModelGenerator.populateGeneratedDC((DublinCore)dublinCore, (org.eclipse.stem.core.common.DublinCore)modelSpecification.getDublinCore()));
                }
            }
            URI uRI2 = URI.createFileURI((String)(String.valueOf(string) + File.separator + "plugin.xml"));
            ModelGenerator.writePluginxml((Plugin)plugin, (URI)uRI2);
            GeographyModelGenerator.createPluginPropertties(string);
        }
    }

    public static void createPluginPropertties(String string) {
        File file = new File(String.valueOf(string) + File.separator + "plugin.properties");
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            System.out.println();
            PrintStream printStream = new PrintStream(bufferedOutputStream);
            printStream.println("pluginName = STEM Geographic Model Definitions (Incubation)");
            printStream.println("providerName = Eclipse.org");
            printStream.println("_UI_Standard_Scenario_category = STEM");
            printStream.println("_UI_Geography_category = Geography");
            printStream.println("_UI_Poltical_category = Political");
            printStream.println("_UI_Countries_category = Country");
            printStream.flush();
            printStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }

    private static void addCatagoriesToExtension(Extension extension) {
        StemCategory stemCategory = GeneratedpluginFactory.eINSTANCE.createStemCategory();
        stemCategory.setId("org.eclipse.stem.core.model");
        stemCategory.setName("%_UI_Standard_Scenario_category");
        stemCategory.setParentId("/");
        extension.getCategories().add((Object)stemCategory);
        StemCategory stemCategory2 = GeneratedpluginFactory.eINSTANCE.createStemCategory();
        stemCategory2.setId(ID_MODEL_GEOGRAPHY_CATEGORY);
        stemCategory2.setName("%_UI_Geography_category");
        stemCategory2.setParentId("org.eclipse.stem.core.model");
        extension.getCategories().add((Object)stemCategory2);
        StemCategory stemCategory3 = GeneratedpluginFactory.eINSTANCE.createStemCategory();
        stemCategory3.setId(ID_MODEL_GEOGRAPHY_POLITICAL_CATEGORY);
        stemCategory3.setName("%_UI_Poltical_category");
        stemCategory3.setParentId(ID_MODEL_GEOGRAPHY_CATEGORY);
        extension.getCategories().add((Object)stemCategory3);
        StemCategory stemCategory4 = GeneratedpluginFactory.eINSTANCE.createStemCategory();
        stemCategory4.setId(ID_MODEL_GEOGRAPHY_POLITICAL_COUNTRIES_CATEGORY);
        stemCategory4.setName("%_UI_Countries_category");
        stemCategory4.setParentId(ID_MODEL_GEOGRAPHY_POLITICAL_CATEGORY);
        extension.getCategories().add((Object)stemCategory4);
    }

    public static List<ISOKey> sortISOKeys(Map<ISOKey, ? extends Object> map) {
        ArrayList<ISOKey> arrayList = new ArrayList<ISOKey>();
        arrayList.addAll(map.keySet());
        Collections.sort(arrayList);
        return arrayList;
    }

    private static void printModelSpecifications(Map<ISOKey, List<GeographicModelSpecification>> map) {
        List<ISOKey> list = GeographyModelGenerator.sortISOKeys(map);
        for (ISOKey iSOKey : list) {
            List<GeographicModelSpecification> list2 = map.get(iSOKey);
            System.out.println(iSOKey + " : " + list2);
        }
    }

    protected Map<ISOKey, List<GeographicModelSpecification>> processFiles(URI uRI) {
        Extension extension2;
        HashMap<ISOKey, List<GeographicModelSpecification>> hashMap = new HashMap<ISOKey, List<GeographicModelSpecification>>();
        HashMap<ISOKey, Map<AdminLevel, Map<Subject, Map<ValidDateRange, DublinCore>>>> hashMap2 = new HashMap<ISOKey, Map<AdminLevel, Map<Subject, Map<ValidDateRange, DublinCore>>>>();
        HashMap<ISOKey, Map<AdminLevel, Map<Subject, Map<ValidDateRange, DublinCore>>>> hashMap3 = new HashMap<ISOKey, Map<AdminLevel, Map<Subject, Map<ValidDateRange, DublinCore>>>>();
        HashMap<ISOKey, Map<AdminLevel, Map<ISOKey, Map<AdminLevel, Map<Subject, Map<ValidDateRange, DublinCore>>>>>> hashMap4 = new HashMap<ISOKey, Map<AdminLevel, Map<ISOKey, Map<AdminLevel, Map<Subject, Map<ValidDateRange, DublinCore>>>>>>();
        Plugin plugin = this.getPluginxml(uRI);
        for (Extension extension2 : plugin.getExtensionelement()) {
            for (DublinCore dublinCore : extension2.getDublinCores()) {
                String[] stringArray = GraphPropertyFileSpecification.parseDublinCoreSubjectString((String)dublinCore.getSubject());
                Subject subject = new Subject(stringArray[1]);
                Map map = CountryGraphPropertyFileSpecification.parseDublinCoreCoverageString((String)dublinCore.getCoverage());
                if (stringArray[0].equals(GraphPackage.Literals.EDGE.getName())) {
                    this.populateEdgeMap(map, subject, dublinCore, hashMap4);
                    continue;
                }
                ISOKey iSOKey = (ISOKey)map.keySet().toArray()[0];
                AdminLevel adminLevel = ((AdminLevelSet)map.get(iSOKey)).getMaxAdminLevel();
                this.poulateMap(iSOKey, adminLevel, subject, dublinCore, stringArray[0].equals(GraphPackage.Literals.NODE.getName()) ? hashMap2 : hashMap3);
            }
        }
        extension2 = this.extractISOKeyAdminLevels(hashMap2);
        for (Iterator iterator : extension2.keySet()) {
            hashMap.put((ISOKey)iterator, this.makeAllModels((ISOKey)iterator, (AdminLevelSet)extension2.get(iterator), hashMap2, hashMap3, hashMap4));
        }
        return hashMap;
    }

    private List<GeographicModelSpecification> makeAllModels(ISOKey iSOKey, AdminLevelSet adminLevelSet, Map<ISOKey, Map<AdminLevel, Map<Subject, Map<ValidDateRange, DublinCore>>>> map, Map<ISOKey, Map<AdminLevel, Map<Subject, Map<ValidDateRange, DublinCore>>>> map2, Map<ISOKey, Map<AdminLevel, Map<ISOKey, Map<AdminLevel, Map<Subject, Map<ValidDateRange, DublinCore>>>>>> map3) {
        ArrayList<GeographicModelSpecification> arrayList = new ArrayList<GeographicModelSpecification>();
        for (AdminLevelSet adminLevelSet2 : adminLevelSet.makeAllLevelSets()) {
            GeographicModelSpecification geographicModelSpecification = new GeographicModelSpecification(iSOKey, adminLevelSet2);
            geographicModelSpecification.addNodeDCs(this.findDCs(REGION_SUBJECT, adminLevelSet2, map.get(iSOKey)));
            geographicModelSpecification.addAreaDCs(this.findDCs(AREA_SUBJECT, adminLevelSet2, map2.get(iSOKey)));
            List<DublinCore> list = this.findEdgeDCs(COMMON_BORDER_SUBJECT, iSOKey, adminLevelSet2, iSOKey, adminLevelSet2, map3);
            geographicModelSpecification.addCommonBorderEdgeDCs(list);
            List<DublinCore> list2 = this.findEdgeDCs(RELATIVE_PHYSICAL_EDGE_NAME_SUBJECT, iSOKey, adminLevelSet2, iSOKey, adminLevelSet2, map3);
            geographicModelSpecification.addContainmentEdgeDCs(list2);
            arrayList.add(geographicModelSpecification);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    private List<DublinCore> findDCs(Subject subject, AdminLevelSet adminLevelSet, Map<AdminLevel, Map<Subject, Map<ValidDateRange, DublinCore>>> map) {
        ArrayList<DublinCore> arrayList = new ArrayList<DublinCore>();
        for (AdminLevel adminLevel : adminLevelSet.getAdminLevels()) {
            Map<Subject, Map<ValidDateRange, DublinCore>> map2 = map.get(adminLevel);
            Map<ValidDateRange, DublinCore> map3 = map2.get(subject);
            DublinCore dublinCore = (DublinCore)map3.values().toArray()[0];
            arrayList.add(dublinCore);
        }
        return arrayList;
    }

    private List<DublinCore> findEdgeDCs(Subject subject, ISOKey iSOKey, AdminLevelSet adminLevelSet, ISOKey iSOKey2, AdminLevelSet adminLevelSet2, Map<ISOKey, Map<AdminLevel, Map<ISOKey, Map<AdminLevel, Map<Subject, Map<ValidDateRange, DublinCore>>>>>> map) {
        ArrayList<DublinCore> arrayList = new ArrayList<DublinCore>();
        if (iSOKey.equals((Object)iSOKey2)) {
            if (subject.equals(COMMON_BORDER_SUBJECT)) {
                for (AdminLevel adminLevel : adminLevelSet.getAdminLevels()) {
                    DublinCore dublinCore = this.getEdgeDC(subject, iSOKey, adminLevel, iSOKey, adminLevel, map);
                    if (dublinCore == null) continue;
                    arrayList.add(dublinCore);
                }
            } else {
                for (AdminLevel adminLevel : adminLevelSet.getAdminLevels()) {
                    for (AdminLevel adminLevel2 : adminLevelSet2.getAdminLevels()) {
                        DublinCore dublinCore = this.getEdgeDC(subject, iSOKey, adminLevel, iSOKey, adminLevel2, map);
                        if (dublinCore == null) continue;
                        arrayList.add(dublinCore);
                    }
                }
            }
        } else {
            DublinCore dublinCore = this.getEdgeDC(subject, iSOKey, adminLevelSet.getMaxAdminLevel(), iSOKey2, adminLevelSet2.getMaxAdminLevel(), map);
            if (dublinCore != null) {
                arrayList.add(dublinCore);
            }
        }
        return arrayList;
    }

    private DublinCore getEdgeDC(Subject subject, ISOKey iSOKey, AdminLevel adminLevel, ISOKey iSOKey2, AdminLevel adminLevel2, Map<ISOKey, Map<AdminLevel, Map<ISOKey, Map<AdminLevel, Map<Subject, Map<ValidDateRange, DublinCore>>>>>> map) {
        Map<ValidDateRange, DublinCore> map2;
        Map<Subject, Map<ValidDateRange, DublinCore>> map3;
        Map<AdminLevel, Map<Subject, Map<ValidDateRange, DublinCore>>> map4;
        Map<ISOKey, Map<AdminLevel, Map<Subject, Map<ValidDateRange, DublinCore>>>> map5;
        DublinCore dublinCore = null;
        Map<AdminLevel, Map<ISOKey, Map<AdminLevel, Map<Subject, Map<ValidDateRange, DublinCore>>>>> map6 = map.get(iSOKey);
        if (map6 != null && (map5 = map6.get(adminLevel)) != null && (map4 = map5.get(iSOKey2)) != null && (map3 = map4.get(adminLevel2)) != null && (map2 = map3.get(subject)) != null) {
            dublinCore = (DublinCore)map2.values().toArray()[0];
        }
        return dublinCore;
    }

    private void populateEdgeMap(Map<ISOKey, AdminLevelSet> map, Subject subject, DublinCore dublinCore, Map<ISOKey, Map<AdminLevel, Map<ISOKey, Map<AdminLevel, Map<Subject, Map<ValidDateRange, DublinCore>>>>>> map2) {
        List<ISOKey> list = GeographyModelGenerator.sortISOKeys(map);
        block0 : switch (list.size()) {
            case 1: {
                AdminLevelSet adminLevelSet = map.get(list.get(0));
                switch (adminLevelSet.getNumAdminLevels()) {
                    case 1: {
                        AdminLevel adminLevel = adminLevelSet.getMinAdminLevel();
                        Map<Subject, Map<ValidDateRange, DublinCore>> map3 = this.getSubjectMap(list.get(0), adminLevel, list.get(0), adminLevel, map2);
                        this.getDateRangeMap(subject, map3).put(new ValidDateRange(dublinCore.getValid()), dublinCore);
                        break block0;
                    }
                    case 2: {
                        AdminLevel adminLevel = adminLevelSet.getMinAdminLevel();
                        AdminLevel adminLevel2 = adminLevelSet.getMaxAdminLevel();
                        Map<Subject, Map<ValidDateRange, DublinCore>> map4 = this.getSubjectMap(list.get(0), adminLevel, list.get(0), adminLevel2, map2);
                        this.getDateRangeMap(subject, map4).put(new ValidDateRange(dublinCore.getValid()), dublinCore);
                        break block0;
                    }
                }
                System.out.println("Problem!");
                break;
            }
            case 2: {
                AdminLevelSet adminLevelSet = map.get(list.get(0));
                AdminLevelSet adminLevelSet2 = map.get(list.get(1));
                Map<Subject, Map<ValidDateRange, DublinCore>> map5 = this.getSubjectMap(list.get(0), adminLevelSet.getMinAdminLevel(), list.get(1), adminLevelSet2.getMinAdminLevel(), map2);
                this.getDateRangeMap(subject, map5).put(new ValidDateRange(dublinCore.getValid()), dublinCore);
                break;
            }
            default: {
                System.out.println("Problem!!");
            }
        }
    }

    private void poulateMap(ISOKey iSOKey, AdminLevel adminLevel, Subject subject, DublinCore dublinCore, Map<ISOKey, Map<AdminLevel, Map<Subject, Map<ValidDateRange, DublinCore>>>> map) {
        Map<Subject, Map<ValidDateRange, DublinCore>> map2;
        Map<AdminLevel, Map<Subject, Map<ValidDateRange, DublinCore>>> map3 = map.get(iSOKey);
        if (map3 == null) {
            map3 = new HashMap<AdminLevel, Map<Subject, Map<ValidDateRange, DublinCore>>>();
            map.put(iSOKey, map3);
        }
        if ((map2 = map3.get(adminLevel)) == null) {
            map2 = new HashMap<Subject, Map<ValidDateRange, DublinCore>>();
            map3.put(adminLevel, map2);
        }
        this.getDateRangeMap(subject, map2).put(new ValidDateRange(dublinCore.getValid()), dublinCore);
    }

    private Map<Subject, Map<ValidDateRange, DublinCore>> getSubjectMap(ISOKey iSOKey, AdminLevel adminLevel, ISOKey iSOKey2, AdminLevel adminLevel2, Map<ISOKey, Map<AdminLevel, Map<ISOKey, Map<AdminLevel, Map<Subject, Map<ValidDateRange, DublinCore>>>>>> map) {
        Map<Subject, Map<ValidDateRange, DublinCore>> map2;
        Map<AdminLevel, Map<Subject, Map<ValidDateRange, DublinCore>>> map3;
        Map<ISOKey, Map<AdminLevel, Map<Subject, Map<ValidDateRange, DublinCore>>>> map4;
        Map<AdminLevel, Map<ISOKey, Map<AdminLevel, Map<Subject, Map<ValidDateRange, DublinCore>>>>> map5 = map.get(iSOKey);
        if (map5 == null) {
            map5 = new HashMap<AdminLevel, Map<ISOKey, Map<AdminLevel, Map<Subject, Map<ValidDateRange, DublinCore>>>>>();
            map.put(iSOKey, map5);
        }
        if ((map4 = map5.get(adminLevel)) == null) {
            map4 = new HashMap<ISOKey, Map<AdminLevel, Map<Subject, Map<ValidDateRange, DublinCore>>>>();
            map5.put(adminLevel, map4);
        }
        if ((map3 = map4.get(iSOKey2)) == null) {
            map3 = new HashMap<AdminLevel, Map<Subject, Map<ValidDateRange, DublinCore>>>();
            map4.put(iSOKey2, map3);
        }
        if ((map2 = map3.get(adminLevel2)) == null) {
            map2 = new HashMap<Subject, Map<ValidDateRange, DublinCore>>();
            map3.put(adminLevel2, map2);
        }
        return map2;
    }

    private Map<ValidDateRange, DublinCore> getDateRangeMap(Subject subject, Map<Subject, Map<ValidDateRange, DublinCore>> map) {
        Map<ValidDateRange, DublinCore> map2 = map.get(subject);
        if (map2 == null) {
            map2 = new HashMap<ValidDateRange, DublinCore>();
            map.put(subject, map2);
        }
        return map2;
    }

    private Map<ISOKey, AdminLevelSet> extractISOKeyAdminLevels(Map<ISOKey, Map<AdminLevel, Map<Subject, Map<ValidDateRange, DublinCore>>>> map) {
        HashMap<ISOKey, AdminLevelSet> hashMap = new HashMap<ISOKey, AdminLevelSet>();
        for (ISOKey iSOKey : GeographyModelGenerator.sortISOKeys(map)) {
            Map<AdminLevel, Map<Subject, Map<ValidDateRange, DublinCore>>> map2 = map.get(iSOKey);
            AdminLevelSet adminLevelSet = new AdminLevelSet();
            for (AdminLevel adminLevel : map2.keySet()) {
                adminLevelSet.addAdminLevel(adminLevel);
            }
            hashMap.put(iSOKey, adminLevelSet);
        }
        return hashMap;
    }

    private void printMap(Map<ISOKey, Map<AdminLevel, Map<Subject, Map<ValidDateRange, DublinCore>>>> map) {
        System.out.println("****************************************************************");
        for (ISOKey iSOKey : GeographyModelGenerator.sortISOKeys(map)) {
            System.out.println(iSOKey);
            Map<AdminLevel, Map<Subject, Map<ValidDateRange, DublinCore>>> map2 = map.get(iSOKey);
            for (AdminLevel adminLevel : map2.keySet()) {
                System.out.println("\t" + adminLevel);
                this.printSubjectMap(map2.get(adminLevel));
            }
        }
    }

    private void printEdgeMap(Map<ISOKey, Map<AdminLevel, Map<ISOKey, Map<AdminLevel, Map<Subject, Map<ValidDateRange, DublinCore>>>>>> map) {
        System.out.println("****************************************************************");
        for (ISOKey iSOKey : GeographyModelGenerator.sortISOKeys(map)) {
            System.out.println(iSOKey);
            Map<AdminLevel, Map<ISOKey, Map<AdminLevel, Map<Subject, Map<ValidDateRange, DublinCore>>>>> map2 = map.get(iSOKey);
            for (AdminLevel adminLevel : map2.keySet()) {
                System.out.println("\t" + adminLevel);
                Map<ISOKey, Map<AdminLevel, Map<Subject, Map<ValidDateRange, DublinCore>>>> map3 = map2.get(adminLevel);
                for (ISOKey iSOKey2 : GeographyModelGenerator.sortISOKeys(map3)) {
                    System.out.println("\t\t" + iSOKey2);
                    Map<AdminLevel, Map<Subject, Map<ValidDateRange, DublinCore>>> map4 = map3.get(iSOKey2);
                    for (AdminLevel adminLevel2 : map4.keySet()) {
                        System.out.println("\t\t\t" + adminLevel2);
                        this.printSubjectMap(map4.get(adminLevel2));
                    }
                }
            }
        }
    }

    private void printSubjectMap(Map<Subject, Map<ValidDateRange, DublinCore>> map) {
        for (Subject subject : map.keySet()) {
            System.out.println("\t\t\t\t" + subject);
            Map<ValidDateRange, DublinCore> map2 = map.get(subject);
            for (ValidDateRange validDateRange : map2.keySet()) {
                DublinCore dublinCore = map2.get(validDateRange);
                System.out.println("\t\t\t\t\t" + validDateRange + " : " + dublinCore.getIdentifier());
            }
        }
    }

    private static class Subject {
        String subject;

        public Subject(String string) {
            this.subject = string;
        }

        public int hashCode() {
            return this.subject.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Subject subject = (Subject)object;
            return !(this.subject == null ? subject.subject != null : !this.subject.equals(subject.subject));
        }

        public String toString() {
            return this.subject;
        }
    }

    private static class ValidDateRange {
        String dcValidString;

        public ValidDateRange(String string) {
            this.dcValidString = string;
        }

        public int hashCode() {
            return this.dcValidString.hashCode();
        }

        public boolean equals(Object object) {
            return this.dcValidString.equals(object);
        }

        public String toString() {
            return this.dcValidString;
        }
    }
}

