/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.internal.data.specifications;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.stem.core.Utility;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.model.Model;
import org.eclipse.stem.core.model.ModelPackage;
import org.eclipse.stem.data.geography.ISOKey;
import org.eclipse.stem.definitions.nodes.NodesPackage;
import org.eclipse.stem.internal.data.generatedplugin.DublinCore;
import org.eclipse.stem.internal.data.geography.specifications.AdminLevelSet;
import org.eclipse.stem.internal.data.geography.specifications.CountryGraphPropertyFileSpecification;
import org.eclipse.stem.internal.data.specifications.GraphPropertyFileSpecification;
import org.eclipse.stem.internal.data.specifications.ModelSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeographicModelSpecification
extends ModelSpecification
implements Comparable<GeographicModelSpecification> {
    private final NodesPackage nodesPackage = NodesPackage.eINSTANCE;
    private final Map<ISOKey, AdminLevelSet> countryLevelMap = new HashMap<ISOKey, AdminLevelSet>();
    private final List<DublinCore> nodeDublinCores = new ArrayList<DublinCore>();
    private final List<DublinCore> areaDublinCores = new ArrayList<DublinCore>();
    private final List<DublinCore> commonBorderEdgeDublinCores = new ArrayList<DublinCore>();
    private final List<DublinCore> containmentEdgeDublinCores = new ArrayList<DublinCore>();

    static {
        String string = System.getProperty("user.dir");
        String string2 = string.substring(0, string.lastIndexOf(File.separator));
        String string3 = String.valueOf(string2) + File.separator + "org.eclipse.stem.data.geography" + File.separator;
        Map map = EcorePlugin.getPlatformResourceMap();
        map.put("org.eclipse.stem.data.geography", URI.createFileURI((String)string3));
    }

    public GeographicModelSpecification(ISOKey iSOKey, AdminLevelSet adminLevelSet) {
        this.countryLevelMap.put(iSOKey, adminLevelSet);
    }

    public void addNodeDCs(List<DublinCore> list) {
        this.nodeDublinCores.addAll(list);
    }

    public void addAreaDCs(List<DublinCore> list) {
        this.areaDublinCores.addAll(list);
    }

    public void addCommonBorderEdgeDCs(List<DublinCore> list) {
        this.commonBorderEdgeDublinCores.addAll(list);
    }

    public void addContainmentEdgeDCs(List<DublinCore> list) {
        this.containmentEdgeDublinCores.addAll(list);
    }

    protected Model createIdentifiableInstance() {
        Model model = super.createIdentifiableInstance();
        for (DublinCore dublinCore : this.nodeDublinCores) {
            model.getGraphs().add((Object)((Graph)Utility.getIdentifiable((URI)GeographicModelSpecification.getIdentifiableProjectURI((DublinCore)dublinCore))));
        }
        for (DublinCore dublinCore : this.areaDublinCores) {
            model.getGraphs().add((Object)((Graph)Utility.getIdentifiable((URI)GeographicModelSpecification.getIdentifiableProjectURI((DublinCore)dublinCore))));
        }
        for (DublinCore dublinCore : this.commonBorderEdgeDublinCores) {
            model.getGraphs().add((Object)((Graph)Utility.getIdentifiable((URI)GeographicModelSpecification.getIdentifiableProjectURI((DublinCore)dublinCore))));
        }
        for (DublinCore dublinCore : this.containmentEdgeDublinCores) {
            model.getGraphs().add((Object)((Graph)Utility.getIdentifiable((URI)GeographicModelSpecification.getIdentifiableProjectURI((DublinCore)dublinCore))));
        }
        return model;
    }

    protected String getRelativeSerializationPath() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("country");
        stringBuilder.append(File.separatorChar);
        stringBuilder.append(this.getISOKey().toString());
        return stringBuilder.toString();
    }

    protected String getSerializationFileNameRoot() {
        StringBuilder stringBuilder = new StringBuilder(this.getISOKey().toString());
        stringBuilder.append("_");
        stringBuilder.append(this.countryLevelMap.get(this.getISOKey()).toString());
        return stringBuilder.toString();
    }

    protected String getTargetPluginId() {
        return "org.eclipse.stem.data.geography.models";
    }

    protected String getTitleDescriptor() {
        Iterator iterator;
        Map map;
        DublinCore dublinCore;
        Iterator<DublinCore> iterator2;
        StringBuilder stringBuilder = new StringBuilder(this.getISOKey().toString());
        stringBuilder.append(" Geography");
        String string = this.countryLevelMap.get(this.getISOKey()).toString();
        AdminLevelSet adminLevelSet = new AdminLevelSet(string);
        stringBuilder.append(adminLevelSet.getNumAdminLevels() > 1 ? " (Levels: " : " (Level: ");
        stringBuilder.append(adminLevelSet.toString(","));
        stringBuilder.append(")");
        if (this.commonBorderEdgeDublinCores.size() > 0) {
            stringBuilder.append(", Common Border(");
            iterator2 = this.commonBorderEdgeDublinCores.iterator();
            while (iterator2.hasNext()) {
                dublinCore = iterator2.next();
                map = CountryGraphPropertyFileSpecification.parseDublinCoreCoverageString((String)dublinCore.getCoverage());
                iterator = map.values().iterator();
                while (iterator.hasNext()) {
                    stringBuilder.append(((AdminLevelSet)iterator.next()).toString("-"));
                    stringBuilder.append(iterator2.hasNext() ? ", " : "");
                }
            }
            stringBuilder.append(")");
        }
        if (this.containmentEdgeDublinCores.size() > 0) {
            stringBuilder.append(", Containment(");
            iterator2 = this.containmentEdgeDublinCores.iterator();
            while (iterator2.hasNext()) {
                dublinCore = iterator2.next();
                map = CountryGraphPropertyFileSpecification.parseDublinCoreCoverageString((String)dublinCore.getCoverage());
                iterator = map.values().iterator();
                while (iterator.hasNext()) {
                    stringBuilder.append(((AdminLevelSet)iterator.next()).toString("->"));
                    stringBuilder.append(iterator2.hasNext() ? ", " : "");
                }
            }
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    protected String createDubinCoreCoverage() {
        return CountryGraphPropertyFileSpecification.createDublinCoreCoverageString(this.countryLevelMap);
    }

    protected String createDubinCoreSubject() {
        return GraphPropertyFileSpecification.createDublinCoreSubjectString((String)ModelPackage.Literals.MODEL.getName(), (String)"geography");
    }

    private ISOKey getISOKey() {
        ISOKey iSOKey = (ISOKey)this.countryLevelMap.keySet().toArray()[0];
        return iSOKey;
    }

    @Override
    public int compareTo(GeographicModelSpecification geographicModelSpecification) {
        int n = 0;
        if (this.countryLevelMap.size() == geographicModelSpecification.countryLevelMap.size()) {
            if (this.countryLevelMap.size() == 1) {
                AdminLevelSet adminLevelSet = (AdminLevelSet)this.countryLevelMap.values().toArray()[0];
                AdminLevelSet adminLevelSet2 = (AdminLevelSet)geographicModelSpecification.countryLevelMap.values().toArray()[0];
                n = adminLevelSet.getNumAdminLevels() == adminLevelSet2.getNumAdminLevels() ? adminLevelSet.getMinAdminLevel().compareTo(adminLevelSet2.getMinAdminLevel()) : (adminLevelSet.getNumAdminLevels() > adminLevelSet2.getNumAdminLevels() ? 1 : -1);
            }
        } else {
            n = this.countryLevelMap.size() > geographicModelSpecification.countryLevelMap.size() ? 1 : -1;
        }
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (ISOKey iSOKey : this.countryLevelMap.keySet()) {
            stringBuilder.append(iSOKey);
            stringBuilder.append(" : ");
            stringBuilder.append(this.countryLevelMap.get(iSOKey));
            stringBuilder.append("(" + this.nodeDublinCores.size() + "/" + this.areaDublinCores.size() + "/" + this.commonBorderEdgeDublinCores.size() + "/" + this.containmentEdgeDublinCores.size() + ")");
        }
        return stringBuilder.toString();
    }
}

