/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.populationmodels.adapters;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.ui.provider.PropertySource;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProvider;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapter;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapterFactory;
import org.eclipse.stem.populationmodels.standard.PopulationModelLabel;
import org.eclipse.stem.populationmodels.standard.PopulationModelLabelValue;
import org.eclipse.stem.populationmodels.standard.StandardPopulationModelLabelValue;
import org.eclipse.stem.populationmodels.standard.provider.StandardItemProviderAdapterFactory;
import org.eclipse.stem.populationmodels.standard.util.StandardAdapterFactory;
import org.eclipse.stem.ui.populationmodels.Activator;
import org.eclipse.stem.ui.populationmodels.preferences.PreferenceInitializer;
import org.eclipse.ui.IStartup;

public class StandardRelativeValueProviderAdapterFactory
extends StandardAdapterFactory
implements RelativeValueProviderAdapterFactory,
IStartup {
    protected ComposedAdapterFactory parentAdapterFactory;
    protected IChangeNotifier changeNotifier = new ChangeNotifier();
    private static StandardItemProviderAdapterFactory itemProviderFactory;

    public StandardRelativeValueProviderAdapterFactory() {
        RelativeValueProviderAdapterFactory.INSTANCE.addAdapterFactory((AdapterFactory)this);
    }

    public Adapter createStandardPopulationModelLabelAdapter() {
        return new StandardPopulationModelLabelRelativeValueProvider();
    }

    public Adapter createStandardPopulationModelLabelValueAdapter() {
        return new PopulationModelLabelValueRelativeValueProvider();
    }

    public void addListener(INotifyChangedListener iNotifyChangedListener) {
        this.changeNotifier.addListener(iNotifyChangedListener);
    }

    public void fireNotifyChanged(Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);
        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    public void removeListener(INotifyChangedListener iNotifyChangedListener) {
        this.changeNotifier.removeListener(iNotifyChangedListener);
    }

    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    public void setParentAdapterFactory(ComposedAdapterFactory composedAdapterFactory) {
        this.parentAdapterFactory = composedAdapterFactory;
    }

    public boolean isFactoryForType(Object object) {
        return object == RelativeValueProvider.class || super.isFactoryForType(object);
    }

    public void dispose() {
    }

    private static RelativeValueProviderAdapterFactory getRelativeValueProviderAdapterFactory() {
        return RelativeValueProviderAdapterFactory.INSTANCE;
    }

    private static StandardItemProviderAdapterFactory getItemProviderFactory() {
        if (itemProviderFactory == null) {
            itemProviderFactory = new StandardItemProviderAdapterFactory();
        }
        return itemProviderFactory;
    }

    public void earlyStartup() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PopulationModelLabelValueRelativeValueProvider
    extends RelativeValueProviderAdapter
    implements RelativeValueProvider {
        public List<IItemPropertyDescriptor> getProperties() {
            ArrayList<IItemPropertyDescriptor> arrayList = new ArrayList<IItemPropertyDescriptor>();
            StandardItemProviderAdapterFactory standardItemProviderAdapterFactory = StandardRelativeValueProviderAdapterFactory.getItemProviderFactory();
            PopulationModelLabelValue populationModelLabelValue = (PopulationModelLabelValue)this.getTarget();
            IItemPropertySource iItemPropertySource = (IItemPropertySource)standardItemProviderAdapterFactory.adapt((Notifier)populationModelLabelValue, PropertySource.class);
            List list = iItemPropertySource.getPropertyDescriptors(null);
            for (IItemPropertyDescriptor iItemPropertyDescriptor : list) {
                EStructuralFeature eStructuralFeature = (EStructuralFeature)iItemPropertyDescriptor.getFeature(null);
                int n = eStructuralFeature.getFeatureID();
                if (n == 2 || n == 3 || n == 1) continue;
                arrayList.add(iItemPropertyDescriptor);
            }
            return arrayList;
        }

        public double getRelativeValue(EStructuralFeature eStructuralFeature) {
            StandardPopulationModelLabelValue standardPopulationModelLabelValue = (StandardPopulationModelLabelValue)this.getTarget();
            double d = (Double)standardPopulationModelLabelValue.eGet(eStructuralFeature);
            long l = Activator.getDefault().getPluginPreferences().getLong("referencePopulation");
            long l2 = Activator.getDefault().getPluginPreferences().getLong("referenceDensity");
            if (l == 0L) {
                l = PreferenceInitializer.DEFAULT_REFERENCE_POPULATION;
            }
            if (l2 == 0L) {
                l = PreferenceInitializer.DEFAULT_REFERENCE_DENSITY;
            }
            double d2 = eStructuralFeature.getFeatureID() == 4 ? d / (double)l2 : d / (double)l;
            return d2 > 1.0 ? 1.0 : d2;
        }

        public double getDenominator(EStructuralFeature eStructuralFeature) {
            long l = Activator.getDefault().getPluginPreferences().getLong("referencePopulation");
            long l2 = Activator.getDefault().getPluginPreferences().getLong("referenceDensity");
            if (l == 0L) {
                l = PreferenceInitializer.DEFAULT_REFERENCE_POPULATION;
            }
            if (l2 == 0L) {
                l = PreferenceInitializer.DEFAULT_REFERENCE_DENSITY;
            }
            if (eStructuralFeature.getFeatureID() == 4) {
                return l2;
            }
            return l;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StandardPopulationModelLabelRelativeValueProvider
    extends RelativeValueProviderAdapter
    implements RelativeValueProvider {
        public List<IItemPropertyDescriptor> getProperties() {
            PopulationModelLabel populationModelLabel = (PopulationModelLabel)this.getTarget();
            RelativeValueProvider relativeValueProvider = (RelativeValueProvider)StandardRelativeValueProviderAdapterFactory.getRelativeValueProviderAdapterFactory().adapt((Notifier)populationModelLabel.getCurrentValue(), RelativeValueProvider.class);
            return relativeValueProvider.getProperties();
        }

        public double getRelativeValue(EStructuralFeature eStructuralFeature) {
            PopulationModelLabel populationModelLabel = (PopulationModelLabel)this.getTarget();
            RelativeValueProvider relativeValueProvider = (RelativeValueProvider)StandardRelativeValueProviderAdapterFactory.getRelativeValueProviderAdapterFactory().adapt((Notifier)populationModelLabel.getCurrentValue(), RelativeValueProvider.class);
            return relativeValueProvider.getRelativeValue(eStructuralFeature);
        }

        public double getDenominator(EStructuralFeature eStructuralFeature) {
            long l = Activator.getDefault().getPluginPreferences().getLong("referencePopulation");
            long l2 = Activator.getDefault().getPluginPreferences().getLong("referenceDensity");
            if (l == 0L) {
                l = PreferenceInitializer.DEFAULT_REFERENCE_POPULATION;
            }
            if (l2 == 0L) {
                l = PreferenceInitializer.DEFAULT_REFERENCE_DENSITY;
            }
            if (eStructuralFeature.getFeatureID() == 4) {
                return l2;
            }
            return l;
        }
    }
}

