/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.populationmodels.standard.wizards;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.stem.populationmodels.standard.PopulationModel;
import org.eclipse.stem.populationmodels.standard.StandardPackage;
import org.eclipse.stem.populationmodels.standard.StandardPopulationModel;
import org.eclipse.stem.ui.adapters.propertystrings.PropertyStringProvider;
import org.eclipse.stem.ui.adapters.propertystrings.PropertyStringProviderAdapter;
import org.eclipse.stem.ui.adapters.propertystrings.PropertyStringProviderAdapterFactory;
import org.eclipse.stem.ui.populationmodels.adapters.PopulationModelPropertyEditor;
import org.eclipse.stem.ui.populationmodels.standard.wizards.PopulationModelWizardMessages;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class StandardPopulationModelPropertyEditor
extends PopulationModelPropertyEditor {
    public StandardPopulationModelPropertyEditor(Composite composite, int n, PopulationModel populationModel, ModifyListener modifyListener) {
        super(composite, n);
        IItemPropertyDescriptor iItemPropertyDescriptor2;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.setLayout((Layout)gridLayout);
        PropertyStringProviderAdapter propertyStringProviderAdapter = (PropertyStringProviderAdapter)PropertyStringProviderAdapterFactory.INSTANCE.adapt((Notifier)populationModel, PropertyStringProvider.class);
        ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        IItemPropertySource iItemPropertySource = (IItemPropertySource)composedAdapterFactory.adapt((Notifier)populationModel, IItemPropertySource.class);
        List list = iItemPropertySource.getPropertyDescriptors((Object)populationModel);
        for (IItemPropertyDescriptor iItemPropertyDescriptor2 : list) {
            EStructuralFeature eStructuralFeature = (EStructuralFeature)iItemPropertyDescriptor2.getFeature(null);
            if (!StandardPopulationModelPropertyEditor.isUserSpecifiedPopulationModelProperty(eStructuralFeature)) continue;
            Label label = new Label((Composite)this, 0);
            label.setText(propertyStringProviderAdapter.getPropertyName(iItemPropertyDescriptor2));
            GridData gridData = new GridData(1);
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalAlignment = 4;
            gridData.horizontalIndent = 0;
            label.setLayoutData((Object)gridData);
            String string = this.getPropertyDefaultValueString(iItemPropertyDescriptor2);
            Text text = new Text((Composite)this, 133120);
            text.setText(string);
            text.setToolTipText(propertyStringProviderAdapter.getPropertyToolTip(iItemPropertyDescriptor2));
            this.map.put(eStructuralFeature, text);
            GridData gridData2 = new GridData(3);
            gridData2.grabExcessHorizontalSpace = true;
            gridData2.horizontalAlignment = 4;
            text.setLayoutData((Object)gridData2);
            text.addModifyListener(modifyListener);
            boolean bl = false;
            if (eStructuralFeature.getName().equals("dataPath")) {
                bl = true;
            }
            if (bl) continue;
            Label label2 = new Label((Composite)this, 0);
            label2.setText(propertyStringProviderAdapter.getPropertyUnits(iItemPropertyDescriptor2));
            GridData gridData3 = new GridData(3);
            gridData3.verticalAlignment = 2;
            label2.setLayoutData((Object)gridData3);
        }
        iItemPropertyDescriptor2 = new Label((Composite)this, 0);
        iItemPropertyDescriptor2.setText(PopulationModelWizardMessages.getString("PMTP_Def"));
        GridData gridData = new GridData(3);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        iItemPropertyDescriptor2.setLayoutData((Object)gridData);
    }

    public void populate(PopulationModel populationModel) {
        super.populate(populationModel);
        for (Map.Entry entry : this.map.entrySet()) {
            switch (((EStructuralFeature)entry.getKey()).getFeatureID()) {
                case 8: {
                    ((StandardPopulationModel)populationModel).setPopulationIdentifier(((Text)entry.getValue()).getText());
                    break;
                }
                case 10: {
                    ((StandardPopulationModel)populationModel).setBirthRate(Double.parseDouble(((Text)entry.getValue()).getText().trim()));
                    break;
                }
                case 11: {
                    ((StandardPopulationModel)populationModel).setDeathRate(Double.parseDouble(((Text)entry.getValue()).getText().trim()));
                    break;
                }
                case 12: {
                    ((StandardPopulationModel)populationModel).setTimePeriod(Long.parseLong(((Text)entry.getValue()).getText().trim()));
                    break;
                }
            }
        }
    }

    public boolean validate() {
        Text text;
        boolean bl = super.validate();
        if (bl) {
            text = (Text)this.map.get(StandardPackage.Literals.POPULATION_MODEL__POPULATION_IDENTIFIER);
            boolean bl2 = bl = !text.getText().equals("");
            if (!bl) {
                this.errorMessage = PopulationModelWizardMessages.getString("NDizWizErr0");
            }
        }
        if (bl) {
            text = (Text)this.map.get(StandardPackage.Literals.STANDARD_POPULATION_MODEL__DEATH_RATE);
            boolean bl3 = bl = !text.getText().equals("");
            if (!bl) {
                this.errorMessage = PopulationModelWizardMessages.getString("NDizWizErr4");
            } else {
                bl = this.isValidValue(text.getText(), 0.0);
                if (!bl) {
                    this.errorMessage = PopulationModelWizardMessages.getString("NDizWizErr5");
                }
            }
        }
        if (bl) {
            text = (Text)this.map.get(StandardPackage.Literals.STANDARD_POPULATION_MODEL__BIRTH_RATE);
            boolean bl4 = bl = !text.getText().equals("");
            if (!bl) {
                this.errorMessage = PopulationModelWizardMessages.getString("NDizWizErr6");
            } else {
                bl = this.isValidValue(text.getText(), 0.0);
                if (!bl) {
                    this.errorMessage = PopulationModelWizardMessages.getString("NDizWizErr7");
                }
            }
        }
        if (bl) {
            text = (Text)this.map.get(StandardPackage.Literals.STANDARD_POPULATION_MODEL__TIME_PERIOD);
            boolean bl5 = bl = !text.getText().equals("");
            if (!bl) {
                this.errorMessage = PopulationModelWizardMessages.getString("NDizWizErr8");
            } else {
                bl = this.isValidLong(text.getText(), 0L);
                if (!bl) {
                    this.errorMessage = PopulationModelWizardMessages.getString("NDizWizErr9");
                }
            }
        }
        if (bl && (text = (Text)this.map.get(StandardPackage.Literals.STOCHASTIC_STANDARD_POPULATION_MODEL__GAIN)) != null) {
            boolean bl6 = bl = !text.getText().equals("");
            if (!bl) {
                this.errorMessage = PopulationModelWizardMessages.getString("NDizWizErr10");
            } else {
                bl = this.isValidValue(text.getText(), 0.0);
                if (!bl) {
                    this.errorMessage = PopulationModelWizardMessages.getString("NDizWizErr10");
                }
            }
        }
        return bl;
    }
}

