/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.example.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.diseasemodels.example.ExampleDiseaseModel;
import org.eclipse.stem.diseasemodels.example.ExamplePackage;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.SILabelValue;
import org.eclipse.stem.diseasemodels.standard.SIRLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.impl.SIRLabelValueImpl;
import org.eclipse.stem.diseasemodels.standard.impl.StochasticSIRDiseaseModelImpl;

public class ExampleDiseaseModelImpl
extends StochasticSIRDiseaseModelImpl
implements ExampleDiseaseModel {
    protected static final double SEASONAL_MODULATION_EXPONENT_EDEFAULT = 2.0;
    protected double seasonalModulationExponent = 2.0;
    protected static final double MODULATION_PERIOD_EDEFAULT = 365.256363051;
    protected double modulationPeriod = 365.256363051;
    protected static final double MODULATION_PHASE_SHIFT_EDEFAULT = 0.0;
    protected double modulationPhaseShift = 0.0;
    protected static final double SEASONAL_MODULATION_FLOOR_EDEFAULT = 0.6;
    protected double seasonalModulationFloor = 0.6;
    private double falseHiddenTimeExample = 0.0;
    private static final double MILLIS_PER_DAY = 8.64E7;
    private static final double MILLIS_PER_YEAR = 3.15581497676064E10;

    public StandardDiseaseModelLabelValue computeDiseaseDeltas(STEMTime sTEMTime, StandardDiseaseModelLabelValue standardDiseaseModelLabelValue, StandardDiseaseModelLabel standardDiseaseModelLabel, long l, DiseaseModelLabelValue diseaseModelLabelValue) {
        SIRLabelValue sIRLabelValue = (SIRLabelValue)standardDiseaseModelLabelValue;
        double d = sTEMTime.getTime().getTime();
        double d2 = this.getSeasonalModulationExponent();
        double d3 = this.getSeasonalModulationFloor();
        double d4 = this.getModulationPhaseShift();
        double d5 = d3 + (1.0 - d3) * Math.pow(Math.abs(Math.sin(d4 + Math.PI * d / (this.getModulationPeriod() * 8.64E7))), d2);
        double d6 = d5 * this.getAdjustedTransmissionRate(l);
        if (!this.isFrequencyDependent()) {
            d6 *= this.getTransmissionRateScaleFactor(standardDiseaseModelLabel);
        }
        double d7 = this.getNormalizedEffectiveInfectious(standardDiseaseModelLabel.getNode(), standardDiseaseModelLabel, sIRLabelValue.getI());
        double d8 = this.getAdjustedRecoveryRate(l) * sIRLabelValue.getI();
        double d9 = this.getAdjustedImmunityLossRate(l) * sIRLabelValue.getR();
        double d10 = 0.0;
        d10 = this.getNonLinearityCoefficient() != 1.0 && d7 >= 0.0 ? d6 * sIRLabelValue.getS() * Math.pow(d7, this.getNonLinearityCoefficient()) : d6 * sIRLabelValue.getS() * d7;
        double d11 = d9 - d10;
        double d12 = d10 - d8;
        double d13 = d8 - d9;
        SIRLabelValueImpl sIRLabelValueImpl = (SIRLabelValueImpl)diseaseModelLabelValue;
        sIRLabelValueImpl.setS(d11);
        sIRLabelValueImpl.setI(d12);
        sIRLabelValueImpl.setIncidence(d8);
        sIRLabelValueImpl.setR(d13);
        sIRLabelValueImpl.setDiseaseDeaths(0.0);
        return sIRLabelValueImpl;
    }

    public void doModelSpecificAdjustments(StandardDiseaseModelLabelValue standardDiseaseModelLabelValue) {
        SILabelValue sILabelValue = (SILabelValue)standardDiseaseModelLabelValue;
        double d = sILabelValue.getI();
        double d2 = sILabelValue.getI() * this.computeNoise();
        double d3 = d - d2;
        sILabelValue.setI(d2);
        double d4 = sILabelValue.getS() + d3;
        if (d4 < 0.0) {
            double d5 = (sILabelValue.getS() + d4) / sILabelValue.getS();
            sILabelValue.setI(d2 * d5);
        } else {
            sILabelValue.setS(d4);
        }
    }

    protected EClass eStaticClass() {
        return ExamplePackage.Literals.EXAMPLE_DISEASE_MODEL;
    }

    public double getSeasonalModulationExponent() {
        return this.seasonalModulationExponent;
    }

    public void setSeasonalModulationExponent(double d) {
        double d2 = this.seasonalModulationExponent;
        this.seasonalModulationExponent = d;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 31, d2, this.seasonalModulationExponent));
        }
    }

    public double getModulationPeriod() {
        return this.modulationPeriod;
    }

    public void setModulationPeriod(double d) {
        double d2 = this.modulationPeriod;
        this.modulationPeriod = d;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 32, d2, this.modulationPeriod));
        }
    }

    public double getModulationPhaseShift() {
        return this.modulationPhaseShift;
    }

    public void setModulationPhaseShift(double d) {
        double d2 = this.modulationPhaseShift;
        this.modulationPhaseShift = d;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 33, d2, this.modulationPhaseShift));
        }
    }

    public double getSeasonalModulationFloor() {
        return this.seasonalModulationFloor;
    }

    public void setSeasonalModulationFloor(double d) {
        double d2 = this.seasonalModulationFloor;
        this.seasonalModulationFloor = d;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 34, d2, this.seasonalModulationFloor));
        }
    }

    public Object eGet(int n, boolean bl, boolean bl2) {
        switch (n) {
            case 31: {
                return new Double(this.getSeasonalModulationExponent());
            }
            case 32: {
                return new Double(this.getModulationPeriod());
            }
            case 33: {
                return new Double(this.getModulationPhaseShift());
            }
            case 34: {
                return new Double(this.getSeasonalModulationFloor());
            }
        }
        return super.eGet(n, bl, bl2);
    }

    public void eSet(int n, Object object) {
        switch (n) {
            case 31: {
                this.setSeasonalModulationExponent((Double)object);
                return;
            }
            case 32: {
                this.setModulationPeriod((Double)object);
                return;
            }
            case 33: {
                this.setModulationPhaseShift((Double)object);
                return;
            }
            case 34: {
                this.setSeasonalModulationFloor((Double)object);
                return;
            }
        }
        super.eSet(n, object);
    }

    public void eUnset(int n) {
        switch (n) {
            case 31: {
                this.setSeasonalModulationExponent(2.0);
                return;
            }
            case 32: {
                this.setModulationPeriod(365.256363051);
                return;
            }
            case 33: {
                this.setModulationPhaseShift(0.0);
                return;
            }
            case 34: {
                this.setSeasonalModulationFloor(0.6);
                return;
            }
        }
        super.eUnset(n);
    }

    public boolean eIsSet(int n) {
        switch (n) {
            case 31: {
                return this.seasonalModulationExponent != 2.0;
            }
            case 32: {
                return this.modulationPeriod != 365.256363051;
            }
            case 33: {
                return this.modulationPhaseShift != 0.0;
            }
            case 34: {
                return this.seasonalModulationFloor != 0.6;
            }
        }
        return super.eIsSet(n);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(" (seasonalModulationExponent: ");
        stringBuffer.append(this.seasonalModulationExponent);
        stringBuffer.append(", modulationPeriod: ");
        stringBuffer.append(this.modulationPeriod);
        stringBuffer.append(", modulationPhaseShift: ");
        stringBuffer.append(this.modulationPhaseShift);
        stringBuffer.append(", seasonalModulationFloor: ");
        stringBuffer.append(this.seasonalModulationFloor);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

