/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.ge;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.stem.ui.ge.GELog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Aspect {
    private String code = null;
    private String name = null;
    private String description = null;
    public static final String PROPERTIES_NAME = "aspect.properties";
    public static final double[] DEFAULT_RANGE = new double[]{0.0, 0.33, 0.66, 1.0};
    public static final int[] DEFAULT_OPACITY;
    private double[] range = DEFAULT_RANGE;
    private int[] opacity = DEFAULT_OPACITY;
    private int[] red = null;
    private int[] green = null;
    private int[] blue = null;
    private String type = "relative";
    private String unit = null;
    private static Map<String, Aspect> map;
    private static String defaultAspect;
    private static String kmlDisplayClass;
    private static Properties properties;

    static {
        int[] nArray = new int[4];
        nArray[1] = 128;
        nArray[2] = 160;
        nArray[3] = 192;
        DEFAULT_OPACITY = nArray;
        map = null;
        defaultAspect = "";
        kmlDisplayClass = "org.eclipse.stem.ui.ge.kml.KmlDisplay";
        properties = new Properties();
    }

    public static void setup() {
        try {
            InputStream inputStream = Aspect.class.getResourceAsStream(PROPERTIES_NAME);
            if (inputStream != null) {
                properties.load(inputStream);
                map = null;
                Aspect.getAspects(properties);
            } else {
                GELog.error("Failed reading Aspect properties. aspect.properties", null);
                if (map == null) {
                    map = new HashMap<String, Aspect>(5);
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static void getAspects(Properties properties) {
        String string = properties.getProperty("Aspects", "S,E,I,R");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (defaultAspect == null || defaultAspect.length() == 0) {
                defaultAspect = string2;
            }
            String string3 = properties.getProperty(String.valueOf(string2) + ".name", null);
            Aspect aspect = new Aspect(string2, string3);
            String string4 = properties.getProperty(String.valueOf(string2) + ".description", null);
            aspect.setDescription(string4);
            String string5 = properties.getProperty(String.valueOf(string2) + ".range", null);
            aspect.setRange(string5);
            String string6 = properties.getProperty(String.valueOf(string2) + ".opacity", null);
            aspect.setOpacity(string6);
            String string7 = properties.getProperty(String.valueOf(string2) + ".red", "0");
            aspect.setRed(string7);
            string7 = properties.getProperty(String.valueOf(string2) + ".green", "0");
            aspect.setGreen(string7);
            string7 = properties.getProperty(String.valueOf(string2) + ".blue", "0");
            aspect.setBlue(string7);
        }
        defaultAspect = properties.getProperty("Default", defaultAspect);
        kmlDisplayClass = properties.getProperty("kmlDisplay", kmlDisplayClass);
    }

    public Aspect(String string, String string2) {
        this.code = string;
        this.name = string2;
        if (this.red == null) {
            this.setRed("0");
        }
        if (this.green == null) {
            this.setGreen("0");
        }
        if (this.blue == null) {
            this.setBlue("0");
        }
        if (map == null) {
            map = new HashMap<String, Aspect>(5);
        }
        map.put(string, this);
    }

    public boolean isSane() {
        try {
            Assert.isNotNull((Object)this.range);
            int n = this.range.length;
            Assert.isTrue((this.opacity.length == n ? 1 : 0) != 0, (String)"Invalid Opacity dimension");
            Assert.isTrue((this.red.length == n ? 1 : 0) != 0, (String)"Invalid Color Red dimension");
            Assert.isTrue((this.green.length == n ? 1 : 0) != 0, (String)"Invalid Color Blue dimension");
            Assert.isTrue((this.blue.length == n ? 1 : 0) != 0, (String)"Invalid Color Green dimension");
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            return false;
        }
        return true;
    }

    public static Aspect getAspect(String string) {
        Aspect aspect = null;
        if (map == null) {
            Aspect.setup();
        }
        if (map != null) {
            aspect = map.get(string);
            if (aspect == null) {
                aspect = map.get(defaultAspect);
            }
        } else {
            GELog.error("Invalid condition. Aspect map is null", null);
        }
        return aspect;
    }

    public static boolean exists(String string) {
        return map.containsKey(string);
    }

    public static Map<String, Aspect> getMap() {
        return map;
    }

    public static void setMap(Map<String, Aspect> map) {
        Aspect.map = map;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String string) {
        map.remove(this.code);
        this.code = string;
        map.put(string, this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String toString() {
        return this.code;
    }

    public String getDescription() {
        if (this.description == null) {
            return this.name;
        }
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public double[] getRange() {
        return this.range;
    }

    public double getRange(int n) {
        return this.range[n];
    }

    public void setRange(String string) {
        if (string == null) {
            this.range = DEFAULT_RANGE;
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = stringTokenizer.countTokens();
        this.range = new double[n];
        int n2 = 0;
        while (n2 < n) {
            double d;
            this.range[n2] = d = Double.parseDouble(stringTokenizer.nextToken().trim());
            ++n2;
        }
    }

    public int[] getOpacity() {
        return this.opacity;
    }

    public int getOpacity(int n) {
        return this.opacity[n];
    }

    public void setOpacity(String string) {
        int n = this.getRange().length;
        this.opacity = new int[n];
        if (string == null) {
            this.opacity[0] = 0;
            int n2 = 1;
            while (n2 < n) {
                this.opacity[n2] = DEFAULT_OPACITY[n2];
                ++n2;
            }
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            if (stringTokenizer.hasMoreTokens()) {
                n3 = Integer.parseInt(stringTokenizer.nextToken().trim());
            }
            this.opacity[n4] = n3;
            ++n4;
        }
    }

    public void setRed(String string) {
        int n = this.getRange().length;
        this.red = new int[n];
        if (string == null) {
            int n2 = 0;
            while (n2 < n) {
                this.red[n2] = 0;
                ++n2;
            }
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            if (stringTokenizer.hasMoreTokens()) {
                n3 = Integer.parseInt(stringTokenizer.nextToken().trim());
            }
            this.red[n4] = n3;
            ++n4;
        }
    }

    public void setGreen(String string) {
        int n = this.getRange().length;
        this.green = new int[n];
        if (string == null) {
            int n2 = 0;
            while (n2 < n) {
                this.green[n2] = 0;
                ++n2;
            }
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            if (stringTokenizer.hasMoreTokens()) {
                n3 = Integer.parseInt(stringTokenizer.nextToken().trim());
            }
            this.green[n4] = n3;
            ++n4;
        }
    }

    public void setBlue(String string) {
        int n = this.getRange().length;
        this.blue = new int[n];
        if (string == null) {
            int n2 = 0;
            while (n2 < n) {
                this.blue[n2] = 0;
                ++n2;
            }
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            if (stringTokenizer.hasMoreTokens()) {
                n3 = Integer.parseInt(stringTokenizer.nextToken());
            }
            this.blue[n4] = n3;
            ++n4;
        }
    }

    public int getRed(int n) {
        return this.red[n];
    }

    public int getGreen(int n) {
        return this.green[n];
    }

    public int getBlue(int n) {
        return this.blue[n];
    }

    public void setRange(double[] dArray) {
        this.range = dArray;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public static Aspect getDefault() {
        String string = Aspect.getDefaultCode();
        return Aspect.getAspect(string);
    }

    public static String getDefaultCode() {
        return defaultAspect;
    }

    public static void setDefaultCode(String string) {
        defaultAspect = string;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String string) {
        this.unit = string;
    }

    public static String getKmlDisplayClass() {
        return kmlDisplayClass;
    }

    public static Properties getProperties() {
        return properties;
    }
}

