/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.ge;

import java.awt.Polygon;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLong;
import org.eclipse.stem.ui.ge.Aspect;
import org.eclipse.stem.ui.ge.views.GEPreferencePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GEData {
    private String name = "";
    private String description = "";
    private String id = "";
    private static final DecimalFormat df = new DecimalFormat("####.##");
    private LatLong polygons = null;
    private final Map<String, Double> valueMap = new HashMap<String, Double>(8);
    private Rectangle bBox = null;
    private double[] placemark = null;

    public GEData(String string, LatLong latLong) {
        this.name = string;
        this.id = string;
        this.polygons = latLong;
        if (GEPreferencePage.isBBOX()) {
            this.bBox = GEData.getBBox(latLong);
        }
    }

    public GEData(String string, String string2, LatLong latLong) {
        this.name = string2;
        this.id = string;
        this.polygons = latLong;
        if (GEPreferencePage.isBBOX()) {
            this.bBox = GEData.getBBox(latLong);
        }
    }

    public String getCoordinatesAsString(int n) {
        LatLong.Segment segment = (LatLong.Segment)this.polygons.getSegments().get(n);
        StringBuffer stringBuffer = new StringBuffer(400);
        int n2 = segment.size();
        int n3 = 0;
        while (n3 < n2) {
            stringBuffer.append(df.format(segment.longitude(n3)));
            stringBuffer.append(",");
            stringBuffer.append(df.format(segment.latitude(n3)));
            stringBuffer.append(" ");
            ++n3;
        }
        return stringBuffer.toString();
    }

    public String getValuesAsString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        for (Map.Entry<String, Double> entry : this.valueMap.entrySet()) {
            stringBuffer.append(entry.getKey());
            stringBuffer.append(":");
            stringBuffer.append(df.format(entry.getValue()));
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public int getNumAreas() {
        if (this.polygons != null) {
            return this.polygons.size();
        }
        return 0;
    }

    public String getName() {
        return this.name;
    }

    public Rectangle getBBox() {
        return this.bBox;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public void setPoint(double d, double d2) {
        this.placemark = new double[2];
        this.placemark[0] = d;
        this.placemark[1] = d2;
    }

    public double[] getPoint() {
        return this.placemark;
    }

    private static Rectangle getBBox(LatLong latLong) {
        List list = latLong.getSegments();
        int n = list.size();
        Rectangle rectangle = null;
        int n2 = 0;
        while (n2 < n) {
            Polygon polygon = new Polygon();
            LatLong.Segment segment = (LatLong.Segment)list.get(n2);
            int n3 = segment.size();
            int n4 = 0;
            while (n4 < n3) {
                double d = segment.longitude(n4);
                double d2 = segment.latitude(n4);
                int n5 = (int)((d + 180.0) * 1000.0);
                int n6 = (int)((d2 + 90.0) * 1000.0);
                polygon.addPoint(n5, n6);
                ++n4;
            }
            rectangle = rectangle == null ? polygon.getBounds() : rectangle.union(polygon.getBounds());
            ++n2;
        }
        return rectangle;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("GEData: ");
        stringBuffer.append(this.getValuesAsString());
        stringBuffer.append(" BBox:" + this.bBox);
        stringBuffer.append(" : ");
        int n = 0;
        while (n < this.polygons.size()) {
            stringBuffer.append(this.getCoordinatesAsString(n));
            ++n;
        }
        return stringBuffer.toString();
    }

    public Map<String, Double> getValueMap() {
        return this.valueMap;
    }

    public double getValue(Aspect aspect) {
        return this.valueMap.get(aspect.getCode());
    }

    public void setValue(Aspect aspect, double d) {
        this.valueMap.put(aspect.getCode(), d);
    }

    public double[] getBBoxCenter() {
        if (this.bBox == null) {
            this.bBox = GEData.getBBox(this.polygons);
        }
        if (this.bBox != null) {
            double d = this.bBox.getCenterX();
            d = (d - 180000.0) / 1000.0;
            double d2 = this.bBox.getCenterY();
            d2 = (d2 - 90000.0) / 1000.0;
            double[] dArray = new double[]{d, d2};
            return dArray;
        }
        return null;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }
}

