/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.ge;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.stem.core.common.DublinCore;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.core.model.Model;
import org.eclipse.stem.core.scenario.Scenario;
import org.eclipse.stem.core.sequencer.Sequencer;
import org.eclipse.stem.data.geography.GeographicNames;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProvider;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapter;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapterFactory;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLong;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLongProvider;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLongProviderAdapter;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLongProviderAdapterFactory;
import org.eclipse.stem.definitions.adapters.spatial.geo.PlatformLatLongDataProvider;
import org.eclipse.stem.definitions.nodes.impl.RegionImpl;
import org.eclipse.stem.jobs.Activator;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.ISimulationListener;
import org.eclipse.stem.jobs.simulation.ISimulationManagerListener;
import org.eclipse.stem.jobs.simulation.SimulationEvent;
import org.eclipse.stem.jobs.simulation.SimulationManager;
import org.eclipse.stem.jobs.simulation.SimulationManagerEvent;
import org.eclipse.stem.jobs.simulation.SimulationState;
import org.eclipse.stem.ui.ge.Aspect;
import org.eclipse.stem.ui.ge.GEData;
import org.eclipse.stem.ui.ge.GEJob;
import org.eclipse.stem.ui.ge.GELog;
import org.eclipse.stem.ui.ge.GESimEntry;
import org.eclipse.stem.ui.ge.kml.KmlDisplaySelection;
import org.eclipse.stem.ui.ge.kml.StemKml;
import org.eclipse.stem.ui.ge.views.GEPreferencePage;
import org.eclipse.stem.ui.ge.views.GEView;
import org.eclipse.stem.ui.views.geographic.map.GeographicSelectionElements;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GEInterface
implements ISimulationListener,
ISimulationManagerListener {
    private static final String controlTemplate = "control_&N_&T.kml";
    private Map<String, GESimEntry> activeSimulations = null;
    private Map<String, GEData> stemMap = null;
    private GEView geView = null;
    private String activeView = null;
    private String displayNode = null;
    private Map<String, GEData> stemMapNode = null;
    private Aspect defaultAspect = null;
    private String errorMessage = null;
    private boolean manualRequest = false;
    private final KmlDisplaySelection displaySelection = new KmlDisplaySelection();
    private boolean didDisplayArea = false;

    public GEInterface(GEView gEView) {
        GELog.debug(this, "constructor: ");
        this.geView = gEView;
        Aspect.setup();
        this.activeSimulations = new HashMap<String, GESimEntry>(1);
    }

    public boolean init() {
        String string2;
        boolean bl = true;
        boolean bl2 = true;
        SimulationManager simulationManager = SimulationManager.getManager();
        simulationManager.addSimulationManagerListener((ISimulationManagerListener)this);
        List list = simulationManager.getActiveSimulations();
        boolean bl3 = GEPreferencePage.isAutoLogging();
        for (String string2 : list) {
            String string3 = GEInterface.getSimulationId((ISimulation)string2);
            GELog.debug(this, "simulationAdded: " + string3 + " " + string2);
            this.setActive((ISimulation)string2, bl3);
        }
        string2 = StemKml.initWebServer();
        GELog.debug(this, "Web server URL: " + string2);
        if (string2 == null) {
            this.setErrorMessage("Unable to access WebServer");
            bl = false;
        } else {
            bl2 = StemKml.verifyGE();
            if (!bl2) {
                this.setErrorMessage("GoogleEarth KML files are not defined");
            }
        }
        if (!(bl && bl2 || (bl = this.checkPreferences(string2, bl2)))) {
            GELog.debug(this.getErrorMessage());
        }
        return bl;
    }

    private boolean checkPreferences(String string, boolean bl) {
        boolean bl2 = false;
        int n = GEPreferencePage.getMethod();
        int n2 = -1;
        switch (n) {
            case 1: {
                bl2 = true;
                break;
            }
            case 2: {
                bl2 = false;
                if (string == null && bl) {
                    n2 = 4;
                    this.errorMessage = "No WebServer: Changed to directly launch KML";
                    break;
                }
                n2 = 1;
                this.errorMessage = "KML is not recognized, Changed to only Log files";
                break;
            }
            case 3: {
                if (string == null && bl) {
                    n2 = 4;
                    this.errorMessage = "No WebServer: Changed to directly launch KML";
                    break;
                }
                n2 = 1;
                this.errorMessage = "KML is not recognized, Changed to only Log files";
                break;
            }
            case 4: {
                if (bl) break;
                n2 = 1;
                this.errorMessage = "KML is not recognized, Changed to only Log files";
                break;
            }
        }
        if (n2 != -1) {
            GEPreferencePage.setMethod(n2);
            bl2 = false;
        }
        return bl2;
    }

    public void simulationsChanged(SimulationManagerEvent simulationManagerEvent) {
        block6: {
            block5: {
                GELog.debug(this.getClass(), "simulationsChanged: ");
                if (simulationManagerEvent.getSimulationsRemoved().length <= 0) break block5;
                ISimulation[] iSimulationArray = simulationManagerEvent.getSimulationsRemoved();
                int n = iSimulationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ISimulation iSimulation = iSimulationArray[n2];
                    String string = GEInterface.getSimulationId(iSimulation);
                    GELog.debug(this.getClass(), "simulationRemoved: " + string + " " + iSimulation);
                    GESimEntry gESimEntry = this.activeSimulations.get(string);
                    if (gESimEntry != null) {
                        boolean bl = this.isActiveView(iSimulation);
                        this.setActive(iSimulation, false);
                        this.activeSimulations.remove(string);
                        if (bl) {
                            this.stopGE();
                        }
                        GELog.debug(this, "Active simulation removed: " + string);
                    }
                    ++n2;
                }
                break block6;
            }
            if (simulationManagerEvent.getSimulationsAdded().length <= 0) break block6;
            boolean bl = GEPreferencePage.isAutoLogging();
            ISimulation[] iSimulationArray = simulationManagerEvent.getSimulationsAdded();
            int n = iSimulationArray.length;
            int n3 = 0;
            while (n3 < n) {
                boolean bl2;
                ISimulation iSimulation = iSimulationArray[n3];
                String string = GEInterface.getSimulationId(iSimulation);
                GELog.debug(this, "simulationAdded: " + string + " " + iSimulation);
                GESimEntry gESimEntry = this.activeSimulations.get(string);
                if (gESimEntry == null && !(bl2 = this.setActive(iSimulation, bl)) && !bl) {
                    this.geView.showMessage(this.errorMessage);
                }
                ++n3;
            }
        }
    }

    public void dispose() {
        SimulationManager simulationManager = SimulationManager.getManager();
        List list = simulationManager.getActiveSimulations();
        for (ISimulation iSimulation : list) {
            iSimulation.removeSimulationListener((ISimulationListener)this);
        }
        simulationManager.removeListener((ISimulationManagerListener)this);
        if (this.activeView != null) {
            this.stopGE();
            try {
                Thread.sleep(5000L);
            }
            catch (Exception exception) {}
        }
    }

    public void simulationChanged(SimulationEvent simulationEvent) {
        try {
            ISimulation iSimulation = simulationEvent.getSimulation();
            SimulationState simulationState = simulationEvent.getSimulationState();
            String string = GEInterface.getSimulationId(iSimulation);
            GESimEntry gESimEntry = this.activeSimulations.get(string);
            Sequencer sequencer = iSimulation.getScenario().getSequencer();
            if (simulationState == SimulationState.COMPLETED_CYCLE) {
                if (gESimEntry == null) {
                    GELog.debug(this, "Simulation " + string + " not active for GE.");
                    return;
                }
                int n = sequencer.getCycle();
                GELog.debug(this, String.valueOf(string) + " State=" + simulationState + " cycle=" + n);
                this.processCycle(iSimulation, simulationState);
                this.geView.refresh();
            } else {
                GELog.debug(this, String.valueOf(string) + " State=" + simulationState);
            }
        }
        catch (Exception exception) {
            GELog.error("simulationChanged: Failure ", exception);
        }
    }

    private void processCycle(ISimulation iSimulation, SimulationState simulationState) {
        StemKml stemKml;
        String string = null;
        boolean bl = false;
        int n = GEPreferencePage.getWhichCycle();
        String string2 = GEInterface.getSimulationId(iSimulation);
        GESimEntry gESimEntry = this.activeSimulations.get(string2);
        if (gESimEntry == null) {
            GELog.debug(this, "Simulation " + string2 + " not active for GE.");
            return;
        }
        int n2 = gESimEntry.getMethod();
        String string3 = gESimEntry.getLogFolder();
        Scenario scenario = iSimulation.getScenario();
        Sequencer sequencer = scenario.getSequencer();
        int n3 = sequencer.getCycle();
        if (GELog.memoryCheck(0.8)) {
            GELog.debug(this, "Process for cycle " + n3 + " skipped. Memory low");
            return;
        }
        this.stemMap = gESimEntry.getStemMap();
        if (this.stemMap == null) {
            if (!GELog.memoryCheck(0.8)) {
                this.stemMap = this.buildMap(iSimulation);
            }
            if (this.stemMap == null) {
                GELog.debug(this.getClass(), "Unable to build stemMap");
                return;
            }
            bl = true;
            gESimEntry.setStemMap(this.stemMap);
        }
        if ((stemKml = gESimEntry.getStemKml()) == null) {
            stemKml = new StemKml();
            gESimEntry.setStemKml(stemKml);
            stemKml.init();
        }
        if (n2 == 5 && !this.manualRequest) {
            return;
        }
        if (n3 == 0 || n == 1) {
            bl = true;
        } else if (n > 1 && n3 % n == 0) {
            bl = true;
        }
        Aspect aspect = this.getAspectToDisplay(iSimulation);
        if (this.manualRequest) {
            bl = true;
        }
        if (bl) {
            try {
                boolean bl2 = false;
                boolean bl3 = false;
                switch (n2) {
                    case 1: {
                        if (string3 != null) {
                            string = StemKml.getControlFN(string3, controlTemplate, aspect, n3);
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case 2: {
                        if (this.manualRequest) {
                            bl = true;
                            if (this.activeView == null) {
                                bl2 = true;
                                string = StemKml.getControlFile();
                                break;
                            }
                            string = StemKml.getControlFN(string3, controlTemplate, aspect, n3);
                            break;
                        }
                        if (!string2.equals(this.activeView)) {
                            bl = false;
                            GELog.debug(this, "Unable to display id " + string2);
                            break;
                        }
                        if (string3 != null) {
                            string = StemKml.getControlFN(string3, controlTemplate, aspect, n3);
                            break;
                        }
                        bl = false;
                        GELog.debug(this, "Unable to display. Invalid folder");
                        break;
                    }
                    case 3: {
                        if (this.manualRequest) {
                            if (this.activeView != null) {
                                bl = false;
                                GELog.debug(this, "Unable to do manual display");
                                break;
                            }
                            bl2 = true;
                            string = StemKml.getControlFile();
                            break;
                        }
                        if (!string2.equals(this.activeView)) {
                            bl = false;
                            GELog.debug(this, "Not an active Simulation id: " + string2 + " activeView: " + this.activeView);
                            break;
                        }
                        string = StemKml.getControlFile();
                        bl3 = true;
                        break;
                    }
                    case 4: {
                        bl2 = true;
                        string = StemKml.getControlFile();
                        if (this.manualRequest || string2.equals(this.activeView)) break;
                        bl = false;
                        GELog.debug(this, "Invalid. id: " + string2 + " activeView: " + this.activeView);
                        break;
                    }
                    case 5: {
                        if (this.manualRequest) {
                            GELog.debug(this, "Do manual display");
                            bl2 = true;
                            string = StemKml.getControlFile();
                            bl = true;
                            break;
                        }
                        bl = false;
                    }
                }
                this.manualRequest = false;
                if (bl) {
                    this.storeAspects(iSimulation, this.stemMap);
                    GELog.debug(this.getClass(), "GenerateKML for id: " + string2 + " aspect " + aspect.toString());
                    this.generateKML(string, stemKml, this.stemMap, aspect, n3, bl2, bl3);
                }
            }
            catch (Exception exception) {
                GELog.error("processCycle(): Failure creating KML ", exception);
                this.activeSimulations.remove(string2);
            }
        }
    }

    public boolean displayArea(String string, String string2, boolean bl) {
        Map<String, GEData> map;
        StemKml stemKml;
        String string3;
        boolean bl2;
        block8: {
            block7: {
                this.displayNode = string2;
                this.didDisplayArea = true;
                this.errorMessage = null;
                bl2 = true;
                if (bl) {
                    this.stemMapNode = null;
                }
                GELog.debug(this, "displayMap() " + string + " search: " + string2);
                if (string != null) break block7;
                this.errorMessage = "AdminFile argument is null";
                GELog.debug(this, this.errorMessage);
                return false;
            }
            string3 = StemKml.getDisplayAreaFile();
            stemKml = new StemKml();
            stemKml.init();
            map = this.buildMap(string, string2);
            if (map.size() != 0) break block8;
            this.errorMessage = "Search argument " + string2 + " did not match any admin area name.";
            return false;
        }
        try {
            if (this.stemMapNode == null) {
                this.stemMapNode = map;
            } else {
                this.stemMapNode.putAll(map);
            }
            Aspect aspect = Aspect.getAspect("S");
            boolean bl3 = false;
            int n = 0;
            boolean bl4 = true;
            this.generateKML(string3, stemKml, this.stemMapNode, aspect, n, bl4, bl3);
        }
        catch (RuntimeException runtimeException) {
            bl2 = false;
            GELog.error("DisplayArea failure", runtimeException);
        }
        this.displayNode = null;
        return bl2;
    }

    public boolean displaySelection(RegionImpl regionImpl, GeographicSelectionElements geographicSelectionElements) {
        Map<String, GEData> map;
        String string;
        boolean bl;
        block3: {
            this.didDisplayArea = true;
            this.errorMessage = null;
            bl = true;
            string = StemKml.getDisplayAreaFile();
            StemKml stemKml = new StemKml();
            stemKml.init();
            map = this.buildSelectionMap(regionImpl, geographicSelectionElements);
            if (!(map == null | map.size() == 0)) break block3;
            return false;
        }
        try {
            this.stemMapNode = this.stemMapNode == null ? map : map;
            Aspect aspect = null;
            this.displaySelection.generatePolygons(string, this.stemMapNode, aspect);
            StemKml.launch(string);
            GELog.debug(this, "GoogleEarth Map  submitted");
        }
        catch (RuntimeException runtimeException) {
            bl = false;
            GELog.error("DisplayArea failure", runtimeException);
        }
        this.displayNode = null;
        return bl;
    }

    public boolean displayMap(ISimulation iSimulation) {
        boolean bl = true;
        SimulationState simulationState = iSimulation.getSimulationState();
        GELog.debug(this, "DisplayMap request");
        this.manualRequest = true;
        if (simulationState != SimulationState.RUNNING) {
            this.processCycle(iSimulation, iSimulation.getSimulationState());
        }
        return bl;
    }

    public boolean runGE(String string) {
        boolean bl = true;
        GELog.debug(this, "GoogleEarth run request");
        if (this.activeView == null) {
            this.activeView = "runGE";
            StemKml.setWaitForKML(false);
            StemKml.launchNetworkLink(string, null);
        } else {
            this.errorMessage = "GoogleEarth is busy";
            GELog.debug(this, this.errorMessage);
            bl = false;
        }
        return bl;
    }

    public boolean startGE() {
        boolean bl = true;
        GELog.debug(this, "GoogleEarth Start request");
        StemKml.launchGE();
        return bl;
    }

    public boolean restartGE() {
        GESimEntry gESimEntry;
        boolean bl = true;
        GELog.debug(this, "GoogleEarth Restart request");
        StemKml.launchGE();
        int n = 0;
        if (this.activeView != null && (gESimEntry = this.activeSimulations.get(this.activeView)) != null) {
            n = gESimEntry.getMethod();
            ISimulation iSimulation = gESimEntry.getSimulation();
            if (iSimulation.getSimulationState() == SimulationState.RUNNING) {
                this.errorMessage = "Simulation should be paused while restarting GoogleEarth";
                return false;
            }
            String string = gESimEntry.getLogFolder();
            if (n == 3 || n == 2) {
                StemKml.launchNetworkLink(string, null);
            }
        }
        return bl;
    }

    public boolean stopGE() {
        boolean bl = true;
        GELog.debug(this, "GoogleEarth Stop request");
        if (this.didDisplayArea) {
            StemKml.clearDisplayArea();
        }
        this.activeView = null;
        StemKml.launchGE();
        return bl;
    }

    private StemKml generateKML(String string, StemKml stemKml, Map<String, GEData> map, Aspect aspect, long l, boolean bl, boolean bl2) {
        try {
            GEJob gEJob = new GEJob("Generate KML");
            gEJob.generateKML(string, stemKml, map, aspect, l, bl, bl2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stemKml;
    }

    private void storeAspects(ISimulation iSimulation, Map<String, GEData> map) {
        Scenario scenario = iSimulation.getScenario();
        Graph graph = scenario.getCanonicalGraph();
        Decorator[] decoratorArray = (Decorator[])graph.getDecorators().toArray();
        int n = 0;
        int n2 = 0;
        Decorator[] decoratorArray2 = decoratorArray;
        int n3 = decoratorArray.length;
        int n4 = 0;
        while (n4 < n3) {
            Object[] objectArray;
            Decorator decorator = decoratorArray2[n4];
            Object[] objectArray2 = objectArray = decorator.getLabelsToUpdate().toArray();
            int n5 = objectArray.length;
            int n6 = 0;
            while (n6 < n5) {
                boolean bl;
                NodeLabel nodeLabel;
                Node node;
                String string;
                GEData gEData;
                Object object = objectArray2[n6];
                if (object instanceof NodeLabel && (gEData = map.get(string = (node = (nodeLabel = (NodeLabel)object).getNode()).getDublinCore().getTitle())) != null && (bl = this.filter(node, string, gEData))) {
                    RelativeValueProviderAdapter relativeValueProviderAdapter = (RelativeValueProviderAdapter)RelativeValueProviderAdapterFactory.INSTANCE.adapt(object, RelativeValueProvider.class);
                    relativeValueProviderAdapter.setTarget((Notifier)object);
                    if (relativeValueProviderAdapter != null) {
                        Map<String, Double> map2 = gEData.getValueMap();
                        for (ItemPropertyDescriptor itemPropertyDescriptor : relativeValueProviderAdapter.getProperties()) {
                            String string2 = itemPropertyDescriptor.getDisplayName((Object)itemPropertyDescriptor);
                            double d = relativeValueProviderAdapter.getRelativeValue(itemPropertyDescriptor);
                            if (!Aspect.exists(string2)) continue;
                            map2.put(string2, d);
                        }
                    } else {
                        ++n2;
                    }
                }
                ++n6;
            }
            ++n4;
        }
        if (n > 0) {
            GELog.debug(this, "Nodes with no LatLong data. count=" + n);
        }
        if (n2 > 0) {
            GELog.debug(this, "Nodes with no aspect values. count=" + n2);
        }
    }

    private Map<String, GEData> buildMap(ISimulation iSimulation) {
        Graph graph;
        block6: {
            this.stemMap = new HashMap<String, GEData>();
            Scenario scenario = iSimulation.getScenario();
            graph = scenario.getCanonicalGraph();
            if (graph != null) break block6;
            GELog.debug(this, "buildMap(): canonicalGraph is null");
            return null;
        }
        try {
            int n = 0;
            for (Node node : graph.getNodes().values()) {
                String string;
                boolean bl = this.filter(node, string = node.getDublinCore().getTitle(), null);
                if (!bl) continue;
                LatLong latLong = this.getLatLong(node);
                if (latLong != null && latLong.size() > 0) {
                    GEData gEData = new GEData(string, latLong);
                    this.stemMap.put(string, gEData);
                    continue;
                }
                ++n;
            }
            if (n > 0) {
                GELog.debug(this, "Total buildmap errors = " + n);
            }
        }
        catch (Throwable throwable) {
            GELog.error("Failure building area map", throwable);
            this.stemMap = null;
        }
        return this.stemMap;
    }

    boolean filter(Node node, String string, GEData gEData) {
        int n = this.getAreaType(node);
        if (n <= 0) {
            GELog.debug(this, "Skip AdminArea 0: " + node);
            return false;
        }
        if (this.displayNode != null) {
            this.displayNode = this.displayNode.toLowerCase();
            if (string.toLowerCase().contains(this.displayNode)) {
                GELog.debug(this, "Display: " + string);
                return true;
            }
            return false;
        }
        return true;
    }

    private String getAreaID(Node node) {
        DublinCore dublinCore = node.getDublinCore();
        String string = dublinCore.getIdentifier();
        String string2 = string.substring(string.lastIndexOf("/") + 1);
        return string2;
    }

    private String getAreaName(Node node) {
        DublinCore dublinCore = node.getDublinCore();
        String string = dublinCore.getIdentifier();
        String string2 = string.substring(string.lastIndexOf("/") + 1);
        if (string2 != null && string2 != "") {
            String string3 = GeographicNames.getName((String)string2);
            return string3;
        }
        return dublinCore.getTitle();
    }

    private int getAreaType(Node node) {
        String string;
        int n = -1;
        DublinCore dublinCore = node.getDublinCore();
        String string2 = dublinCore.getSpatial();
        if (string2 != null && (string = string2.substring(string2.lastIndexOf("/") + 1)) != null && string != "") {
            string = string.substring(0, string.indexOf("#"));
            string = string.substring(4, 5);
            n = Integer.parseInt(string);
        }
        return n;
    }

    private Map<String, GEData> buildSelectionMap(RegionImpl regionImpl, GeographicSelectionElements geographicSelectionElements) {
        try {
            DublinCore dublinCore = regionImpl.getDublinCore();
            String string = dublinCore.getSpatial();
            String string2 = string.replace("stemspatial:", "");
            this.stemMap = new HashMap<String, GEData>();
            PlatformLatLongDataProvider platformLatLongDataProvider = new PlatformLatLongDataProvider();
            URI uRI = URI.createURI((String)string2);
            LatLong latLong = platformLatLongDataProvider.getLatLong(uRI);
            String string3 = this.getAreaID((Node)regionImpl);
            String string4 = this.getAreaName((Node)regionImpl);
            GEData gEData = new GEData(string3, string4, latLong);
            gEData.setValue(Aspect.getAspect("S"), 1.0);
            String string5 = this.formatDescription(regionImpl, geographicSelectionElements);
            gEData.setDescription(string5);
            double d = geographicSelectionElements.getLongitude();
            double d2 = geographicSelectionElements.getLatitude();
            GELog.debug(String.valueOf(d) + ":" + d2);
            gEData.setPoint(d, d2);
            this.stemMap.put(string3, gEData);
        }
        catch (Throwable throwable) {
            GELog.error("Failure building area map", throwable);
            this.stemMap = null;
            this.errorMessage = "Exception while building Map";
        }
        return this.stemMap;
    }

    private Map<String, GEData> buildMap(String string, String string2) {
        String string3 = "platform:/plugin/org.eclipse.stem.geography/resources/data/geo/country/";
        try {
            String string4 = String.valueOf(string3) + string;
            this.stemMap = new HashMap<String, GEData>();
            PlatformLatLongDataProvider platformLatLongDataProvider = new PlatformLatLongDataProvider();
            URI uRI = URI.createURI((String)string4);
            Set set = platformLatLongDataProvider.getIds(uRI);
            if (set.size() == 0) {
                this.errorMessage = "Invalid Country code specified";
                return this.stemMap;
            }
            String string5 = string2.toLowerCase();
            for (String string6 : set) {
                if (!string6.toLowerCase().contains(string5)) continue;
                URI uRI2 = URI.createURI((String)(String.valueOf(string4) + "#" + string6));
                LatLong latLong = platformLatLongDataProvider.getLatLong(uRI2);
                if (latLong != null && latLong.size() > 0) {
                    GEData gEData = new GEData(string6, latLong);
                    gEData.setValue(Aspect.getAspect("S"), 1.0);
                    this.stemMap.put(string6, gEData);
                    continue;
                }
                GELog.debug(this, "No spacial data Name=" + string6);
            }
            if (set.size() == 0) {
                this.errorMessage = "No Matching internal Administration area found";
            }
        }
        catch (Throwable throwable) {
            GELog.error("Failure building area map", throwable);
            this.stemMap = null;
            this.errorMessage = "Exception while building Map";
        }
        return this.stemMap;
    }

    private String formatDescription(RegionImpl regionImpl, GeographicSelectionElements geographicSelectionElements) {
        StringBuffer stringBuffer = new StringBuffer(128);
        Map<String, Double> map = this.getRelValues(regionImpl);
        Set<String> set = map.keySet();
        stringBuffer.append("&lt;pre&gt;");
        stringBuffer.append(this.getAreaID((Node)regionImpl));
        stringBuffer.append(" &lt;br&gt;");
        for (String string : set) {
            Double d = map.get(string) * 100.0;
            String string2 = String.format("%8s: %5.1f%%", string, d);
            stringBuffer.append(string2);
            stringBuffer.append(" &lt;br&gt;");
        }
        stringBuffer.append("&lt;pre&gt;");
        return stringBuffer.toString();
    }

    private Map<String, Double> getRelValues(RegionImpl regionImpl) {
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        EList eList = regionImpl.getLabels();
        for (NodeLabel nodeLabel : eList) {
            RelativeValueProvider relativeValueProvider = (RelativeValueProvider)RelativeValueProviderAdapterFactory.INSTANCE.adapt((Notifier)nodeLabel, RelativeValueProvider.class);
            if (relativeValueProvider == null) continue;
            for (ItemPropertyDescriptor itemPropertyDescriptor : relativeValueProvider.getProperties()) {
                String string = itemPropertyDescriptor.getDisplayName((Object)itemPropertyDescriptor);
                Double d = relativeValueProvider.getRelativeValue(itemPropertyDescriptor);
                hashMap.put(string, d);
            }
        }
        return hashMap;
    }

    LatLong getLatLong(Node node) {
        try {
            LatLongProviderAdapter latLongProviderAdapter = (LatLongProviderAdapter)LatLongProviderAdapterFactory.INSTANCE.adapt((Notifier)node, LatLongProvider.class);
            latLongProviderAdapter.setTarget((Notifier)node);
            return latLongProviderAdapter.getLatLong();
        }
        catch (RuntimeException runtimeException) {
            GELog.debug(this, runtimeException.getMessage());
            return null;
        }
    }

    public boolean isActive(ISimulation iSimulation) {
        String string = GEInterface.getSimulationId(iSimulation);
        GESimEntry gESimEntry = this.activeSimulations.get(string);
        return gESimEntry == null ? false : gESimEntry.active;
    }

    public boolean isActiveView(ISimulation iSimulation) {
        String string = GEInterface.getSimulationId(iSimulation);
        return string.equals(this.activeView);
    }

    public boolean setActive(ISimulation iSimulation, boolean bl) {
        String string = GEInterface.getSimulationId(iSimulation);
        GESimEntry gESimEntry = this.activeSimulations.get(string);
        GELog.debug(this.getClass(), "setActive: " + string + "  " + bl);
        if (gESimEntry != null) {
            if (gESimEntry.active == bl) {
                return true;
            }
            gESimEntry.active = bl;
            if (!gESimEntry.active && string.equals(this.activeView)) {
                this.activeView = null;
            }
        } else {
            gESimEntry = new GESimEntry(string, iSimulation);
            gESimEntry.active = bl;
            this.activeSimulations.put(string, gESimEntry);
            gESimEntry.setAspectToDisplay(GEPreferencePage.getAspect());
            if (bl) {
                String string2 = gESimEntry.getLogFolder();
                int n = GEPreferencePage.getMethod();
                switch (n) {
                    case 1: {
                        if (this.geView != null) {
                            string2 = GEPreferencePage.getFolder();
                            string2 = this.geView.verifyFolder(string2);
                            gESimEntry.setLogFolder(string2);
                            gESimEntry.setMethod(n);
                        }
                        iSimulation.addSimulationListener((ISimulationListener)this);
                        break;
                    }
                    case 2: {
                        if (this.geView != null) {
                            string2 = GEPreferencePage.getFolder();
                            string2 = this.geView.verifyFolder(string2);
                            gESimEntry.setLogFolder(string2);
                        }
                        if (string2 == null) break;
                        if (this.activeView == null) {
                            StemKml.setWaitForKML(true);
                            StemKml.launchNetworkLink(string2, null);
                            this.activeView = string;
                            iSimulation.addSimulationListener((ISimulationListener)this);
                            gESimEntry.setMethod(n);
                            break;
                        }
                        this.errorMessage = "Simulation " + this.activeView + " already active on GoogleEarth.";
                        GELog.debug(this, this.errorMessage);
                        gESimEntry.active = false;
                        return false;
                    }
                    case 3: {
                        String string3 = StemKml.getControlFile();
                        File file = new File(string3);
                        String string4 = String.valueOf(file.getParent()) + File.separator;
                        string3 = file.getName();
                        string3 = String.valueOf(string4) + string3.replace(".", "_Current.");
                        if (this.activeView == null) {
                            StemKml.setWaitForKML(true);
                            StemKml.launchNetworkLink(string2, string3);
                            this.activeView = string;
                            iSimulation.addSimulationListener((ISimulationListener)this);
                            gESimEntry.setMethod(n);
                            break;
                        }
                        this.errorMessage = "Simulation " + this.activeView + " already active on GoogleEarth.";
                        GELog.debug(this, this.errorMessage);
                        gESimEntry.active = false;
                        return false;
                    }
                    case 4: {
                        if (this.activeView == null) {
                            this.activeView = string;
                            iSimulation.addSimulationListener((ISimulationListener)this);
                            gESimEntry.setMethod(n);
                            break;
                        }
                        this.errorMessage = "Simulation " + this.activeView + " already active on GoogleEarth.";
                        GELog.debug(this, this.errorMessage);
                        gESimEntry.active = false;
                        iSimulation.addSimulationListener((ISimulationListener)this);
                        return false;
                    }
                    case 5: {
                        iSimulation.addSimulationListener((ISimulationListener)this);
                        gESimEntry.setMethod(n);
                    }
                }
            }
        }
        return true;
    }

    public void setAspectToDisplay(ISimulation iSimulation, Aspect aspect) {
        if (iSimulation == null) {
            this.setDefaultAspect(aspect);
        } else {
            String string = GEInterface.getSimulationId(iSimulation);
            GESimEntry gESimEntry = this.activeSimulations.get(string);
            if (gESimEntry != null) {
                gESimEntry.setAspectToDisplay(aspect);
            } else {
                this.setDefaultAspect(aspect);
            }
        }
    }

    public Aspect getAspectToDisplay(ISimulation iSimulation) {
        String string = GEInterface.getSimulationId(iSimulation);
        GESimEntry gESimEntry = this.activeSimulations.get(string);
        Aspect aspect = null;
        aspect = gESimEntry != null ? gESimEntry.getAspectToDisplay() : this.getDefaultAspect();
        return aspect;
    }

    public void displayStatus() {
        boolean bl = GELog.DEBUG;
        GELog.DEBUG = true;
        GELog.debug(this, GEPreferencePage.display());
        Preferences preferences = Activator.getDefault().getPluginPreferences();
        boolean bl2 = preferences.getBoolean("cyclePause");
        int n = preferences.getInt("cyclePauseMilliSeconds") * 1000;
        GELog.debug(this, "SIMULATION_SLEEP: " + bl2);
        GELog.debug(this, "SIMULATION_SLEEP_SECONDS: " + n);
        GELog.debug(this, "activeView: " + this.activeView);
        if (this.activeSimulations.size() == 0) {
            GELog.debug(this, "No active Simulations");
        } else {
            GELog.debug(this, "Active Simulations: " + this.activeSimulations.size());
            for (Map.Entry<String, GESimEntry> entry : this.activeSimulations.entrySet()) {
                GESimEntry gESimEntry = entry.getValue();
                String string = entry.getKey();
                ISimulation iSimulation = gESimEntry.getSimulation();
                try {
                    GELog.debug(this, "  Simulation:  " + gESimEntry.toString());
                    GELog.debug(this, "  State: " + iSimulation.getSimulationState());
                    GESimEntry gESimEntry2 = this.activeSimulations.get(string);
                    GELog.debug(this, "  GESimEntry: " + gESimEntry2);
                    Scenario scenario = iSimulation.getScenario();
                    GELog.debug(this, "  Scenario: " + scenario);
                    DublinCore dublinCore = scenario.getDublinCore();
                    GELog.debug(this, "  Scenario DublinCore: " + dublinCore);
                    Sequencer sequencer = scenario.getSequencer();
                    GELog.debug(this, "  Sequencer: " + sequencer);
                    Model model = scenario.getModel();
                    GELog.debug(this, "  Model: " + model);
                }
                catch (Throwable throwable) {
                    GELog.error("Display Status failure", throwable);
                }
            }
        }
        GELog.DEBUG = bl;
    }

    private String displayLatLong(ISimulation iSimulation) {
        Graph graph;
        int n;
        StringBuilder stringBuilder;
        block7: {
            stringBuilder = new StringBuilder();
            n = 0;
            stringBuilder.append("LatLong data: ");
            Scenario scenario = iSimulation.getScenario();
            graph = scenario.getCanonicalGraph();
            GELog.debug(this, "displayLatLong(): canonicalGraph=" + graph);
            if (graph != null) break block7;
            GELog.debug(this, "displayLatLong(): canonicalGraph is null");
            return null;
        }
        try {
            Iterator iterator = graph.getNodes().values().iterator();
            while (iterator.hasNext()) {
                if (++n > 100) {
                    stringBuilder.append("\n Limit of 100 reached");
                    break;
                }
                Node node = (Node)iterator.next();
                String string = node.getDublinCore().getTitle();
                stringBuilder.append("\nNode: " + string);
                LatLongProviderAdapter latLongProviderAdapter = (LatLongProviderAdapter)LatLongProviderAdapterFactory.INSTANCE.adapt((Notifier)node, LatLongProvider.class);
                latLongProviderAdapter.setTarget((Notifier)node);
                LatLong latLong = latLongProviderAdapter.getLatLong();
                if (latLong != null && latLong.size() > 0) {
                    for (LatLong.Segment segment : latLong.getSegments()) {
                        String string2 = GEInterface.createStringOfLatLongData(segment);
                        stringBuilder.append("LatLong: " + string2);
                    }
                    continue;
                }
                GELog.debug(this, "buildMap()(): No spacial data for Node=" + string);
            }
        }
        catch (Throwable throwable) {
            GELog.error("Failure building area map", throwable);
        }
        return stringBuilder.toString();
    }

    private String displayAspect(ISimulation iSimulation) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Decorator[] decoratorArray;
            int n = 0;
            Scenario scenario = iSimulation.getScenario();
            Decorator[] decoratorArray2 = decoratorArray = (Decorator[])scenario.getCanonicalGraph().getDecorators().toArray();
            int n2 = decoratorArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Object[] objectArray;
                Decorator decorator = decoratorArray2[n3];
                GELog.debug(this, "decorator: " + decorator.toString());
                Object[] objectArray2 = objectArray = decorator.getLabelsToUpdate().toArray();
                int n4 = objectArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    Object object = objectArray2[n5];
                    if (++n > 100) {
                        stringBuilder.append("\n Limit of 100 reached");
                        break;
                    }
                    if (object instanceof NodeLabel) {
                        NodeLabel nodeLabel = (NodeLabel)object;
                        Node node = nodeLabel.getNode();
                        String string = node.getDublinCore().getTitle();
                        stringBuilder.append("\nNode: " + string + " ");
                        RelativeValueProviderAdapter relativeValueProviderAdapter = (RelativeValueProviderAdapter)RelativeValueProviderAdapterFactory.INSTANCE.adapt(object, RelativeValueProvider.class);
                        relativeValueProviderAdapter.setTarget((Notifier)object);
                        if (relativeValueProviderAdapter != null) {
                            Iterator iterator = relativeValueProviderAdapter.getProperties().iterator();
                            while (iterator.hasNext()) {
                                ItemPropertyDescriptor itemPropertyDescriptor = (ItemPropertyDescriptor)iterator.next();
                                stringBuilder.append(itemPropertyDescriptor.getDisplayName((Object)itemPropertyDescriptor));
                                stringBuilder.append(": ");
                                stringBuilder.append(String.format("%.2f", relativeValueProviderAdapter.getRelativeValue(itemPropertyDescriptor)));
                                if (!iterator.hasNext()) continue;
                                stringBuilder.append(", ");
                            }
                        }
                    }
                    ++n5;
                }
                ++n3;
            }
        }
        catch (Throwable throwable) {
            GELog.error("Failure getting SEIR data", throwable);
        }
        return stringBuilder.toString();
    }

    public static String getSimulationId(ISimulation iSimulation) {
        if (iSimulation != null) {
            return "SIM[" + Integer.toString(iSimulation.getSequenceNumber()) + "]";
        }
        return null;
    }

    private static String createStringOfLatLongData(LatLong.Segment segment) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = segment.size();
        int n2 = 0;
        while (n2 < n) {
            stringBuilder.append("(");
            stringBuilder.append(segment.latitude(n2));
            stringBuilder.append(", ");
            stringBuilder.append(segment.longitude(n2));
            stringBuilder.append(")");
            ++n2;
        }
        return stringBuilder.toString();
    }

    public Aspect getDefaultAspect() {
        if (this.defaultAspect == null) {
            this.defaultAspect = Aspect.getDefault();
        }
        return this.defaultAspect;
    }

    public void setDefaultAspect(Aspect aspect) {
        this.defaultAspect = aspect;
    }

    public void setErrorMessage(String string) {
        this.errorMessage = string;
    }

    public String getErrorMessage() {
        if (this.errorMessage == null) {
            return "";
        }
        return this.errorMessage;
    }

    public int getCycle(ISimulation iSimulation) {
        Scenario scenario = iSimulation.getScenario();
        Sequencer sequencer = scenario.getSequencer();
        int n = sequencer.getCycle();
        return n;
    }
}

