/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.ge;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.stem.jobs.Activator;
import org.eclipse.stem.ui.ge.Aspect;
import org.eclipse.stem.ui.ge.GEData;
import org.eclipse.stem.ui.ge.GELog;
import org.eclipse.stem.ui.ge.kml.StemKml;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GEJob
extends Thread {
    private String fn = null;
    private StemKml stemKml = null;
    private Map<String, GEData> stemMap = null;
    private Aspect aspect = null;
    private long cycle = 0L;
    private boolean launch = false;
    private boolean rename = false;
    private static Thread work = null;

    public GEJob(String string) {
        super(string);
    }

    @Override
    public void run() {
        GELog.debug(this, String.valueOf(this.fn) + " " + this.aspect + " " + this.cycle + " " + this.launch + " " + this.rename);
        try {
            if (this.rename) {
                File file = new File(this.fn);
                String string = String.valueOf(file.getParent()) + File.separator;
                this.fn = file.getName();
                String string2 = String.valueOf(string) + this.fn.replace(".", "_New.");
                String string3 = String.valueOf(string) + this.fn.replace(".", "_Current.");
                String string4 = String.valueOf(string) + this.fn.replace(".", "._Old");
                try {
                    File file2 = new File(string2);
                    File file3 = new File(string4);
                    File file4 = new File(string3);
                    this.stemKml.generatePolygons(string2, this.stemMap, this.aspect, this.cycle);
                    if (file3.exists()) {
                        file3.delete();
                    }
                    if (file4.exists()) {
                        file4.renameTo(file3);
                    }
                    file2.renameTo(file4);
                }
                catch (RuntimeException runtimeException) {
                    GELog.error("Failure creating KML files.  newFile: " + string2, runtimeException);
                }
            } else {
                this.stemKml.generatePolygons(this.fn, this.stemMap, this.aspect, this.cycle);
                if (this.launch) {
                    StemKml.launch(this.fn);
                    GELog.debug(this, "GoogleEarth Map  submitted");
                }
            }
        }
        catch (Throwable throwable) {
            GELog.error("Failure in interface to GoogleEarth. ", throwable);
        }
    }

    public void generateKML(String string, StemKml stemKml, Map<String, GEData> map, Aspect aspect, long l, boolean bl, boolean bl2) {
        this.fn = string;
        this.stemKml = stemKml;
        this.aspect = aspect;
        this.cycle = l;
        this.launch = bl;
        this.rename = bl2;
        if (l == 0L) {
            this.checkPreferences();
        }
        int n = map.size();
        this.stemMap = new HashMap<String, GEData>(n);
        this.stemMap.putAll(map);
        try {
            if (work != null && work.getState() != Thread.State.TERMINATED) {
                GELog.debug(this, "Skip KML generation for cycle " + l);
                return;
            }
            work = new Thread((Runnable)this, "Job_" + l);
            work.start();
        }
        catch (Exception exception) {
            GELog.error("Failure scheduling KML File generation", exception);
        }
    }

    protected void checkPreferences() {
        Preferences preferences = Activator.getDefault().getPluginPreferences();
        boolean bl = preferences.getBoolean("cyclePause");
        int n = preferences.getInt("cyclePauseMilliSeconds");
        if (!bl || n <= 1) {
            GELog.info("GEJob: Specified Sleep interval not specified \nor may be too short for GoogleEarth operation.\nCheck preferences.");
        }
    }
}

