/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.ge;

import java.util.Date;
import org.eclipse.stem.ui.ge.Activator;
import org.eclipse.stem.ui.ge.views.GEPreferencePage;

public class GELog {
    public static boolean DEBUG = false;
    private static final long start = new Date().getTime();

    public static void debug(String string) {
        if (DEBUG) {
            System.out.println("GE: " + string);
            System.out.flush();
        }
    }

    public static void debug(Object object, String string) {
        if (DEBUG) {
            Object object2;
            Object object3;
            String string2 = "";
            if (object instanceof String) {
                string2 = (String)object;
            } else if (object instanceof Class) {
                string2 = ((Class)object).getSimpleName();
            } else {
                string2 = object.getClass().getSimpleName();
                object3 = Thread.currentThread();
                object2 = ((Thread)object3).getStackTrace();
                if (object2[3].getClassName().contains(string2)) {
                    string2 = String.valueOf(string2) + "." + object2[3].getMethodName();
                }
            }
            object3 = String.valueOf(string2) + ": ";
            if (Activator.getDefault() != null && GEPreferencePage.isTest()) {
                object2 = GELog.getThread();
                String string3 = GELog.getClock();
                object3 = String.valueOf(string3) + " " + (String)object2 + "-" + (String)object3;
            }
            System.out.println(String.valueOf(object3) + string);
            System.out.flush();
        }
    }

    private static String getThread() {
        return Thread.currentThread().getName();
    }

    private static String getClock() {
        long l = new Date().getTime() - start;
        return Long.toString(l);
    }

    public static void info(Class clazz, String string) {
        GELog.info(String.valueOf(clazz.getSimpleName()) + ": " + string);
    }

    public static void info(String string) {
        if (DEBUG) {
            System.err.println(string);
        }
        Activator.logInfo(string, null);
    }

    public static void error(String string, Throwable throwable) {
        if (DEBUG) {
            System.err.println(string);
            if (throwable != null) {
                throwable.printStackTrace();
            }
        }
        System.err.flush();
        Activator.logError(string, throwable);
    }

    public static void memory() {
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {}
        GELog.debug("Memory Total: " + runtime.totalMemory() / 1024L + "K");
        GELog.debug("Memory Free:  " + runtime.freeMemory() / 1024L + "K");
        GELog.debug("Memory Max:   " + runtime.maxMemory() / 1024L + "K");
    }

    public static boolean memoryCheck(double d) {
        Runtime runtime = Runtime.getRuntime();
        GELog.debug("Memory Max:   " + runtime.maxMemory() / 1024L + "K");
        long l = runtime.totalMemory() - runtime.freeMemory();
        double d2 = (double)l / (double)runtime.maxMemory();
        GELog.debug("Memory Used:  " + l / 1024L + "K");
        GELog.debug("Percent Used: " + d2);
        if (d2 > d) {
            runtime.gc();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
            l = runtime.totalMemory() - runtime.freeMemory();
            d2 = (double)l / (double)runtime.maxMemory();
            GELog.debug("Memory used after GC:  " + l / 1024L + "K");
            GELog.debug("Percent Used: " + d2);
            return d2 > d;
        }
        return false;
    }

    public static void main(String[] stringArray) {
        DEBUG = true;
        GELog.debug("msg with no class.");
        GELog.debug(GELog.class, "msg with class specified");
        try {
            Object object = null;
            object.getClass();
        }
        catch (Throwable throwable) {
            GELog.error("Expected NullPointerException", throwable);
        }
    }
}

