/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.ge.kml;

import java.awt.Rectangle;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.stem.ui.ge.Aspect;
import org.eclipse.stem.ui.ge.GEData;
import org.eclipse.stem.ui.ge.GELog;
import org.eclipse.stem.ui.ge.kml.BBoxInfo;
import org.eclipse.stem.ui.ge.kml.IKmlDisplay;
import org.eclipse.stem.ui.ge.kml.KmlDoc;
import org.eclipse.stem.ui.ge.kml.PlaceMark;
import org.eclipse.stem.ui.ge.kml.Polygon;
import org.eclipse.stem.ui.ge.kml.StemKml;
import org.eclipse.stem.ui.ge.kml.Style;
import org.eclipse.stem.ui.ge.views.GEPreferencePage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KmlDisplay
implements IKmlDisplay {
    public void init() {
    }

    @Override
    public void generatePolygons(String string, Map<String, GEData> map, Aspect aspect) {
        int n = 0;
        KmlDoc kmlDoc = new KmlDoc();
        Document document = kmlDoc.getDocument();
        Element element = kmlDoc.setRoot(null);
        Element element2 = kmlDoc.appendElement(element, "Document");
        Style[] styleArray = this.setupStyles(kmlDoc, element2, aspect);
        int n2 = aspect.getRange().length;
        PlaceMark[] placeMarkArray = new PlaceMark[n2];
        Element[] elementArray = new Element[n2];
        int n3 = 0;
        while (n3 < n2) {
            placeMarkArray[n3] = new PlaceMark(document);
            element2.appendChild(placeMarkArray[n3].getElement());
            placeMarkArray[n3].setDescription("STEM map");
            placeMarkArray[n3].setName("STEM" + n3);
            placeMarkArray[n3].setStyleUrl(styleArray[n3]);
            elementArray[n3] = document.createElement("MultiGeometry");
            placeMarkArray[n3].appendChild(elementArray[n3]);
            ++n3;
        }
        Rectangle rectangle = BBoxInfo.getBBox();
        Iterator<Map.Entry<String, GEData>> iterator = map.entrySet().iterator();
        boolean bl = GEPreferencePage.isBBOX();
        while (iterator.hasNext()) {
            int n4 = 0;
            Map.Entry<String, GEData> entry = iterator.next();
            GEData gEData = entry.getValue();
            String string2 = gEData.getName();
            n4 = bl && this.filter(gEData, rectangle) ? 0 : this.selectByValue(aspect, gEData);
            if (n4 <= 0) continue;
            int n5 = gEData.getNumAreas();
            int n6 = 0;
            while (n6 < n5) {
                String string3 = gEData.getCoordinatesAsString(n6);
                Polygon polygon = new Polygon(document);
                kmlDoc.appendText(polygon.getElement(), "name", string2);
                polygon.setCoordinates(string3);
                elementArray[n4].appendChild(polygon.getElement());
                ++n6;
            }
            ++n;
        }
        GELog.debug(this, "write " + string + " with " + n + " entries.");
        kmlDoc.writeFile(string);
    }

    private boolean filter(GEData gEData, Rectangle rectangle) {
        boolean bl = false;
        if (rectangle != null) {
            Rectangle rectangle2 = gEData.getBBox();
            bl = !BBoxInfo.testContainment(rectangle2, rectangle);
            return bl;
        }
        return bl;
    }

    private Style[] setupStyles(KmlDoc kmlDoc, Element element, Aspect aspect) {
        Document document = kmlDoc.getDocument();
        int n = aspect.getRange().length;
        Style[] styleArray = new Style[n];
        int n2 = 0;
        while (n2 < n) {
            styleArray[n2] = new Style(document, "Style" + n2);
            styleArray[n2].setLineStyle(0.3);
            element.appendChild(styleArray[n2].getElement());
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            boolean bl = GEPreferencePage.isShowBorder();
            if (n2 == 0) {
                styleArray[0].setPolyStyle("0", bl);
            } else {
                n4 = aspect.getBlue(n2);
                n5 = aspect.getRed(n2);
                n6 = aspect.getGreen(n2);
                n3 = aspect.getOpacity(n2);
                String string = String.valueOf(StemKml.getHex(n3)) + StemKml.getHex(n4) + StemKml.getHex(n6) + StemKml.getHex(n5);
                styleArray[n2].setPolyStyle(string, bl);
            }
            ++n2;
        }
        return styleArray;
    }

    public int selectByValue(Aspect aspect, GEData gEData) {
        Object object;
        double d;
        int n;
        block9: {
            String string;
            block8: {
                n = 0;
                string = aspect.getCode();
                Assert.isNotNull((Object)string, (String)"Aspect code is null");
                if (string != null) break block8;
                return 0;
            }
            Map<String, Double> map = gEData.getValueMap();
            Assert.isNotNull(map, (String)"Aspect map is null");
            d = 0.0;
            if (map != null) {
                object = map.get(string);
                if (object != null) {
                    d = (Double)object;
                }
                break block9;
            }
            return 0;
        }
        try {
            object = aspect.getRange();
            int n2 = 0;
            while (n2 < ((Object)object).length) {
                if (d <= object[n2]) {
                    n = n2;
                    break;
                }
                ++n2;
            }
        }
        catch (RuntimeException runtimeException) {
            GELog.error("selectByValue", runtimeException);
        }
        return n;
    }
}

