/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.ge.kml;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.stem.ui.ge.Aspect;
import org.eclipse.stem.ui.ge.GEData;
import org.eclipse.stem.ui.ge.GELog;
import org.eclipse.stem.ui.ge.kml.IKmlDisplay;
import org.eclipse.stem.ui.ge.kml.KmlDoc;
import org.eclipse.stem.ui.ge.kml.PlaceMark;
import org.eclipse.stem.ui.ge.kml.Polygon;
import org.eclipse.stem.ui.ge.kml.StemKml;
import org.eclipse.stem.ui.ge.kml.Style;
import org.eclipse.stem.ui.ge.views.GEPreferencePage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KmlDisplayCustom
implements IKmlDisplay {
    @Override
    public void generatePolygons(String string, Map<String, GEData> map, Aspect aspect) {
        GELog.debug(this, "generatePolygons: aspect=" + aspect + " number=" + map.size());
        KmlDoc kmlDoc = new KmlDoc();
        Document document = kmlDoc.getDocument();
        Element element = kmlDoc.setRoot(null);
        Element element2 = kmlDoc.appendElement(element, "Document");
        Style[] styleArray = this.setupStyles(kmlDoc, element2, aspect);
        int n = styleArray.length;
        PlaceMark[] placeMarkArray = new PlaceMark[n];
        Element[] elementArray = new Element[n];
        int n2 = 0;
        while (n2 < n) {
            placeMarkArray[n2] = new PlaceMark(document);
            element2.appendChild(placeMarkArray[n2].getElement());
            placeMarkArray[n2].setDescription("STEM map");
            placeMarkArray[n2].setName("STEM" + n2);
            placeMarkArray[n2].setStyleUrl(styleArray[n2]);
            elementArray[n2] = document.createElement("MultiGeometry");
            placeMarkArray[n2].appendChild(elementArray[n2]);
            ++n2;
        }
        Iterator<Map.Entry<String, GEData>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            int n3 = 0;
            Map.Entry<String, GEData> entry = iterator.next();
            GEData gEData = entry.getValue();
            String string2 = gEData.getName();
            n3 = this.filter(gEData) ? 0 : this.selectByValue(gEData);
            if (n3 < 0) continue;
            int n4 = 0;
            while (n4 < gEData.getNumAreas()) {
                String string3 = gEData.getCoordinatesAsString(n4);
                Polygon polygon = new Polygon(document);
                kmlDoc.appendText(polygon.getElement(), "name", string2);
                polygon.setCoordinates(string3);
                elementArray[n3].appendChild(polygon.getElement());
                ++n4;
            }
        }
        kmlDoc.writeFile(string);
    }

    private boolean filter(GEData gEData) {
        boolean bl = false;
        if (GEPreferencePage.isTest()) {
            String string = gEData.getName();
            bl = string.indexOf(" US-") >= 0 ? false : string.indexOf(" MEX") < 0;
        }
        return bl;
    }

    private Style[] setupStyles(KmlDoc kmlDoc, Element element, Aspect aspect) {
        Document document = kmlDoc.getDocument();
        boolean bl = false;
        int n = 9;
        Style[] styleArray = new Style[n];
        int n2 = 0;
        while (n2 < n) {
            styleArray[n2] = new Style(document, "Style" + n2);
            styleArray[n2].setLineStyle(0.3);
            element.appendChild(styleArray[n2].getElement());
            int n3 = 160;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            switch (n2) {
                case 0: {
                    n5 = 240;
                    break;
                }
                case 1: {
                    n5 = 240;
                    n6 = 160;
                    break;
                }
                case 2: {
                    n5 = 208;
                    n6 = 240;
                    break;
                }
                case 3: {
                    n5 = 208;
                    n6 = 176;
                    break;
                }
                case 4: {
                    n5 = 176;
                    n6 = 240;
                    break;
                }
                case 5: {
                    n5 = 240;
                    n6 = 192;
                    break;
                }
                case 6: {
                    n5 = 192;
                    n6 = 240;
                    break;
                }
                case 7: {
                    n5 = 240;
                    n6 = 240;
                    break;
                }
                case 8: {
                    n5 = 0;
                    n6 = 240;
                    break;
                }
            }
            String string = String.valueOf(StemKml.getHex(n3)) + StemKml.getHex(n4) + StemKml.getHex(n6) + StemKml.getHex(n5);
            styleArray[n2].setPolyStyle(string, bl);
            ++n2;
        }
        return styleArray;
    }

    public int selectByValue(GEData gEData) {
        int n = 0;
        double d = gEData.getValueMap().get("S");
        double d2 = gEData.getValueMap().get("E");
        double d3 = gEData.getValueMap().get("I");
        double d4 = gEData.getValueMap().get("R");
        n = d == 1.0 && d2 == 0.0 && d3 == 0.0 && d4 == 0.0 ? -1 : (d3 >= 0.2 ? 0 : (d3 >= 0.1 ? (d2 >= d4 ? 1 : (d4 > 0.9 ? 8 : 0)) : (d3 > 0.01 ? (d2 >= d4 ? 1 : 8) : (d2 >= d4 ? 7 : 8))));
        if (gEData.getName().contains(" 25017")) {
            GELog.debug(this, String.valueOf(gEData.getName()) + " " + gEData.getValuesAsString() + " " + n);
        }
        return n;
    }
}

