/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.ge.kml;

import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.stem.ui.ge.Aspect;
import org.eclipse.stem.ui.ge.GEData;
import org.eclipse.stem.ui.ge.GELog;
import org.eclipse.stem.ui.ge.kml.IKmlDisplay;
import org.eclipse.stem.ui.ge.kml.KmlDoc;
import org.eclipse.stem.ui.ge.kml.PlaceMark;
import org.eclipse.stem.ui.ge.kml.Point;
import org.eclipse.stem.ui.ge.kml.Polygon;
import org.eclipse.stem.ui.ge.kml.StemKml;
import org.eclipse.stem.ui.ge.kml.Style;
import org.eclipse.stem.ui.ge.views.GEPreferencePage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KmlDisplaySelection
implements IKmlDisplay {
    public void init() {
    }

    @Override
    public void generatePolygons(String string, Map<String, GEData> map, Aspect aspect) {
        GELog.debug(this, "file=" + string + " number=" + map.size());
        KmlDoc kmlDoc = new KmlDoc();
        Document document = kmlDoc.getDocument();
        Element element = kmlDoc.setRoot(null);
        Element element2 = kmlDoc.appendElement(element, "Document");
        Style style = this.setupStyles(kmlDoc, element2);
        for (Map.Entry<String, GEData> entry : map.entrySet()) {
            GEData gEData = entry.getValue();
            PlaceMark placeMark = new PlaceMark(document);
            placeMark.setDescription(gEData.getDescription());
            placeMark.setName(gEData.getName());
            placeMark.setStyleUrl(style);
            Point point = new Point(document);
            double[] dArray = gEData.getPoint();
            point.setCoordinates(dArray[0], dArray[1]);
            placeMark.appendChild(point.getElement());
            element2.appendChild(placeMark.getElement());
            placeMark = new PlaceMark(document);
            Element element3 = null;
            placeMark.setDescription("polygon description");
            placeMark.setName(gEData.getName());
            placeMark.setStyleUrl(style);
            element2.appendChild(placeMark.getElement());
            element3 = document.createElement("MultiGeometry");
            placeMark.appendChild(element3);
            int n = gEData.getNumAreas();
            int n2 = 0;
            while (n2 < n) {
                String string2 = gEData.getCoordinatesAsString(n2);
                String string3 = gEData.getName();
                GELog.debug(this, String.valueOf(n2) + ": " + string3 + " " + string2);
                Polygon polygon = new Polygon(document);
                kmlDoc.appendText(polygon.getElement(), "name", string3);
                polygon.setCoordinates(string2);
                element3.appendChild(polygon.getElement());
                ++n2;
            }
        }
        kmlDoc.writeFile(string);
        kmlDoc.display();
    }

    private Style setupStyles(KmlDoc kmlDoc, Element element) {
        Document document = kmlDoc.getDocument();
        Style style = new Style(document, "StyleSelect");
        style.setLineStyle(0.3);
        element.appendChild(style.getElement());
        int n = 128;
        int n2 = 128;
        int n3 = 0;
        int n4 = 128;
        boolean bl = GEPreferencePage.isShowBorder();
        String string = String.valueOf(StemKml.getHex(n)) + StemKml.getHex(n2) + StemKml.getHex(n4) + StemKml.getHex(n3);
        style.setPolyStyle(string, bl);
        style.setBalloonStyle();
        return style;
    }

    public int selectByValue(Aspect aspect, GEData gEData) {
        Object object;
        double d;
        int n;
        block9: {
            String string;
            block8: {
                n = 0;
                string = aspect.getCode();
                Assert.isNotNull((Object)string, (String)"Aspect code is null");
                if (string != null) break block8;
                return 0;
            }
            Map<String, Double> map = gEData.getValueMap();
            Assert.isNotNull(map, (String)"Aspect map is null");
            d = 0.0;
            if (map != null) {
                object = map.get(string);
                if (object != null) {
                    d = (Double)object;
                }
                break block9;
            }
            return 0;
        }
        try {
            object = aspect.getRange();
            int n2 = 0;
            while (n2 < ((Object)object).length) {
                if (d <= object[n2]) {
                    n = n2;
                    break;
                }
                ++n2;
            }
        }
        catch (RuntimeException runtimeException) {
            GELog.error("selectByValue", runtimeException);
        }
        return n;
    }
}

