/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.ge.kml;

import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.stem.ui.ge.GELog;
import org.eclipse.stem.ui.ge.kml.Coordinates;
import org.eclipse.stem.ui.ge.kml.LookAt;
import org.eclipse.stem.ui.ge.kml.NetworkLink;
import org.eclipse.stem.ui.ge.kml.PlaceMark;
import org.eclipse.stem.ui.ge.kml.Point;
import org.eclipse.stem.ui.ge.kml.Polygon;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class KmlDoc {
    private static final String _className = "KmlDoc";
    private Document _doc;

    public KmlDoc() {
        String string = "KmlDoc.KmlUtil(constructor) ";
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            if (documentBuilder != null) {
                this._doc = documentBuilder.newDocument();
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.debug(String.valueOf(string) + " Error configuring xml document builder" + parserConfigurationException.getMessage());
        }
    }

    public Element setRoot(String string) {
        if (string == null) {
            string = "http://earth.google.com/kml/2.1";
        }
        Element element = this._doc.createElement("kml");
        element.setAttribute("xmlns", string);
        this._doc.appendChild(element);
        return element;
    }

    public void writeFile(String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            this.write(fileOutputStream);
        }
        catch (Exception exception) {
            this.debug(exception);
        }
    }

    public void write(OutputStream outputStream) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource dOMSource = new DOMSource(this._doc);
            StreamResult streamResult = new StreamResult(outputStream);
            transformer.transform(dOMSource, streamResult);
            outputStream.flush();
            outputStream.close();
        }
        catch (Exception exception) {
            this.debug(exception);
        }
    }

    public void display() {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource dOMSource = new DOMSource(this._doc);
            StreamResult streamResult = new StreamResult(System.out);
            transformer.transform(dOMSource, streamResult);
        }
        catch (Exception exception) {
            this.debug(exception);
        }
    }

    public void debug(String string) {
        GELog.debug(this, string);
    }

    public void debug(String string, String string2) {
        GELog.debug(this, String.valueOf(string) + string2);
    }

    public void debug(Throwable throwable) {
        GELog.error("KmlDoc failure", throwable);
    }

    public void debug(String string, Throwable throwable) {
        GELog.error("KmlDoc: " + string, throwable);
    }

    public Document getDocument() {
        return this._doc;
    }

    public void setDocument(Document document) {
        this._doc = document;
    }

    public static Element createAttr(Document document, String string, String string2) {
        Element element = document.createElement(string);
        Text text = document.createTextNode(string2);
        element.appendChild(text);
        return element;
    }

    public static Element createCDataAttr(Document document, String string, String string2) {
        Element element = document.createElement(string);
        CDATASection cDATASection = document.createCDATASection(string2);
        element.appendChild(cDATASection);
        return element;
    }

    public Element appendElement(Element element, String string) {
        Element element2 = this._doc.createElement(string);
        element.appendChild(element2);
        return element2;
    }

    public Element appendText(Element element, String string, String string2) {
        if (string2.indexOf("<") >= 0 || string2.indexOf(">") >= 0) {
            return this.appendCDATA(element, string, string2);
        }
        Element element2 = this._doc.createElement(string);
        Text text = this._doc.createTextNode(string2);
        element2.appendChild(text);
        element.appendChild(element2);
        return element2;
    }

    public Element appendCDATA(Element element, String string, String string2) {
        Element element2 = this._doc.createElement(string);
        CDATASection cDATASection = this._doc.createCDATASection(string2);
        element2.appendChild(cDATASection);
        element.appendChild(element2);
        return element2;
    }

    public Element appendAttr(Element element, String string, boolean bl) {
        Element element2 = this._doc.createElement(string);
        String string2 = bl ? "1" : "0";
        Text text = this._doc.createTextNode(string2);
        element2.appendChild(text);
        element.appendChild(element2);
        return element2;
    }

    public static void main(String[] stringArray) {
        KmlDoc kmlDoc = new KmlDoc();
        Document document = kmlDoc.getDocument();
        Element element = kmlDoc.setRoot(null);
        Element element2 = document.createElement("Folder");
        element.appendChild(element2);
        Element element3 = document.createElement("Folder");
        element2.appendChild(element3);
        PlaceMark placeMark = new PlaceMark(document);
        element3.appendChild(placeMark.getElement());
        kmlDoc.appendText(placeMark.getElement(), "description", "Home at<br>119 Third");
        placeMark.setName("Home");
        LookAt lookAt = new LookAt(document);
        lookAt.setCoordinates(-122.0059, 36.9639);
        lookAt.setRange(305.8880792294568);
        lookAt.setTilt(46.72425699662645);
        lookAt.setHeading(49.06133439171233);
        placeMark.appendChild(lookAt.getElement());
        kmlDoc.appendAttr(placeMark.getElement(), "visibility", false);
        Point point = new Point(document);
        point.setCoordinates(-122.0059, 36.9639);
        placeMark.appendChild(point.getElement());
        Element element4 = document.createElement("Folder");
        element2.appendChild(element4);
        Polygon polygon = new Polygon(document);
        Coordinates[] coordinatesArray = new Coordinates[4];
        coordinatesArray[0] = new Coordinates(-122.0059, 36.9639);
        coordinatesArray[1] = new Coordinates(-122.0049, 36.9639);
        coordinatesArray[2] = new Coordinates(-122.0049, 36.99);
        coordinatesArray[2] = new Coordinates(-122.0059, 36.9639);
        polygon.setCoordinates(coordinatesArray);
        element4.appendChild(polygon.getElement());
        Element element5 = document.createElement("Folder");
        element2.appendChild(element5);
        NetworkLink networkLink = new NetworkLink(document);
        String string = "c:/tmp/test.kml";
        int n = 6;
        networkLink.setUrl(string, n, null);
        element5.appendChild(networkLink.getElement());
        kmlDoc.display();
        kmlDoc.writeFile("test1.kml");
    }
}

