/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.ge.kml;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.help.internal.appserver.WebappManager;
import org.eclipse.stem.ui.ge.Aspect;
import org.eclipse.stem.ui.ge.GEData;
import org.eclipse.stem.ui.ge.GELog;
import org.eclipse.stem.ui.ge.kml.BBoxInfo;
import org.eclipse.stem.ui.ge.kml.IKmlDisplay;
import org.eclipse.stem.ui.ge.kml.KmlDoc;
import org.eclipse.stem.ui.ge.kml.NetworkLink;
import org.eclipse.stem.ui.ge.servlet.VerifyClient;
import org.eclipse.stem.ui.ge.views.GEPreferencePage;
import org.eclipse.swt.program.Program;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StemKml {
    public static final String CONTEXT = "STEM";
    private static boolean _started = false;
    private static boolean _failed = false;
    private static String _baseurl = null;
    private static String tmpFolder = null;
    static final int MAX = 5;
    static final int MIN = 0;
    static String servletId = null;
    static final String CONTROL_FN = "control.kml";
    static final String DISPLAYAREA_FN = "displayarea.kml";
    private static boolean waitForKML = true;
    static int interval = 2;
    static boolean validKML = true;
    private IKmlDisplay display = null;

    public StemKml() {
        try {
            String string = Aspect.getKmlDisplayClass();
            this.display = (IKmlDisplay)Class.forName(string).newInstance();
        }
        catch (Throwable throwable) {
            GELog.error("Failed to create instance for KmlDisplay", throwable);
        }
    }

    public void init() {
    }

    public static boolean verifyGE() {
        String string = ".kml";
        Program program = Program.findProgram((String)string);
        if (program != null) {
            GELog.debug("StemKml.verifyGE", "KML handler: " + program.getName());
        } else {
            validKML = false;
        }
        return validKML;
    }

    public static void launchGE() throws DOMException {
        try {
            String string = StemKml.getControlFile();
            KmlDoc kmlDoc = new KmlDoc();
            kmlDoc.setRoot(null);
            kmlDoc.getDocument();
            kmlDoc.writeFile(string);
            GELog.debug("StemKml.launchGE", string);
            StemKml.launch(string);
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            String string = "Error launching initial GoogleEarth control file.";
            GELog.error(string, exception);
        }
    }

    public static String getControlFile() {
        String string = null;
        if (tmpFolder == null) {
            tmpFolder = StemKml.getTmpFolder();
        }
        if (tmpFolder == null) {
            GELog.error("Unable to generate KML Control file.", null);
        } else {
            string = String.valueOf(tmpFolder) + File.separator + CONTROL_FN;
        }
        return string;
    }

    public static String getTmpFolder() {
        String string = null;
        String string2 = File.separator;
        try {
            File file = File.createTempFile("control", ".kml", null);
            string = file.getParent();
            file.delete();
        }
        catch (IOException iOException) {
            GELog.error("System Temporary Directory not defined: ", null);
            string = StemKml.getLogFolder();
            string = String.valueOf(string) + string2 + "tmp";
            File file = new File(string);
            file.mkdirs();
        }
        catch (Exception exception) {
            GELog.error("Failure getting TMP folder.", exception);
        }
        return string;
    }

    public static String getLogFolder() {
        String string = null;
        try {
            string = GEPreferencePage.getFolder();
            File file = new File(string);
            if (file.exists()) {
                if (file.isDirectory()) {
                    return string;
                }
                throw new RuntimeException("Log Folder " + string + " is not valid");
            }
            boolean bl = file.mkdirs();
            if (bl) {
                return string;
            }
            throw new RuntimeException("Log Folder " + string + " cannot be created ");
        }
        catch (Exception exception) {
            GELog.error("Failed to get LOG folder: " + string, exception);
            string = null;
            return string;
        }
    }

    public static String getDisplayAreaFile() {
        String string = null;
        try {
            if (tmpFolder == null) {
                File file = File.createTempFile("displayarea", ".kml");
                tmpFolder = file.getParent();
                file.delete();
            }
            string = String.valueOf(tmpFolder) + "/" + DISPLAYAREA_FN;
        }
        catch (IOException iOException) {
            GELog.error("Unable to generate KML DisplayArea file.", iOException);
        }
        return string;
    }

    public static void clearDisplayArea() {
        String string = String.valueOf(tmpFolder) + "/" + DISPLAYAREA_FN;
        KmlDoc kmlDoc = new KmlDoc();
        kmlDoc.setRoot(null);
        kmlDoc.getDocument();
        kmlDoc.writeFile(string);
        StemKml.launch(string);
    }

    public static String launchNetworkLink(String string, String string2) {
        String string3 = null;
        StemKml.launchGE();
        try {
            String string4 = StemKml.getControlFile();
            long l = new Date().getTime();
            servletId = Long.toHexString(l);
            String string5 = "n";
            if (waitForKML) {
                string5 = "y";
            }
            string3 = String.valueOf(_baseurl) + "/" + CONTEXT + "/slideshow?id=" + servletId + "&folder=" + string + "&wait=" + string5;
            if (string2 != null) {
                string3 = String.valueOf(string3) + "&file=" + string2;
            }
            GELog.debug(StemKml.class, "launchNetworkLink url=" + string3);
            StemKml.writeNetLink(string4, interval, string3);
            String string6 = String.valueOf(_baseurl) + "/" + CONTEXT + "/bbox?id=" + servletId;
            if (GEPreferencePage.isBBOX()) {
                BBoxInfo bBoxInfo = new BBoxInfo(string6, servletId);
                Thread thread = new Thread(bBoxInfo);
                thread.start();
            }
            try {
                Program.launch((String)string4);
                GELog.debug(StemKml.class, "Launched networkLink file " + string4);
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Throwable throwable) {
                GELog.error("Launch failure", throwable);
            }
        }
        catch (Exception exception) {
            GELog.error("Failure launching NetworkLink.kml file", exception);
        }
        return string3;
    }

    public static void writeNetLink(String string, int n, String string2) throws DOMException {
        KmlDoc kmlDoc = new KmlDoc();
        Document document = kmlDoc.getDocument();
        Element element = kmlDoc.setRoot(null);
        NetworkLink networkLink = new NetworkLink(document);
        String string3 = "onInterval";
        networkLink.setUrl(string2, n, string3);
        kmlDoc.appendAttr(networkLink.getElement(), "flyToView", false);
        element.appendChild(networkLink.getElement());
        kmlDoc.writeFile(string);
    }

    public void generatePolygons(String string, Map<String, GEData> map, Aspect aspect, long l) {
        this.display.generatePolygons(string, map, aspect);
    }

    public static String getHex(int n) {
        String string = Integer.toHexString(n);
        if (string.length() % 2 != 0) {
            string = "0" + string;
        }
        return string;
    }

    public static void launch(String string) {
        try {
            if (!validKML) {
                GELog.debug("launch: KML is unknown filetype");
                return;
            }
            File file = new File(string);
            Program.launch((String)file.getAbsolutePath());
            GELog.debug("StemKml.launch", "Launched file " + string);
        }
        catch (Throwable throwable) {
            GELog.error("StemKml: Launch failure", throwable);
        }
    }

    public static String initWebServer() {
        Object object;
        if (GEPreferencePage.isInternalServer()) {
            _baseurl = StemKml.startWebServer();
        }
        if (_baseurl == null && (object = GEPreferencePage.getServerHost()) != null && ((String)object).length() > 0) {
            _baseurl = "http://" + (String)object;
        }
        if (_baseurl != null) {
            GELog.debug(StemKml.class, "VerifyClient " + _baseurl);
            object = new VerifyClient();
            boolean bl = ((VerifyClient)object).verify(String.valueOf(_baseurl) + "/" + CONTEXT + "/verify");
            if (!bl) {
                GELog.info(((VerifyClient)object).getError());
                GELog.error("StemKml: Unable to communicate with web server @ " + _baseurl, null);
                if (GEPreferencePage.isInternalServer()) {
                    _failed = true;
                }
                _baseurl = null;
            }
        }
        if (_baseurl == null) {
            GELog.error("GoogleEarth Servlet support disabled", null);
        }
        return _baseurl;
    }

    public static String startWebServer() {
        String string = null;
        if (!_started && !_failed) {
            try {
                GELog.debug(StemKml.class, "Start webServer");
                WebappManager.start((String)CONTEXT, (String)"org.eclipse.stem.ui.ge", (IPath)Path.EMPTY);
                String string2 = String.valueOf(WebappManager.getHost()) + ":" + WebappManager.getPort();
                string = "http://" + string2;
                GELog.debug(StemKml.class, "Started webServer " + string);
            }
            catch (CoreException coreException) {
                GELog.error(coreException.getMessage(), coreException);
                _failed = true;
                string = null;
            }
        } else if (!_failed) {
            String string3 = String.valueOf(WebappManager.getHost()) + ":" + WebappManager.getPort();
            string = "http://" + string3;
        }
        GELog.debug(StemKml.class, "embedded web server at: " + string);
        if (!_failed) {
            _started = true;
        }
        return string;
    }

    public static String getServerUrl() {
        return _baseurl;
    }

    public static String getControlFN(String string, String string2, Aspect aspect, long l) {
        String string3 = "";
        String string4 = "0000" + l;
        if (l > 9L) {
            string4 = "000" + l;
        }
        if (l > 99L) {
            string4 = "00" + l;
        }
        if (l > 999L) {
            string4 = "0" + l;
        }
        if (l > 9999L) {
            string4 = "" + l;
        }
        string3 = String.valueOf(string) + "/" + string2;
        string3 = string3.replaceAll("&T", aspect.toString());
        string3 = string3.replaceAll("&N", string4);
        GELog.debug(StemKml.class, "Output file=" + string3);
        return string3;
    }

    public static boolean isWaitForKML() {
        return waitForKML;
    }

    public static void setWaitForKML(boolean bl) {
        waitForKML = bl;
    }
}

