/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.ge.servlet;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.stem.ui.ge.servlet.SlideShowServlet;

public class ImageServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private String text = "DEFAULT";
    private int textsize = 14;
    private String fc = "#ffffff";
    private String bc = "#000000";
    private int h = 32;
    int w = 0;
    private String fontName = "Sans-serif";

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGet(httpServletRequest, httpServletResponse);
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        String string;
        Object object;
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            string = httpServletRequest.getParameter((String)object);
            if (((String)object).equals("text")) {
                this.text = string;
                continue;
            }
            if (((String)object).equals("w")) {
                this.w = Integer.parseInt(string);
                continue;
            }
            if (((String)object).equals("h")) {
                this.h = Integer.parseInt(string);
                continue;
            }
            if (((String)object).equals("bc")) {
                this.bc = string;
                continue;
            }
            if (!((String)object).equals("fc")) continue;
            this.fc = string;
        }
        object = this.getImage();
        if (object == null) {
            this.errHtml(httpServletResponse, "Unable to create image.");
        }
        httpServletResponse.setContentType("image/png");
        string = httpServletResponse.getOutputStream();
        ImageIO.write((RenderedImage)object, "png", (OutputStream)((Object)string));
        ((OutputStream)((Object)string)).close();
    }

    public BufferedImage getImage() {
        BufferedImage bufferedImage = null;
        Font font = new Font(this.fontName, 1, this.textsize);
        if (this.w == 0) {
            this.w = (this.text.length() + 2) * 8;
        }
        int n = 0;
        int n2 = 0;
        try {
            if (this.fc.startsWith("#")) {
                this.fc = this.fc.substring(1);
            }
            n = (int)(Long.parseLong(this.fc, 16) & 0xFFFFFFFL);
            if (this.bc.startsWith("#")) {
                this.bc = this.bc.substring(1);
            }
            n2 = (int)(Long.parseLong(this.bc, 16) & 0xFFFFFFFL);
        }
        catch (Exception exception) {
            this.debug("textColor=" + n);
            this.debug("imageColor=" + n2);
            this.debug("Invalid text or image color.", exception);
            return null;
        }
        try {
            bufferedImage = new BufferedImage(this.w, this.h, 1);
            int n3 = 0;
            while (n3 < this.w) {
                int n4 = 0;
                while (n4 < this.h) {
                    bufferedImage.setRGB(n3, n4, n2);
                    ++n4;
                }
                ++n3;
            }
            Graphics2D graphics2D = bufferedImage.createGraphics();
            Color color = new Color(n, (n >> 24 & 0xFF) != 0);
            graphics2D.setColor(color);
            graphics2D.setFont(font);
            graphics2D.drawString(this.text, this.textsize / 2, this.textsize * 5 / 4);
            graphics2D.dispose();
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            return null;
        }
        return bufferedImage;
    }

    private void errHtml(HttpServletResponse httpServletResponse, String string) throws IOException {
        httpServletResponse.setContentType("text/html");
        PrintWriter printWriter = new PrintWriter((OutputStream)httpServletResponse.getOutputStream());
        printWriter.println("<html>");
        printWriter.println("<head><title>KML SlideShow Error</title></head>");
        printWriter.println("<body>");
        printWriter.println("<p>" + string + "</p>");
        printWriter.println("</body></html>");
        printWriter.flush();
    }

    private void debug(String string) {
        if (SlideShowServlet.DEBUG) {
            System.out.println("ImageServlet: " + string);
        }
    }

    private void debug(String string, Throwable throwable) {
        System.out.println(string);
        throwable.printStackTrace();
    }
}

