/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.ge.servlet;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.stem.ui.ge.servlet.SlideShowInfo;

public class SlideShowServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static boolean DEBUG = false;
    private static final boolean TEST = false;
    private static final long start = new Date().getTime();
    public static final String CONTEXT = "STEM";
    static final String STEM_FOLDER = "c:\\tmp\\ge";
    private static HashMap<String, SlideShowInfo> _infoMap = null;
    private boolean bboxSet = false;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        _infoMap = new HashMap();
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doPost(httpServletRequest, httpServletResponse);
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        int n = 0;
        String string = null;
        SlideShowInfo slideShowInfo = null;
        File[] fileArray = null;
        try {
            slideShowInfo = this.getParameters(httpServletRequest);
            String string2 = slideShowInfo.getKey();
            if (this.bboxSet) {
                this.processNoOp(httpServletRequest, httpServletResponse);
            }
            slideShowInfo.delay();
            string = slideShowInfo.getFileName();
            if (string != null) {
                this.processFile(httpServletRequest, httpServletResponse, slideShowInfo, string);
                return;
            }
            fileArray = slideShowInfo.getFiles();
            if (fileArray == null) {
                fileArray = this.getFiles(slideShowInfo);
            }
            n = this.getCounter(httpServletRequest, httpServletResponse, slideShowInfo);
            fileArray = slideShowInfo.getFiles();
            if (fileArray.length == 0) {
                if (slideShowInfo.isWaitForKML()) {
                    this.sendScreenOverlay(httpServletRequest, httpServletResponse, "Waiting to Start");
                } else {
                    httpServletResponse.sendError(400, "No KML files in specified folder.");
                }
                return;
            }
            File file = fileArray[n];
            SlideShowServlet.debug("Send to GE: " + file);
            FileInputStream fileInputStream = new FileInputStream(file);
            String[] stringArray = slideShowInfo.getInsert();
            this.sendOutput(httpServletRequest, httpServletResponse, fileInputStream, stringArray);
            slideShowInfo.setCounter(n);
            _infoMap.put(string2, slideShowInfo);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            httpServletResponse.sendError(500, throwable.getMessage());
        }
    }

    private synchronized int getCounter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SlideShowInfo slideShowInfo) throws Exception {
        int n;
        block5: {
            n = slideShowInfo.getCounter();
            ++n;
            int n2 = 10;
            int n3 = slideShowInfo.getFiles().length;
            while (n >= n3) {
                if (slideShowInfo.isWaitForKML()) {
                    Thread.sleep(1000L);
                    slideShowInfo.setFiles(null);
                    this.getFiles(slideShowInfo);
                    n3 = slideShowInfo.getFiles().length;
                    if (--n2 > 0) continue;
                    n = n3 - 1;
                    if (!slideShowInfo.isPause()) {
                        slideShowInfo.setPause(true);
                        String string = this.getHost(httpServletRequest);
                        String string2 = "http://" + string + "/" + CONTEXT + "/image?text=" + URLEncoder.encode("Paused", "UTF-8");
                        String[] stringArray = this.buildScreenOverlay(string2);
                        slideShowInfo.setInsert(stringArray);
                    }
                } else {
                    SlideShowServlet.debug("Pause 10 seconds before restarting");
                    Thread.sleep(10000L);
                    n = 0;
                }
                break block5;
            }
            if (slideShowInfo.isPause()) {
                slideShowInfo.setPause(false);
                Thread.sleep(2000L);
                String string = this.getHost(httpServletRequest);
                String string3 = "http://" + string + "/" + CONTEXT + "/image?text=" + URLEncoder.encode("Active", "UTF-8");
                String[] stringArray = this.buildScreenOverlay(string3);
                slideShowInfo.setInsert(stringArray);
            }
        }
        return n;
    }

    private void processNoOp(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            PrintWriter printWriter = new PrintWriter((OutputStream)httpServletResponse.getOutputStream());
            httpServletResponse.setContentType("application/keyhole");
            printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            printWriter.println("<kml xmlns=\"http://earth.google.com/kml/2.0\">");
            printWriter.println("<Document>");
            printWriter.println("</Document>");
            printWriter.println("</kml>");
            printWriter.flush();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            httpServletResponse.sendError(500, throwable.getMessage());
        }
    }

    private void processFile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SlideShowInfo slideShowInfo, String string) throws ServletException, IOException {
        try {
            File file = new File(string);
            String string2 = string.replace("_Current", "_Old");
            File file2 = new File(string2);
            String[] stringArray = slideShowInfo.getInsert();
            FileInputStream fileInputStream = null;
            int n = 0;
            try {
                while (!file.exists()) {
                    Thread.sleep(2000L);
                    if (++n <= 10) continue;
                    this.rename(file2, file);
                }
                fileInputStream = new FileInputStream(file);
            }
            catch (Exception exception) {
                SlideShowServlet.error("processFile failed", exception);
                return;
            }
            SlideShowServlet.debug("Send to GE: " + file);
            this.sendOutput(httpServletRequest, httpServletResponse, fileInputStream, stringArray);
            this.rename(file, file2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            httpServletResponse.sendError(500, throwable.getMessage());
        }
    }

    private boolean rename(File file, File file2) {
        try {
            if (file2.exists()) {
                file2.delete();
            }
            file.renameTo(file2);
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
        return true;
    }

    private String getHost(HttpServletRequest httpServletRequest) {
        int n = httpServletRequest.getServerPort();
        String string = String.valueOf(httpServletRequest.getServerName()) + ":" + n;
        return string;
    }

    public File[] getFiles(SlideShowInfo slideShowInfo) {
        File[] fileArray = null;
        File file = null;
        try {
            fileArray = slideShowInfo.getFiles();
            if (fileArray == null || fileArray.length == 0) {
                file = new File(slideShowInfo.getFolderName());
                fileArray = this.fileList(file);
                if (fileArray == null) {
                    fileArray = new File[]{};
                }
                slideShowInfo.setFiles(fileArray);
            }
        }
        catch (RuntimeException runtimeException) {
            SlideShowServlet.error("getFiles() failed. ", runtimeException);
            fileArray = new File[]{};
        }
        return fileArray;
    }

    private File[] fileList(File file) {
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                if (file.getName().toLowerCase().startsWith("net")) {
                    return false;
                }
                return file.getName().toLowerCase().endsWith(".kml");
            }
        };
        Comparator<File> comparator = new Comparator<File>(){

            @Override
            public int compare(File file, File file2) {
                File file3 = file;
                File file4 = file2;
                int n = file3.getName().compareTo(file4.getName());
                return n;
            }
        };
        try {
            File[] fileArray = file.listFiles(fileFilter);
            if (fileArray == null) {
                return new File[0];
            }
            Arrays.sort(fileArray, 0, fileArray.length, comparator);
            return fileArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private SlideShowInfo getParameters(HttpServletRequest httpServletRequest) {
        Object object;
        String string = "DEFAULT";
        String string2 = STEM_FOLDER;
        boolean bl = false;
        String string3 = null;
        String string4 = "2";
        String string5 = null;
        this.bboxSet = false;
        Enumeration enumeration = httpServletRequest.getParameterNames();
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            String string6 = httpServletRequest.getParameter((String)object);
            stringBuffer.append(String.valueOf(object) + ": " + string6 + " ");
            if (((String)object).equals("id")) {
                string = string6;
                continue;
            }
            if (((String)object).equals("folder")) {
                string2 = string6;
                continue;
            }
            if (((String)object).equals("delay")) {
                string4 = string6;
                continue;
            }
            if (((String)object).equals("wait")) {
                if (!string6.equals("y")) continue;
                bl = true;
                continue;
            }
            if (((String)object).equals("file")) {
                string3 = string6;
                continue;
            }
            if (((String)object).equals("BBOX")) {
                string5 = string6;
                continue;
            }
            if (!((String)object).equals("bboxSet")) continue;
            this.bboxSet = true;
        }
        object = _infoMap.get(string);
        if (object == null) {
            object = new SlideShowInfo(string, string2, bl, string3, string4);
        }
        if (string5 != null) {
            ((SlideShowInfo)object).setBBOX(string5);
        }
        _infoMap.put(string, (SlideShowInfo)object);
        return object;
    }

    private synchronized void sendOutput(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, InputStream inputStream, String[] stringArray) throws IOException {
        httpServletResponse.setContentType("application/keyhole");
        try {
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            this.copy(inputStream, (OutputStream)servletOutputStream, stringArray);
        }
        catch (Exception exception) {
            String string = "SlideShowServlet.sendOutput() failed while sending kmlFile";
            SlideShowServlet.error(String.valueOf(string) + "\n" + exception.getMessage(), null);
        }
    }

    private String[] buildScreenOverlay(String string) {
        String[] stringArray = new String[]{"<ScreenOverlay id=\"Status\">", "   <description>STEM status</description>", "   <name>Status</name>\n", "<icon>", "<href>", string, "</href>", "</icon>\n", "<overlayXY x=\"0\" y=\"1\" xunits=\"fraction\" yunits=\"fraction\"/>\n", "<screenXY x=\"0\" y=\"1\" xunits=\"fraction\" yunits=\"fraction\"/>\n", "<size x=\"0\" y=\"0\" xunits=\"fraction\" yunits=\"fraction\"/>\n", "</ScreenOverlay>\n"};
        return stringArray;
    }

    private void sendScreenOverlay(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws IOException {
        httpServletResponse.setContentType("application/keyhole");
        try {
            String string2 = this.getHost(httpServletRequest);
            String string3 = "http://" + string2 + "/" + CONTEXT + "/image?text=" + URLEncoder.encode(string, "UTF-8");
            String[] stringArray = this.buildScreenOverlay(string3);
            PrintWriter printWriter = new PrintWriter((OutputStream)httpServletResponse.getOutputStream());
            httpServletResponse.setContentType("application/keyhole");
            printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            printWriter.println("<kml xmlns=\"http://earth.google.com/kml/2.0\">");
            printWriter.println("<Document>");
            int n = 0;
            while (n < stringArray.length) {
                printWriter.println(stringArray[n]);
                ++n;
            }
            printWriter.println("</Document>");
            printWriter.println("</kml>");
            printWriter.flush();
        }
        catch (Exception exception) {
            String string4 = "SlideShowServlet.sendScreenOverlay() failed while writing kmlFile";
            SlideShowServlet.error(String.valueOf(string4) + "\n" + exception.getMessage(), null);
        }
    }

    private static String getClock() {
        long l = new Date().getTime() - start;
        return Long.toString(l);
    }

    public static SlideShowInfo getInfo(String string) {
        SlideShowInfo slideShowInfo = _infoMap.get(string);
        return slideShowInfo;
    }

    private void copy(InputStream inputStream, OutputStream outputStream, String[] stringArray) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String string = null;
        try {
            while ((string = bufferedReader.readLine()) != null) {
                byte[] byArray = string.getBytes();
                outputStream.write(byArray, 0, byArray.length);
                if (stringArray == null || !string.toLowerCase().startsWith("<document>")) continue;
                int n = 0;
                while (n < stringArray.length) {
                    byArray = stringArray[n].getBytes();
                    outputStream.write(byArray, 0, byArray.length);
                    ++n;
                }
            }
            outputStream.flush();
            outputStream.close();
            inputStream.close();
        }
        catch (Throwable throwable) {
            SlideShowServlet.error("SlideShowServlet.copy(): Error while copying KML file. " + throwable.toString(), null);
            try {
                inputStream.close();
                outputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void debug(String string) {
        if (DEBUG) {
            System.out.println(String.valueOf(SlideShowServlet.getClock()) + " GEServlet: " + string);
        }
    }

    public static void error(String string, Throwable throwable) {
        System.out.println(string);
        if (throwable != null) {
            if (DEBUG) {
                throwable.printStackTrace();
            } else {
                System.out.println(throwable.toString());
            }
        }
    }
}

