/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.ge.views;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.stem.ui.ge.GELog;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DisplayAreaDialog
extends TitleAreaDialog {
    private Combo country = null;
    private Combo level = null;
    private Text search = null;
    Button clearButton = null;
    boolean rClear = false;

    public DisplayAreaDialog(Shell shell) {
        super(shell);
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        this.setMessage("Enter Admin Area info.");
        this.setTitle("DisplayArea");
        return control;
    }

    protected Control createDialogArea(Composite composite) {
        String string;
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Group group = new Group(composite2, 4);
        group.setLayout((Layout)new RowLayout(256));
        Label label = new Label((Composite)group, 0);
        label.setText("Country: ");
        this.country = new Combo((Composite)group, 4);
        this.country.setTextLimit(3);
        String[] stringArray = new String[]{"USA", "CAN", "MEX"};
        this.country.setItems(stringArray);
        if (DisplayAreaData.rCountry != null) {
            this.country.setText(DisplayAreaData.rCountry);
        } else {
            this.country.select(0);
        }
        Label label2 = new Label((Composite)group, 0);
        label2.setText("Level: ");
        this.level = new Combo((Composite)group, 12);
        stringArray = new String[]{"0", "1", "2"};
        this.level.setTextLimit(1);
        this.level.setItems(stringArray);
        this.level.select(Integer.parseInt(DisplayAreaData.rLevel));
        Label label3 = new Label(composite2, 0);
        label3.setText("Search text: ");
        this.search = new Text(composite2, 2048);
        this.search.setTextLimit(48);
        if (DisplayAreaData.rSearch != null) {
            string = DisplayAreaData.rSearch;
            if (string.length() < 10) {
                string = String.valueOf(string) + "         ";
            }
            this.search.setText(string);
        }
        string = new Group(composite2, 4);
        string.setLayout((Layout)new RowLayout(256));
        this.clearButton = new Button((Composite)string, 32);
        this.clearButton.setText("Clear Map");
        return composite2;
    }

    public void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 10, "Apply", false);
        this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void buttonPressed(int n) {
        this.setReturnCode(n);
        GELog.debug((Object)this, "" + n);
        this.close();
    }

    public boolean close() {
        DisplayAreaData.rCountry = this.country.getText();
        DisplayAreaData.rLevel = this.level.getText();
        DisplayAreaData.rSearch = this.search.getText();
        this.rClear = this.clearButton.getSelection();
        return super.close();
    }

    public String getAdminFile() {
        String string = DisplayAreaData.rCountry;
        GELog.debug((Object)this, string);
        String string2 = String.valueOf(string) + "/" + string + "_" + DisplayAreaData.rLevel + "_MAP.xml";
        return string2;
    }

    public String getSearch() {
        return DisplayAreaData.rSearch;
    }

    public boolean isClear() {
        return this.rClear;
    }

    public static class DisplayAreaData {
        public static String rLevel = "2";
        public static String rCountry = "USA";
        public static String rSearch = null;
    }
}

