/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.ge.views;

import java.io.IOException;
import java.util.Map;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.ge.Aspect;
import org.eclipse.stem.ui.ge.GELog;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class GEPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    static final String P_FOLDER = "folderPreference";
    static final String P_SERVER_HOST = "ServerHostPreference";
    static final String P_AUTO_LAUNCH = "AutoLaunchPreference";
    static final String P_INTERNAL_SERVER = "InternalServer";
    static final String P_WHICH_CYCLE = "whichCycle";
    static final String P_DEBUG = "DebugPreference";
    static final String P_BBOX = "BBOXPreference";
    static final String P_ASPECT = "AspectPreference";
    static final String P_AUTO_LOGGING = "AutoLoggingPreference";
    static final String P_TEST = "TestPreference";
    static final String P_SHOW_BORDER = "ShowBorderPreference";
    static final String P_METHOD = "MethodPreference";
    public static final int M_LOG_ONLY = 1;
    public static final int M_LOG_SERVLET = 2;
    public static final int M_ASYNC_SERVLET = 3;
    public static final int M_AUTO_LAUNCH = 4;
    public static final int M_MANUAL_DISPLAY = 5;
    public static final IPreferenceStore preferences = org.eclipse.stem.ui.ge.Activator.getDefault().getPreferenceStore();

    public GEPreferencePage() {
        super(1);
        this.setPreferenceStore(preferences);
        this.setDescription("Preferences for the STEM - GoogleEarth interface\n ");
    }

    public void init(IWorkbench iWorkbench) {
    }

    public void createFieldEditors() {
        String[][] stringArray;
        this.addField((FieldEditor)new RadioGroupFieldEditor(P_METHOD, "&Choose the method used to display STEM results.", 1, (String[][])new String[][]{{"LogOnly    - KML files will be logged for later display", "1"}, {"Log+Servlet - KML files logged and displayed by GoogleEarth", "2"}, {"AsyncServlet - KML written to Control.kml and Async read by Servlet ", "3"}, {"DirectLaunch - At each Nth cycle, directly launch the file to GE ", "4"}, {"ManualDisplay - Use DisplayMap command to display", "5"}}, this.getFieldEditorParent()));
        this.addField((FieldEditor)new DirectoryFieldEditor(P_FOLDER, "&Folder for KML logging:", this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor(P_INTERNAL_SERVER, "&Use internal webserver", this.getFieldEditorParent()));
        this.addField((FieldEditor)new StringFieldEditor(P_SERVER_HOST, "Hostname:port for external webserver:", this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor(P_AUTO_LAUNCH, "&Automatically startup GoogleEarth", this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor(P_AUTO_LOGGING, "&Automatically process every simulation", this.getFieldEditorParent()));
        this.addField((FieldEditor)new IntegerFieldEditor(P_WHICH_CYCLE, "Write KML files only every N th cycle", this.getFieldEditorParent(), 2));
        String string = preferences.getString(P_ASPECT);
        if ("".equals(string)) {
            this.getVisualizationPreferences();
            string = preferences.getString(P_ASPECT);
        }
        if ((stringArray = this.aspects()) != null) {
            this.addField((FieldEditor)new RadioGroupFieldEditor(P_ASPECT, "&Choose the STEM Aspect to be Logged.", 2, this.aspects(), this.getFieldEditorParent()));
        }
    }

    private String[][] aspects() {
        Map<String, Aspect> map = Aspect.getMap();
        if (map == null || map.size() == 0) {
            return null;
        }
        int n = map.size();
        String[][] stringArray = new String[n][2];
        int n2 = 0;
        for (Map.Entry<String, Aspect> entry : map.entrySet()) {
            String string = entry.getKey();
            Aspect aspect = entry.getValue();
            stringArray[n2][0] = aspect.getName();
            stringArray[n2][1] = string;
            ++n2;
        }
        return stringArray;
    }

    public boolean performOk() {
        this.update();
        try {
            if (preferences instanceof ScopedPreferenceStore) {
                ScopedPreferenceStore scopedPreferenceStore = (ScopedPreferenceStore)preferences;
                scopedPreferenceStore.save();
            }
        }
        catch (IOException iOException) {
            GELog.error("Failure saving Preferences", iOException);
        }
        GELog.debug((Object)this, "saved preferences");
        return super.performOk();
    }

    private void update() {
        if (GEPreferencePage.isDebug() != GELog.DEBUG) {
            GELog.DEBUG = GEPreferencePage.isDebug();
            if (GEPreferencePage.isDebug()) {
                GELog.debug("Set DEBUG to " + GEPreferencePage.isDebug());
            }
        }
    }

    private void getVisualizationPreferences() {
        Activator activator = null;
        try {
            activator = Activator.getDefault();
            Preferences preferences = activator.getPluginPreferences();
            String string = preferences.getString("org.eclipse.stem.ui.initialattributename");
            if (preferences.getString(P_ASPECT) == "") {
                GELog.debug((Object)this, "Use visualizationAspect=" + string);
                if (string.equals("S")) {
                    string = "I";
                }
                GEPreferencePage.setAspect(string);
            } else {
                GELog.debug((Object)this, "Ignore visualizationAspect=" + string);
            }
        }
        catch (Exception exception) {
            GELog.error("Failure getting Visualization preferences", exception);
        }
        try {
            activator.getPluginPreferences().addPropertyChangeListener(new Preferences.IPropertyChangeListener(){

                public void propertyChange(Preferences.PropertyChangeEvent propertyChangeEvent) {
                    GEPreferencePage.this.setVisulizationPreferences(propertyChangeEvent);
                }
            });
        }
        catch (Exception exception) {}
    }

    private void setVisulizationPreferences(Preferences.PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        if ("org.eclipse.stem.ui.initialattributename" == string) {
            String string2 = (String)propertyChangeEvent.getNewValue();
            GELog.debug((Object)this, "Changed visualizationAspect=" + string2);
            GEPreferencePage.setAspect(string2);
            this.performOk();
        }
    }

    public static String getFolder() {
        return preferences.getString(P_FOLDER);
    }

    public static void setFolder(String string) {
        preferences.setValue(P_FOLDER, string);
    }

    public static String getServerHost() {
        return preferences.getString(P_SERVER_HOST);
    }

    public static int getMethod() {
        String string = preferences.getString(P_METHOD);
        int n = Integer.parseInt(string);
        return n;
    }

    public static void setMethod(int n) {
        String string = "" + n;
        preferences.setValue(P_METHOD, string);
    }

    public static boolean isInternalServer() {
        return preferences.getBoolean(P_INTERNAL_SERVER);
    }

    public static boolean isAutoLaunch() {
        return preferences.getBoolean(P_AUTO_LAUNCH);
    }

    public static boolean isAutoLogging() {
        return preferences.getBoolean(P_AUTO_LOGGING);
    }

    public static int getWhichCycle() {
        return preferences.getInt(P_WHICH_CYCLE);
    }

    public static Aspect getAspect() {
        Aspect aspect = null;
        String string = preferences.getString(P_ASPECT);
        aspect = string.length() == 0 ? Aspect.getDefault() : Aspect.getAspect(string);
        if (aspect == null) {
            GELog.debug("GEPreferencePage.getAspect: ", String.valueOf(string) + " returned null, use default aspect");
            aspect = Aspect.getDefault();
        }
        return aspect;
    }

    public static void setAspect(String string) {
        Map<String, Aspect> map = Aspect.getMap();
        if (map != null && map.size() > 0) {
            Aspect aspect = null;
            aspect = Aspect.getAspect(string);
            if (aspect == null) {
                GELog.debug(GEPreferencePage.class, "Invalid aspect ignored: " + string);
                return;
            }
        }
        preferences.setValue(P_ASPECT, string);
        GELog.debug(GEPreferencePage.class, "Aspect set: " + string);
    }

    public static boolean isBBOX() {
        if (preferences != null) {
            return preferences.getBoolean(P_BBOX);
        }
        return false;
    }

    public static boolean isDebug() {
        if (preferences != null) {
            return preferences.getBoolean(P_DEBUG);
        }
        return true;
    }

    public static boolean isTest() {
        if (preferences != null) {
            return preferences.getBoolean(P_TEST);
        }
        return true;
    }

    public static boolean isShowBorder() {
        if (preferences != null) {
            return preferences.getBoolean(P_SHOW_BORDER);
        }
        return true;
    }

    public static String display() {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("STEM-GoogleEarth Preferences:\n");
        stringBuffer.append("P_METHOD: ");
        switch (GEPreferencePage.getMethod()) {
            case 1: {
                stringBuffer.append("M_LOG_ONLY ");
                break;
            }
            case 2: {
                stringBuffer.append("M_LOG_SERVLET ");
                break;
            }
            case 3: {
                stringBuffer.append("M_ASYNC_SERVLET ");
                break;
            }
            case 4: {
                stringBuffer.append("M_AUTO_LAUNCH ");
                break;
            }
            case 5: {
                stringBuffer.append("M_MANUAL_DISPLAY ");
                break;
            }
            default: {
                stringBuffer.append("Unknown ");
            }
        }
        stringBuffer.append("\n");
        stringBuffer.append("P_FOLDER: ");
        stringBuffer.append(String.valueOf(GEPreferencePage.getFolder()) + "\n");
        stringBuffer.append("P_SERVER_HOST: ");
        stringBuffer.append(String.valueOf(GEPreferencePage.getServerHost()) + "\n");
        stringBuffer.append("P_INTERNAL_SERVER: ");
        stringBuffer.append(String.valueOf(GEPreferencePage.isInternalServer()) + "\n");
        stringBuffer.append("P_AUTO_LAUNCH: ");
        stringBuffer.append(String.valueOf(GEPreferencePage.isAutoLaunch()) + "\n");
        stringBuffer.append("P_AUTO_LOGGING: ");
        stringBuffer.append(String.valueOf(GEPreferencePage.isAutoLogging()) + "\n");
        stringBuffer.append("P_WHICH_CYCLE: ");
        stringBuffer.append(String.valueOf(GEPreferencePage.getWhichCycle()) + "\n");
        stringBuffer.append("P_ASPECT: ");
        stringBuffer.append(String.valueOf(GEPreferencePage.getAspect().toString()) + "\n");
        stringBuffer.append("P_BBOX: ");
        stringBuffer.append(String.valueOf(GEPreferencePage.isBBOX()) + "\n");
        stringBuffer.append("P_DEBUG: ");
        stringBuffer.append(String.valueOf(GEPreferencePage.isDebug()) + "\n");
        stringBuffer.append("P_TEST: ");
        stringBuffer.append(String.valueOf(GEPreferencePage.isTest()) + "\n");
        stringBuffer.append("P_SHOW_BORDER: ");
        stringBuffer.append(String.valueOf(GEPreferencePage.isShowBorder()) + "\n");
        return stringBuffer.toString();
    }
}

