/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.ge.views;

import java.io.File;
import java.io.FileFilter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.SimulationManager;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.ge.Aspect;
import org.eclipse.stem.ui.ge.GEInterface;
import org.eclipse.stem.ui.ge.GELog;
import org.eclipse.stem.ui.ge.kml.StemKml;
import org.eclipse.stem.ui.ge.views.GEPreferencePage;
import org.eclipse.stem.ui.ge.views.GEViewActions;
import org.eclipse.stem.ui.ge.views.GEViewContentProvider;
import org.eclipse.stem.ui.ge.views.GEViewLabelProvider;
import org.eclipse.stem.ui.ge.views.Messages;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.ViewPart;

public class GEView
extends ViewPart {
    public static final String ID_GE_VIEW = "org.eclipse.stem.ui.views.ge";
    private ListViewer viewer = null;
    private Activator uiActivator = null;
    private static ColorRegistry colorRegistry = null;
    private GEViewContentProvider contentProvider = null;
    private GEInterface gei = null;
    private static boolean active = false;
    private static final int STANDARD_LENGTH = 370;
    private static final int STANDARD_HEIGHT = 15;

    public GEView() {
        if (active) {
            GELog.error("STEM - GoogleEarth interface already active", null);
            throw new RuntimeException("Duplicate");
        }
        active = true;
        this.gei = new GEInterface(this);
        GELog.debug(GEView.class, "gei=" + this.gei);
        if (colorRegistry == null) {
            this.uiActivator = Activator.getDefault();
            colorRegistry = this.uiActivator.getColorRegistry();
        }
    }

    public void createPartControl(Composite composite) {
        boolean bl;
        GEViewActions gEViewActions;
        boolean bl2 = GEPreferencePage.isDebug();
        if (bl2) {
            GELog.DEBUG = true;
            GELog.debug((Object)this, "Debug option turned on.");
        } else {
            GELog.debug((Object)this, "Debug option being turned off.");
            GELog.DEBUG = false;
        }
        GELog.debug("GEView.createPartControl:");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite.setLayout((Layout)gridLayout);
        String string = Aspect.getDefaultCode();
        this.createControlButtons(composite, string);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        Composite composite2 = this.getScrollable(composite, gridData);
        composite2.setLayout((Layout)new FillLayout());
        this.viewer = new ListViewer(composite2);
        this.contentProvider = new GEViewContentProvider(this.gei);
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        GEViewLabelProvider gEViewLabelProvider = new GEViewLabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)gEViewLabelProvider);
        gEViewLabelProvider.setGEI(this.gei);
        this.viewer.setInput((Object)SimulationManager.getManager());
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        IWorkbenchWindow iWorkbenchWindow = this.getSite().getWorkbenchWindow();
        ISelectionService iSelectionService = iWorkbenchWindow.getSelectionService();
        iSelectionService.addSelectionListener((ISelectionListener)this.contentProvider);
        boolean bl3 = this.gei.init();
        if (!bl3) {
            GELog.debug((Object)this, this.gei.getErrorMessage());
            this.showMessage(this.gei.getErrorMessage());
            this.gei.setErrorMessage(null);
        }
        if ((gEViewActions = new GEViewActions(this, this.gei)) == null) {
            GELog.error("Unable to setup context menu", null);
        }
        if (bl = GEPreferencePage.isAutoLaunch()) {
            StemKml.launchGE();
        }
    }

    public void refresh() {
        this.viewer.refresh();
    }

    public void showMessage(String string) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)Messages.getString("GEView.27"), (String)string);
    }

    public String verifyFolder(String string) {
        string = this.folderDialog(string);
        GELog.debug((Object)this, "verifyFolder=" + string);
        if (string != null) {
            GEPreferencePage.setFolder(string);
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String folderDialog(String string) {
        DirectoryDialog directoryDialog;
        String string2;
        block9: {
            string2 = null;
            try {
                File file;
                if (string != null) {
                    file = new File(string);
                    string2 = file.exists() && file.isDirectory() ? string : null;
                }
                while (true) {
                    if (string2 == null) {
                        file = File.createTempFile("XXX", "tmp");
                        string2 = file.getParent();
                        Shell shell = this.viewer.getControl().getShell();
                        int n = 65536;
                        directoryDialog = new DirectoryDialog(shell, n);
                        directoryDialog.setFilterPath(string2);
                        directoryDialog.setText(Messages.getString("GEView.30"));
                        directoryDialog.setMessage(Messages.getString("GEView.31"));
                        break block9;
                    }
                    boolean bl = this.checkContents(string2);
                    if (bl) {
                        return string2;
                    }
                    string2 = null;
                }
            }
            catch (Exception exception) {
                GELog.error("Folder Dialog", exception);
            }
            return string2;
        }
        while ((string2 = directoryDialog.open()) != null) {
            boolean bl;
            File file = new File(string2);
            if (file.exists() && file.isDirectory() && (bl = this.checkContents(string2))) {
                return string2;
            }
            if (file.exists()) continue;
            file.mkdirs();
        }
        return null;
    }

    public String displayFolderDialog(String string) {
        String string2;
        block5: {
            string2 = null;
            try {
                block4: {
                    File file;
                    if (string != null) {
                        file = new File(string);
                        string2 = file.exists() && file.isDirectory() ? string : null;
                    }
                    do {
                        file = this.viewer.getControl().getShell();
                        int n = 65536;
                        DirectoryDialog directoryDialog = new DirectoryDialog((Shell)file, n);
                        directoryDialog.setFilterPath(string2);
                        directoryDialog.setText(Messages.getString("GEView.30"));
                        directoryDialog.setMessage(Messages.getString("GEView.34"));
                        string2 = directoryDialog.open();
                        if (string2 == null) break block4;
                    } while (!this.validFolder(string2));
                    break block5;
                }
                string2 = null;
            }
            catch (Exception exception) {
                GELog.error("GEView: displayFolderDialog", exception);
                string2 = null;
            }
        }
        return string2;
    }

    private boolean validFolder(String string) {
        boolean bl = false;
        File file = new File(string);
        if (file.exists() && file.isDirectory()) {
            File[] fileArray = this.fileList(file);
            if (fileArray.length > 0) {
                bl = true;
            } else {
                Shell shell = this.viewer.getControl().getShell();
                int n = 65732;
                MessageBox messageBox = new MessageBox(shell, n);
                String string2 = Messages.getString("GEView.33");
                String string3 = String.format(string2, file.getAbsolutePath());
                messageBox.setMessage(string3);
                int n2 = messageBox.open();
                if (n2 == 64) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    private boolean checkContents(String string) {
        boolean bl = false;
        File file = new File(string);
        File[] fileArray = this.fileList(file);
        if (fileArray.length == 0) {
            bl = true;
        } else {
            Shell shell = this.viewer.getControl().getShell();
            int n = 65988;
            MessageBox messageBox = new MessageBox(shell, n);
            String string2 = Messages.getString("GEView.32");
            String string3 = String.format(string2, file.getAbsolutePath());
            messageBox.setMessage(string3);
            int n2 = messageBox.open();
            if (n2 == 64) {
                try {
                    File[] fileArray2 = fileArray;
                    int n3 = fileArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File file2 = fileArray2[n4];
                        file2.delete();
                        ++n4;
                    }
                    bl = true;
                }
                catch (Exception exception) {
                    GELog.error("Unable to delete KML files", exception);
                }
            } else if (n2 == 128) {
                bl = true;
            }
        }
        return bl;
    }

    private File[] fileList(File file) {
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                if (file.getName().toLowerCase().startsWith("net")) {
                    return false;
                }
                return file.getName().toLowerCase().endsWith(".kml");
            }
        };
        try {
            File[] fileArray = file.listFiles(fileFilter);
            if (fileArray == null) {
                return new File[0];
            }
            return fileArray;
        }
        catch (Exception exception) {
            GELog.error(exception.getMessage(), exception);
            return null;
        }
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public ListViewer getViewer() {
        return this.viewer;
    }

    public void dispose() {
        GELog.debug((Object)this, "Dispose()");
        this.gei.dispose();
        active = false;
    }

    public GEViewContentProvider getContentProvider() {
        return this.contentProvider;
    }

    private Composite getScrollable(Composite composite, GridData gridData) {
        ScrolledComposite scrolledComposite = new ScrolledComposite(composite, 768);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setLayoutData((Object)gridData);
        scrolledComposite.setMinSize(3000, 10000);
        Composite composite2 = new Composite((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)composite2);
        return composite2;
    }

    protected Composite createControlButtons(Composite composite, String string) {
        Button button = new Button(composite, 8);
        button.setText("Display");
        button.setToolTipText("Display current map");
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        ISimulation iSimulation = GEView.this.contentProvider.getCurrentSimulation();
                        if (iSimulation != null) {
                            boolean bl = GEView.this.gei.displayMap(iSimulation);
                            if (bl) break;
                            GEView.this.showMessage(Messages.getString("GEView.15"));
                            break;
                        }
                        GEView.this.showMessage("No active Simulation");
                    }
                }
            }
        });
        Group group = null;
        group = new Group(composite, 4);
        group.setText("Select Aspect to be displayed");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.makeColumnsEqualWidth = true;
        group.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.grabExcessVerticalSpace = false;
        gridData.heightHint = 31;
        gridData.minimumHeight = 31;
        gridData.widthHint = 370;
        gridData.minimumWidth = 370;
        group.setLayoutData((Object)gridData);
        Button button2 = new Button((Composite)group, 16);
        Button button3 = new Button((Composite)group, 16);
        Button button4 = new Button((Composite)group, 16);
        Button button5 = new Button((Composite)group, 16);
        button2.setText("S");
        button2.setSelection("S".equals(string));
        button2.setBackground(composite.getDisplay().getSystemColor(9));
        button2.setForeground(composite.getDisplay().getSystemColor(1));
        button2.setToolTipText("Suceptiple");
        button2.setLayoutData((Object)this.getButtonGridData());
        button3.setText("E");
        button3.setSelection("E".equals(string));
        button3.setBackground(composite.getDisplay().getSystemColor(7));
        button3.setToolTipText("Exposed");
        button3.setLayoutData((Object)this.getButtonGridData());
        button4.setText("I");
        button4.setSelection("I".equals(string));
        button4.setBackground(composite.getDisplay().getSystemColor(3));
        button4.setToolTipText("Infectious");
        button4.setLayoutData((Object)this.getButtonGridData());
        button5.setText("R");
        button5.setSelection("R".equals(string));
        button5.setBackground(composite.getDisplay().getSystemColor(5));
        button5.setToolTipText("Recovered");
        button5.setLayoutData((Object)this.getButtonGridData());
        button2.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        GEView.this.setAspect("S");
                    }
                }
            }
        });
        button3.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        GEView.this.setAspect("E");
                    }
                }
            }
        });
        button4.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        GEView.this.setAspect("I");
                    }
                }
            }
        });
        button5.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 13: {
                        GEView.this.setAspect("R");
                    }
                }
            }
        });
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        gridData2.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)gridData2);
        return group;
    }

    private void setAspect(String string) {
        GELog.debug((Object)this, string);
        Aspect aspect = Aspect.getAspect(string);
        ISimulation iSimulation = this.contentProvider.getCurrentSimulation();
        this.gei.setAspectToDisplay(iSimulation, aspect);
    }

    protected GridData getButtonGridData() {
        GridData gridData = new GridData();
        gridData.grabExcessVerticalSpace = false;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 0x1000000;
        return gridData;
    }
}

