/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.ge.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.ui.ge.Aspect;
import org.eclipse.stem.ui.ge.GEInterface;
import org.eclipse.stem.ui.ge.GELog;
import org.eclipse.stem.ui.ge.views.DisplayAreaDialog;
import org.eclipse.stem.ui.ge.views.GEPreferencePage;
import org.eclipse.stem.ui.ge.views.GEView;
import org.eclipse.stem.ui.ge.views.GEViewContentProvider;
import org.eclipse.stem.ui.ge.views.Messages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;

public class GEViewActions {
    private GEView geView = null;
    private GEInterface gei = null;
    private ListViewer viewer = null;
    private GEViewContentProvider contentProvider = null;
    private Action actionStop;
    private Action actionStart;
    private Action actionMap;
    private Action actionMapNode;
    private Action actionStatus;
    private Action actionGEStart;
    private Action actionGERestart;
    private Action actionGERun;
    private Action actionGEStop;
    private Action actionDebug;
    private Action doubleClickAction = null;

    public GEViewActions(GEView gEView, GEInterface gEInterface) {
        this.geView = gEView;
        this.gei = gEInterface;
        this.viewer = gEView.getViewer();
        this.contentProvider = gEView.getContentProvider();
        this.hookContextMenu();
    }

    private void makeActions() {
        this.actionStop = new Action(){

            public void run() {
                GEViewActions.this.gei.setActive(GEViewActions.this.contentProvider.getCurrentSimulation(), false);
                GEViewActions.this.geView.showMessage(Messages.getString("GEView.4"));
            }
        };
        this.actionStop.setText(Messages.getString("GEView.5"));
        this.actionStop.setToolTipText(Messages.getString("GEView.6"));
        this.actionStop.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.actionStart = new Action(){

            public void run() {
                String string = GEViewActions.this.geView.verifyFolder(GEPreferencePage.getFolder());
                if (string == null) {
                    return;
                }
                GEPreferencePage.setFolder(string);
                boolean bl = GEViewActions.this.gei.setActive(GEViewActions.this.contentProvider.getCurrentSimulation(), true);
                if (!bl) {
                    GEViewActions.this.geView.showMessage(GEViewActions.this.gei.getErrorMessage());
                } else {
                    GEViewActions.this.geView.showMessage(String.format("GoogleEarth logging ON. To: %s", string));
                }
            }
        };
        this.actionStart.setText(Messages.getString("GEView.7"));
        this.actionStart.setToolTipText(Messages.getString("GEView.8"));
        this.actionStart.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.actionGEStart = new Action(){

            public void run() {
                GEViewActions.this.gei.startGE();
            }
        };
        this.actionGEStart.setText(Messages.getString("GEView.9"));
        this.actionGEStart.setToolTipText(Messages.getString("GEView.10"));
        this.actionGEStart.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.actionGERestart = new Action(){

            public void run() {
                GEViewActions.this.gei.restartGE();
            }
        };
        this.actionGERestart.setText(Messages.getString("GEView.9a"));
        this.actionGERestart.setToolTipText(Messages.getString("GEView.10a"));
        this.actionGERestart.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.actionGERun = new Action(){

            public void run() {
                boolean bl;
                String string = GEPreferencePage.getFolder();
                string = GEViewActions.this.geView.displayFolderDialog(string);
                if (string != null && !(bl = GEViewActions.this.gei.runGE(string))) {
                    GEViewActions.this.geView.showMessage(GEViewActions.this.gei.getErrorMessage());
                }
            }
        };
        this.actionGERun.setText(Messages.getString("GEView.11"));
        this.actionGERun.setToolTipText(Messages.getString("GEView.12"));
        this.actionGERun.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.actionGEStop = new Action(){

            public void run() {
                GEViewActions.this.gei.stopGE();
            }
        };
        this.actionGEStop.setText(Messages.getString("GEView.13"));
        this.actionGEStop.setToolTipText(Messages.getString("GEView.14"));
        this.actionGEStop.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.actionMap = new Action(){

            public void run() {
                boolean bl = GEViewActions.this.gei.displayMap(GEViewActions.this.contentProvider.getCurrentSimulation());
                if (!bl) {
                    GEViewActions.this.geView.showMessage(Messages.getString("GEView.15"));
                }
            }
        };
        this.actionMap.setText(Messages.getString("GEView.16"));
        this.actionMap.setToolTipText(Messages.getString("GEView.17"));
        this.actionMap.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.actionMapNode = new Action(){

            public void run() {
                String string = null;
                String string2 = null;
                String string3 = null;
                DisplayAreaDialog displayAreaDialog = new DisplayAreaDialog(Display.getCurrent().getActiveShell());
                boolean bl = false;
                while (!bl) {
                    int n = displayAreaDialog.open();
                    if (n == 0 || n == 10) {
                        string2 = displayAreaDialog.getAdminFile();
                        string3 = displayAreaDialog.getSearch().trim();
                        boolean bl2 = displayAreaDialog.isClear();
                        Aspect aspect = GEViewActions.this.gei.getAspectToDisplay(GEViewActions.this.contentProvider.getCurrentSimulation());
                        GELog.debug((Object)this, "Display: " + string + " aspect: " + aspect.toString());
                        boolean bl3 = GEViewActions.this.gei.displayArea(string2, string3, bl2);
                        if (!bl3) {
                            GEViewActions.this.geView.showMessage(String.valueOf(Messages.getString("GEView.15n")) + "\n" + GEViewActions.this.gei.getErrorMessage());
                            continue;
                        }
                        if (n != 0) continue;
                        bl = true;
                        continue;
                    }
                    if (n != 1) continue;
                    bl = true;
                }
            }
        };
        this.actionMapNode.setText(Messages.getString("GEView.16n"));
        this.actionMapNode.setToolTipText(Messages.getString("GEView.17n"));
        this.actionMapNode.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.actionStatus = new Action(){

            public void run() {
                boolean bl = GELog.DEBUG;
                GELog.DEBUG = true;
                GEViewActions.this.gei.displayStatus();
                GELog.DEBUG = bl;
            }
        };
        this.actionStatus.setText(Messages.getString("GEView.18"));
        this.actionStatus.setToolTipText(Messages.getString("GEView.19"));
        this.actionStatus.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.actionDebug = new Action(){

            public void run() {
                if (GELog.DEBUG) {
                    GELog.debug((Object)this, "Turning DEBUG off");
                    GELog.DEBUG = false;
                } else {
                    GELog.DEBUG = true;
                    GELog.debug((Object)this, "Turned DEBUG on");
                }
            }
        };
        if (GELog.DEBUG) {
            this.actionDebug.setText(Messages.getString("GEView.20Off"));
        } else {
            this.actionDebug.setText(Messages.getString("GEView.20On"));
        }
        this.actionDebug.setToolTipText(Messages.getString("GEView.21"));
        this.actionDebug.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
    }

    private void hookContextMenu() {
        MenuManager menuManager = new MenuManager("GoogleEarth");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                GEViewActions.this.makeActions();
                GEViewActions.this.fillContextMenu(iMenuManager);
            }
        });
        Menu menu = menuManager.createContextMenu(this.viewer.getControl());
        menuManager.add((IContributionItem)new Separator("additions"));
        this.viewer.getControl().setMenu(menu);
        this.geView.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.viewer);
    }

    private void fillContextMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IContributionItem)new Separator("additions"));
        ISimulation iSimulation = this.contentProvider.getCurrentSimulation();
        if (iSimulation != null) {
            if (this.gei.isActive(iSimulation)) {
                this.actionStop.setEnabled(true);
                iMenuManager.add((IAction)this.actionStop);
                this.actionStart.setEnabled(false);
                iMenuManager.add((IAction)this.actionStart);
            } else {
                this.actionStop.setEnabled(false);
                iMenuManager.add((IAction)this.actionStop);
                this.actionStart.setEnabled(true);
                iMenuManager.add((IAction)this.actionStart);
            }
            iMenuManager.add((IAction)this.actionMap);
        }
        iMenuManager.add((IAction)this.actionMapNode);
        iMenuManager.add((IAction)this.actionStatus);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.actionDebug);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.actionGEStart);
        iMenuManager.add((IAction)this.actionGERestart);
        iMenuManager.add((IAction)this.actionGERun);
        iMenuManager.add((IAction)this.actionGEStop);
        iMenuManager.add((IContributionItem)new Separator("additions"));
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                GEViewActions.this.doubleClickAction.run();
            }
        });
    }
}

