/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.ge.views;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stem.definitions.nodes.impl.RegionImpl;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.ISimulationManagerListener;
import org.eclipse.stem.jobs.simulation.SimulationManager;
import org.eclipse.stem.jobs.simulation.SimulationManagerEvent;
import org.eclipse.stem.ui.ge.GEInterface;
import org.eclipse.stem.ui.ge.GELog;
import org.eclipse.stem.ui.ge.views.GEViewLabelProvider;
import org.eclipse.stem.ui.views.geographic.map.GeographicSelectionElements;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

public class GEViewContentProvider
implements IStructuredContentProvider,
ISimulationManagerListener,
ISelectionChangedListener,
ISelectionListener {
    private ListViewer viewer;
    private ISimulation currentSimulation = null;
    private SimulationManager simulationManager = null;
    private GEInterface gei = null;

    public GEViewContentProvider(GEInterface gEInterface) {
        this.gei = gEInterface;
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        GELog.debug(this, "inputChanged: old=" + object + " new=" + object2);
        this.viewer = (ListViewer)viewer;
        if (object != null) {
            ((SimulationManager)object).removeListener((ISimulationManagerListener)this);
        }
        this.simulationManager = (SimulationManager)object2;
        if (this.simulationManager != null) {
            this.simulationManager.addSimulationManagerListener((ISimulationManagerListener)this);
        }
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void dispose() {
        GELog.debug(this.getClass(), "dispose(): ");
        if (this.simulationManager != null) {
            this.simulationManager.removeListener((ISimulationManagerListener)this);
        }
        if (this.viewer != null) {
            this.viewer.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
    }

    public Object[] getElements(Object object) {
        SimulationManager simulationManager = (SimulationManager)object;
        List list = simulationManager.getActiveSimulations();
        int n = list.size();
        Object[] objectArray = new Object[n];
        int n2 = 0;
        while (n2 < n) {
            ISimulation iSimulation = (ISimulation)list.get(n2);
            objectArray[n2] = iSimulation;
            ++n2;
        }
        if (n == 1 && this.currentSimulation == null) {
            this.currentSimulation = (ISimulation)list.get(0);
        }
        return objectArray;
    }

    public void simulationsChanged(SimulationManagerEvent simulationManagerEvent) {
        GELog.debug(this.getClass(), "simulationsChange: ");
        this.viewer.remove((Object[])simulationManagerEvent.getSimulationsRemoved());
        this.viewer.add((Object[])simulationManagerEvent.getSimulationsAdded());
        if (this.currentSimulation == null && simulationManagerEvent.getSimulationsAdded().length > 0) {
            this.currentSimulation = simulationManagerEvent.getSimulationsAdded()[0];
            GELog.debug(this, "currentSimulation: " + this.currentSimulation.getName());
        }
        if (this.currentSimulation != null && simulationManagerEvent.getSimulationsRemoved().length > 0) {
            ISimulation[] iSimulationArray = simulationManagerEvent.getSimulationsRemoved();
            int n = iSimulationArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISimulation iSimulation = iSimulationArray[n2];
                if (this.currentSimulation == iSimulation) {
                    this.currentSimulation = null;
                    GELog.debug(this, "currentSimulation is now null ");
                }
                ++n2;
            }
        }
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (!(iSelection instanceof StructuredSelection)) {
            return;
        }
        Object[] objectArray = ((StructuredSelection)iSelection).toArray();
        if (objectArray.length != 2 || !(objectArray[1] instanceof GeographicSelectionElements)) {
            return;
        }
        RegionImpl regionImpl = (RegionImpl)objectArray[0];
        GeographicSelectionElements geographicSelectionElements = (GeographicSelectionElements)objectArray[1];
        GELog.debug(this, "MapView Selection: " + regionImpl);
        this.gei.displaySelection(regionImpl, geographicSelectionElements);
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        GELog.debug(this, "selectionChange: " + selectionChangedEvent);
        if (selectionChangedEvent.getSource() == this.viewer) {
            Object object;
            ISelection iSelection = selectionChangedEvent.getSelection();
            ArrayList<ISimulation> arrayList = new ArrayList<ISimulation>();
            if (selectionChangedEvent.getSelection() instanceof IStructuredSelection) {
                object = ((IStructuredSelection)iSelection).toList();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!(e instanceof ISimulation)) continue;
                    arrayList.add((ISimulation)e);
                }
            }
            if (arrayList.size() > 0) {
                this.currentSimulation = (ISimulation)arrayList.get(0);
                object = (GEViewLabelProvider)this.viewer.getLabelProvider();
                ((GEViewLabelProvider)((Object)object)).setSelected(this.currentSimulation);
            }
        }
    }

    public ISimulation getCurrentSimulation() {
        return this.currentSimulation;
    }
}

