/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.externaldatasource.presentation;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.MarkerHelper;
import org.eclipse.emf.common.ui.ViewerPane;
import org.eclipse.emf.common.ui.editor.ProblemEditorPart;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.UnwrappingSelectionProvider;
import org.eclipse.emf.edit.ui.util.EditUIMarkerHelper;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.emf.edit.ui.view.ExtendedPropertySheetPage;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stem.core.common.provider.CommonItemProviderAdapterFactory;
import org.eclipse.stem.core.graph.provider.GraphItemProviderAdapterFactory;
import org.eclipse.stem.core.model.provider.ModelItemProviderAdapterFactory;
import org.eclipse.stem.definitions.labels.provider.LabelsItemProviderAdapterFactory;
import org.eclipse.stem.diseasemodels.externaldatasource.presentation.ExternalDataSourceEditorPlugin;
import org.eclipse.stem.diseasemodels.externaldatasource.provider.ExternalDataSourceItemProviderAdapterFactory;
import org.eclipse.stem.diseasemodels.standard.provider.StandardItemProviderAdapterFactory;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertySheetPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalDataSourceEditor
extends MultiPageEditorPart
implements IEditingDomainProvider,
ISelectionProvider,
IMenuListener,
IViewerProvider,
IGotoMarker {
    protected AdapterFactoryEditingDomain editingDomain;
    protected ComposedAdapterFactory adapterFactory;
    protected IContentOutlinePage contentOutlinePage;
    protected IStatusLineManager contentOutlineStatusLineManager;
    protected TreeViewer contentOutlineViewer;
    protected PropertySheetPage propertySheetPage;
    protected TreeViewer selectionViewer;
    protected TreeViewer parentViewer;
    protected TreeViewer treeViewer;
    protected ListViewer listViewer;
    protected TableViewer tableViewer;
    protected TreeViewer treeViewerWithColumns;
    protected ViewerPane currentViewerPane;
    protected Viewer currentViewer;
    protected ISelectionChangedListener selectionChangedListener;
    protected Collection<ISelectionChangedListener> selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    protected ISelection editorSelection = StructuredSelection.EMPTY;
    protected MarkerHelper markerHelper = new EditUIMarkerHelper();
    protected IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart iWorkbenchPart) {
            if (iWorkbenchPart instanceof ContentOutline) {
                if (((ContentOutline)iWorkbenchPart).getCurrentPage() == ExternalDataSourceEditor.this.contentOutlinePage) {
                    ExternalDataSourceEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)ExternalDataSourceEditor.this);
                    ExternalDataSourceEditor.this.setCurrentViewer((Viewer)ExternalDataSourceEditor.this.contentOutlineViewer);
                }
            } else if (iWorkbenchPart instanceof PropertySheet) {
                if (((PropertySheet)iWorkbenchPart).getCurrentPage() == ExternalDataSourceEditor.this.propertySheetPage) {
                    ExternalDataSourceEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)ExternalDataSourceEditor.this);
                    ExternalDataSourceEditor.this.handleActivate();
                }
            } else if (iWorkbenchPart == ExternalDataSourceEditor.this) {
                ExternalDataSourceEditor.this.handleActivate();
            }
        }

        public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
        }

        public void partClosed(IWorkbenchPart iWorkbenchPart) {
        }

        public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
        }

        public void partOpened(IWorkbenchPart iWorkbenchPart) {
        }
    };
    protected Collection<Resource> removedResources = new ArrayList<Resource>();
    protected Collection<Resource> changedResources = new ArrayList<Resource>();
    protected Collection<Resource> savedResources = new ArrayList<Resource>();
    protected Map<Resource, Diagnostic> resourceToDiagnosticMap = new LinkedHashMap<Resource, Diagnostic>();
    protected boolean updateProblemIndication = true;
    protected EContentAdapter problemIndicationAdapter = new EContentAdapter(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void notifyChanged(Notification notification) {
            if (notification.getNotifier() instanceof Resource) {
                switch (notification.getFeatureID(Resource.class)) {
                    case 4: 
                    case 6: 
                    case 7: {
                        Resource resource = (Resource)notification.getNotifier();
                        Diagnostic diagnostic = ExternalDataSourceEditor.this.analyzeResourceProblems(resource, null);
                        if (diagnostic.getSeverity() != 0) {
                            ExternalDataSourceEditor.this.resourceToDiagnosticMap.put(resource, diagnostic);
                        } else {
                            ExternalDataSourceEditor.this.resourceToDiagnosticMap.remove(resource);
                        }
                        if (!ExternalDataSourceEditor.this.updateProblemIndication) return;
                        ExternalDataSourceEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                ExternalDataSourceEditor.this.updateProblemIndication();
                            }
                        });
                    }
                    default: {
                        return;
                    }
                }
            } else {
                super.notifyChanged(notification);
            }
        }

        protected void setTarget(Resource resource) {
            this.basicSetTarget((Notifier)resource);
        }

        protected void unsetTarget(Resource resource) {
            this.basicUnsetTarget((Notifier)resource);
        }
    };
    protected IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
            IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
            try {
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class ResourceDeltaVisitor
                implements IResourceDeltaVisitor {
                    protected ResourceSet resourceSet;
                    protected Collection<Resource> changedResources;
                    protected Collection<Resource> removedResources;

                    ResourceDeltaVisitor() {
                        this.resourceSet = (this).ExternalDataSourceEditor.this.editingDomain.getResourceSet();
                        this.changedResources = new ArrayList<Resource>();
                        this.removedResources = new ArrayList<Resource>();
                    }

                    public boolean visit(IResourceDelta iResourceDelta) {
                        Resource resource;
                        if (iResourceDelta.getFlags() != 131072 && iResourceDelta.getResource().getType() == 1 && (iResourceDelta.getKind() & 6) != 0 && (resource = this.resourceSet.getResource(URI.createURI((String)iResourceDelta.getFullPath().toString()), false)) != null) {
                            if ((iResourceDelta.getKind() & 2) != 0) {
                                this.removedResources.add(resource);
                            } else if (!(this).ExternalDataSourceEditor.this.savedResources.remove(resource)) {
                                this.changedResources.add(resource);
                            }
                        }
                        return true;
                    }

                    public Collection<Resource> getChangedResources() {
                        return this.changedResources;
                    }

                    public Collection<Resource> getRemovedResources() {
                        return this.removedResources;
                    }
                }
                ResourceDeltaVisitor resourceDeltaVisitor = new ResourceDeltaVisitor();
                iResourceDelta.accept((IResourceDeltaVisitor)resourceDeltaVisitor);
                if (!resourceDeltaVisitor.getRemovedResources().isEmpty()) {
                    ExternalDataSourceEditor.this.removedResources.addAll(resourceDeltaVisitor.getRemovedResources());
                    if (!ExternalDataSourceEditor.this.isDirty()) {
                        ExternalDataSourceEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                ExternalDataSourceEditor.this.getSite().getPage().closeEditor((IEditorPart)ExternalDataSourceEditor.this, false);
                                ExternalDataSourceEditor.this.dispose();
                            }
                        });
                    }
                }
                if (!resourceDeltaVisitor.getChangedResources().isEmpty()) {
                    ExternalDataSourceEditor.this.changedResources.addAll(resourceDeltaVisitor.getChangedResources());
                    if (ExternalDataSourceEditor.this.getSite().getPage().getActiveEditor() == ExternalDataSourceEditor.this) {
                        ExternalDataSourceEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                ExternalDataSourceEditor.this.handleActivate();
                            }
                        });
                    }
                }
            }
            catch (CoreException coreException) {
                ExternalDataSourceEditorPlugin.INSTANCE.log((Object)coreException);
            }
        }
    };

    protected void handleActivate() {
        if (this.editingDomain.getResourceToReadOnlyMap() != null) {
            this.editingDomain.getResourceToReadOnlyMap().clear();
            this.setSelection(this.getSelection());
        }
        if (!this.removedResources.isEmpty()) {
            if (this.handleDirtyConflict()) {
                this.getSite().getPage().closeEditor((IEditorPart)this, false);
                this.dispose();
            } else {
                this.removedResources.clear();
                this.changedResources.clear();
                this.savedResources.clear();
            }
        } else if (!this.changedResources.isEmpty()) {
            this.changedResources.removeAll(this.savedResources);
            this.handleChangedResources();
            this.changedResources.clear();
            this.savedResources.clear();
        }
    }

    protected void handleChangedResources() {
        if (!(this.changedResources.isEmpty() || this.isDirty() && !this.handleDirtyConflict())) {
            this.editingDomain.getCommandStack().flush();
            this.updateProblemIndication = false;
            for (Resource resource : this.changedResources) {
                if (!resource.isLoaded()) continue;
                resource.unload();
                try {
                    resource.load(Collections.EMPTY_MAP);
                }
                catch (IOException iOException) {
                    if (this.resourceToDiagnosticMap.containsKey(resource)) continue;
                    this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, iOException));
                }
            }
            this.updateProblemIndication = true;
            this.updateProblemIndication();
        }
    }

    protected void updateProblemIndication() {
        if (this.updateProblemIndication) {
            BasicDiagnostic basicDiagnostic = new BasicDiagnostic(0, "org.eclipse.stem.diseasemodels.externaldatasource.editor", 0, null, new Object[]{this.editingDomain.getResourceSet()});
            for (Diagnostic diagnostic : this.resourceToDiagnosticMap.values()) {
                if (diagnostic.getSeverity() == 0) continue;
                basicDiagnostic.add(diagnostic);
            }
            int n = this.getPageCount() - 1;
            if (n >= 0 && this.getEditor(n) instanceof ProblemEditorPart) {
                ((ProblemEditorPart)this.getEditor(n)).setDiagnostic((Diagnostic)basicDiagnostic);
                if (basicDiagnostic.getSeverity() != 0) {
                    this.setActivePage(n);
                }
            } else if (basicDiagnostic.getSeverity() != 0) {
                ProblemEditorPart problemEditorPart = new ProblemEditorPart();
                problemEditorPart.setDiagnostic((Diagnostic)basicDiagnostic);
                problemEditorPart.setMarkerHelper(this.markerHelper);
                try {
                    this.addPage(++n, (IEditorPart)problemEditorPart, this.getEditorInput());
                    this.setPageText(n, problemEditorPart.getPartName());
                    this.setActivePage(n);
                    this.showTabs();
                }
                catch (PartInitException partInitException) {
                    ExternalDataSourceEditorPlugin.INSTANCE.log((Object)partInitException);
                }
            }
            if (this.markerHelper.hasMarkers((Object)this.editingDomain.getResourceSet())) {
                this.markerHelper.deleteMarkers((Object)this.editingDomain.getResourceSet());
                if (basicDiagnostic.getSeverity() != 0) {
                    try {
                        this.markerHelper.createMarkers((Diagnostic)basicDiagnostic);
                    }
                    catch (CoreException coreException) {
                        ExternalDataSourceEditorPlugin.INSTANCE.log((Object)coreException);
                    }
                }
            }
        }
    }

    protected boolean handleDirtyConflict() {
        return MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)ExternalDataSourceEditor.getString("_UI_FileConflict_label"), (String)ExternalDataSourceEditor.getString("_WARN_FileConflict"));
    }

    public ExternalDataSourceEditor() {
        this.initializeEditingDomain();
    }

    protected void initializeEditingDomain() {
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ExternalDataSourceItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new StandardItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new CommonItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ModelItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new GraphItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new LabelsItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        BasicCommandStack basicCommandStack = new BasicCommandStack();
        basicCommandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(final EventObject eventObject) {
                ExternalDataSourceEditor.this.getContainer().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        ExternalDataSourceEditor.this.firePropertyChange(257);
                        Command command = ((CommandStack)eventObject.getSource()).getMostRecentCommand();
                        if (command != null) {
                            ExternalDataSourceEditor.this.setSelectionToViewer(command.getAffectedObjects());
                        }
                        if ((this).ExternalDataSourceEditor.this.propertySheetPage != null && !(this).ExternalDataSourceEditor.this.propertySheetPage.getControl().isDisposed()) {
                            (this).ExternalDataSourceEditor.this.propertySheetPage.refresh();
                        }
                    }
                });
            }
        });
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)basicCommandStack, new HashMap());
    }

    protected void firePropertyChange(int n) {
        super.firePropertyChange(n);
    }

    public void setSelectionToViewer(Collection<?> collection) {
        final Collection<?> collection2 = collection;
        if (collection2 != null && !collection2.isEmpty()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    if (ExternalDataSourceEditor.this.currentViewer != null) {
                        ExternalDataSourceEditor.this.currentViewer.setSelection((ISelection)new StructuredSelection(collection2.toArray()), true);
                    }
                }
            };
            runnable.run();
        }
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void setCurrentViewerPane(ViewerPane viewerPane) {
        if (this.currentViewerPane != viewerPane) {
            if (this.currentViewerPane != null) {
                this.currentViewerPane.showFocus(false);
            }
            this.currentViewerPane = viewerPane;
        }
        this.setCurrentViewer(this.currentViewerPane.getViewer());
    }

    public void setCurrentViewer(Viewer viewer) {
        if (this.currentViewer != viewer) {
            if (this.selectionChangedListener == null) {
                this.selectionChangedListener = new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                        ExternalDataSourceEditor.this.setSelection(selectionChangedEvent.getSelection());
                    }
                };
            }
            if (this.currentViewer != null) {
                this.currentViewer.removeSelectionChangedListener(this.selectionChangedListener);
            }
            if (viewer != null) {
                viewer.addSelectionChangedListener(this.selectionChangedListener);
            }
            this.currentViewer = viewer;
            this.setSelection((ISelection)(this.currentViewer == null ? StructuredSelection.EMPTY : this.currentViewer.getSelection()));
        }
    }

    public Viewer getViewer() {
        return this.currentViewer;
    }

    protected void createContextMenuFor(StructuredViewer structuredViewer) {
        MenuManager menuManager = new MenuManager("#PopUp");
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)this);
        Menu menu = menuManager.createContextMenu(structuredViewer.getControl());
        structuredViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)new UnwrappingSelectionProvider((ISelectionProvider)structuredViewer));
        int n = 7;
        Transfer[] transferArray = new Transfer[]{LocalTransfer.getInstance()};
        structuredViewer.addDragSupport(n, transferArray, (DragSourceListener)new ViewerDragAdapter((Viewer)structuredViewer));
        structuredViewer.addDropSupport(n, transferArray, (DropTargetListener)new EditingDomainViewerDropAdapter((EditingDomain)this.editingDomain, (Viewer)structuredViewer));
    }

    public void createModel() {
        URI uRI = EditUIUtil.getURI((IEditorInput)this.getEditorInput());
        Exception exception = null;
        Resource resource = null;
        try {
            resource = this.editingDomain.getResourceSet().getResource(uRI, true);
        }
        catch (Exception exception2) {
            exception = exception2;
            resource = this.editingDomain.getResourceSet().getResource(uRI, false);
        }
        Diagnostic diagnostic = this.analyzeResourceProblems(resource, exception);
        if (diagnostic.getSeverity() != 0) {
            this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
        }
        this.editingDomain.getResourceSet().eAdapters().add((Object)this.problemIndicationAdapter);
    }

    public Diagnostic analyzeResourceProblems(Resource resource, Exception exception) {
        if (!resource.getErrors().isEmpty() || !resource.getWarnings().isEmpty()) {
            BasicDiagnostic basicDiagnostic = new BasicDiagnostic(4, "org.eclipse.stem.diseasemodels.externaldatasource.editor", 0, ExternalDataSourceEditor.getString("_UI_CreateModelError_message", resource.getURI()), new Object[]{exception == null ? resource : exception});
            basicDiagnostic.merge(EcoreUtil.computeDiagnostic((Resource)resource, (boolean)true));
            return basicDiagnostic;
        }
        if (exception != null) {
            return new BasicDiagnostic(4, "org.eclipse.stem.diseasemodels.externaldatasource.editor", 0, ExternalDataSourceEditor.getString("_UI_CreateModelError_message", resource.getURI()), new Object[]{exception});
        }
        return Diagnostic.OK_INSTANCE;
    }

    public void createPages() {
        this.createModel();
        if (!this.getEditingDomain().getResourceSet().getResources().isEmpty() && !((Resource)this.getEditingDomain().getResourceSet().getResources().get(0)).getContents().isEmpty()) {
            ViewerPane viewerPane = new ViewerPane(this.getSite().getPage(), (IWorkbenchPart)this){

                public Viewer createViewer(Composite composite) {
                    Tree tree = new Tree(composite, 2);
                    TreeViewer treeViewer = new TreeViewer(tree);
                    return treeViewer;
                }

                public void requestActivation() {
                    super.requestActivation();
                    ExternalDataSourceEditor.this.setCurrentViewerPane(this);
                }
            };
            viewerPane.createControl(this.getContainer());
            this.selectionViewer = (TreeViewer)viewerPane.getViewer();
            this.selectionViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
            this.selectionViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory));
            this.selectionViewer.setInput((Object)this.editingDomain.getResourceSet());
            this.selectionViewer.setSelection((ISelection)new StructuredSelection(this.editingDomain.getResourceSet().getResources().get(0)), true);
            viewerPane.setTitle((Object)this.editingDomain.getResourceSet());
            new AdapterFactoryTreeEditor(this.selectionViewer.getTree(), (AdapterFactory)this.adapterFactory);
            this.createContextMenuFor((StructuredViewer)this.selectionViewer);
            int n = this.addPage(viewerPane.getControl());
            this.setPageText(n, ExternalDataSourceEditor.getString("_UI_SelectionPage_label"));
            viewerPane = new ViewerPane(this.getSite().getPage(), (IWorkbenchPart)this){

                public Viewer createViewer(Composite composite) {
                    Tree tree = new Tree(composite, 2);
                    TreeViewer treeViewer = new TreeViewer(tree);
                    return treeViewer;
                }

                public void requestActivation() {
                    super.requestActivation();
                    ExternalDataSourceEditor.this.setCurrentViewerPane(this);
                }
            };
            viewerPane.createControl(this.getContainer());
            this.parentViewer = (TreeViewer)viewerPane.getViewer();
            this.parentViewer.setAutoExpandLevel(30);
            this.parentViewer.setContentProvider((IContentProvider)new ReverseAdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
            this.parentViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory));
            this.createContextMenuFor((StructuredViewer)this.parentViewer);
            n = this.addPage(viewerPane.getControl());
            this.setPageText(n, ExternalDataSourceEditor.getString("_UI_ParentPage_label"));
            viewerPane = new ViewerPane(this.getSite().getPage(), (IWorkbenchPart)this){

                public Viewer createViewer(Composite composite) {
                    return new ListViewer(composite);
                }

                public void requestActivation() {
                    super.requestActivation();
                    ExternalDataSourceEditor.this.setCurrentViewerPane(this);
                }
            };
            viewerPane.createControl(this.getContainer());
            this.listViewer = (ListViewer)viewerPane.getViewer();
            this.listViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
            this.listViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory));
            this.createContextMenuFor((StructuredViewer)this.listViewer);
            n = this.addPage(viewerPane.getControl());
            this.setPageText(n, ExternalDataSourceEditor.getString("_UI_ListPage_label"));
            viewerPane = new ViewerPane(this.getSite().getPage(), (IWorkbenchPart)this){

                public Viewer createViewer(Composite composite) {
                    return new TreeViewer(composite);
                }

                public void requestActivation() {
                    super.requestActivation();
                    ExternalDataSourceEditor.this.setCurrentViewerPane(this);
                }
            };
            viewerPane.createControl(this.getContainer());
            this.treeViewer = (TreeViewer)viewerPane.getViewer();
            this.treeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
            this.treeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory));
            new AdapterFactoryTreeEditor(this.treeViewer.getTree(), (AdapterFactory)this.adapterFactory);
            this.createContextMenuFor((StructuredViewer)this.treeViewer);
            n = this.addPage(viewerPane.getControl());
            this.setPageText(n, ExternalDataSourceEditor.getString("_UI_TreePage_label"));
            viewerPane = new ViewerPane(this.getSite().getPage(), (IWorkbenchPart)this){

                public Viewer createViewer(Composite composite) {
                    return new TableViewer(composite);
                }

                public void requestActivation() {
                    super.requestActivation();
                    ExternalDataSourceEditor.this.setCurrentViewerPane(this);
                }
            };
            viewerPane.createControl(this.getContainer());
            this.tableViewer = (TableViewer)viewerPane.getViewer();
            Table table = this.tableViewer.getTable();
            TableLayout tableLayout = new TableLayout();
            table.setLayout((Layout)tableLayout);
            table.setHeaderVisible(true);
            table.setLinesVisible(true);
            TableColumn tableColumn = new TableColumn(table, 0);
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(3, 100, true));
            tableColumn.setText(ExternalDataSourceEditor.getString("_UI_ObjectColumn_label"));
            tableColumn.setResizable(true);
            TableColumn tableColumn2 = new TableColumn(table, 0);
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(2, 100, true));
            tableColumn2.setText(ExternalDataSourceEditor.getString("_UI_SelfColumn_label"));
            tableColumn2.setResizable(true);
            this.tableViewer.setColumnProperties(new String[]{"a", "b"});
            this.tableViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
            this.tableViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory));
            this.createContextMenuFor((StructuredViewer)this.tableViewer);
            int n2 = this.addPage(viewerPane.getControl());
            this.setPageText(n2, ExternalDataSourceEditor.getString("_UI_TablePage_label"));
            viewerPane = new ViewerPane(this.getSite().getPage(), (IWorkbenchPart)this){

                public Viewer createViewer(Composite composite) {
                    return new TreeViewer(composite);
                }

                public void requestActivation() {
                    super.requestActivation();
                    ExternalDataSourceEditor.this.setCurrentViewerPane(this);
                }
            };
            viewerPane.createControl(this.getContainer());
            this.treeViewerWithColumns = (TreeViewer)viewerPane.getViewer();
            table = this.treeViewerWithColumns.getTree();
            table.setLayoutData((Object)new FillLayout());
            table.setHeaderVisible(true);
            table.setLinesVisible(true);
            tableLayout = new TreeColumn((Tree)table, 0);
            tableLayout.setText(ExternalDataSourceEditor.getString("_UI_ObjectColumn_label"));
            tableLayout.setResizable(true);
            tableLayout.setWidth(250);
            tableColumn = new TreeColumn((Tree)table, 0);
            tableColumn.setText(ExternalDataSourceEditor.getString("_UI_SelfColumn_label"));
            tableColumn.setResizable(true);
            tableColumn.setWidth(200);
            this.treeViewerWithColumns.setColumnProperties(new String[]{"a", "b"});
            this.treeViewerWithColumns.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
            this.treeViewerWithColumns.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory));
            this.createContextMenuFor((StructuredViewer)this.treeViewerWithColumns);
            int n3 = this.addPage(viewerPane.getControl());
            this.setPageText(n3, ExternalDataSourceEditor.getString("_UI_TreeWithColumnsPage_label"));
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ExternalDataSourceEditor.this.setActivePage(0);
                }
            });
        }
        this.getContainer().addControlListener((ControlListener)new ControlAdapter(){
            boolean guard = false;

            public void controlResized(ControlEvent controlEvent) {
                if (!this.guard) {
                    this.guard = true;
                    ExternalDataSourceEditor.this.hideTabs();
                    this.guard = false;
                }
            }
        });
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                ExternalDataSourceEditor.this.updateProblemIndication();
            }
        });
    }

    protected void hideTabs() {
        if (this.getPageCount() <= 1) {
            this.setPageText(0, "");
            if (this.getContainer() instanceof CTabFolder) {
                ((CTabFolder)this.getContainer()).setTabHeight(1);
                Point point = this.getContainer().getSize();
                this.getContainer().setSize(point.x, point.y + 6);
            }
        }
    }

    protected void showTabs() {
        if (this.getPageCount() > 1) {
            this.setPageText(0, ExternalDataSourceEditor.getString("_UI_SelectionPage_label"));
            if (this.getContainer() instanceof CTabFolder) {
                ((CTabFolder)this.getContainer()).setTabHeight(-1);
                Point point = this.getContainer().getSize();
                this.getContainer().setSize(point.x, point.y - 6);
            }
        }
    }

    protected void pageChange(int n) {
        super.pageChange(n);
        if (this.contentOutlinePage != null) {
            this.handleContentOutlineSelection(this.contentOutlinePage.getSelection());
        }
    }

    public Object getAdapter(Class clazz) {
        if (clazz.equals(IContentOutlinePage.class)) {
            return this.showOutlineView() ? this.getContentOutlinePage() : null;
        }
        if (clazz.equals(IPropertySheetPage.class)) {
            return this.getPropertySheetPage();
        }
        if (clazz.equals(IGotoMarker.class)) {
            return this;
        }
        return super.getAdapter(clazz);
    }

    public IContentOutlinePage getContentOutlinePage() {
        if (this.contentOutlinePage == null) {
            class MyContentOutlinePage
            extends ContentOutlinePage {
                MyContentOutlinePage() {
                }

                public void createControl(Composite composite) {
                    super.createControl(composite);
                    ExternalDataSourceEditor.this.contentOutlineViewer = this.getTreeViewer();
                    ExternalDataSourceEditor.this.contentOutlineViewer.addSelectionChangedListener((ISelectionChangedListener)this);
                    ExternalDataSourceEditor.this.contentOutlineViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)ExternalDataSourceEditor.this.adapterFactory));
                    ExternalDataSourceEditor.this.contentOutlineViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)ExternalDataSourceEditor.this.adapterFactory));
                    ExternalDataSourceEditor.this.contentOutlineViewer.setInput((Object)ExternalDataSourceEditor.this.editingDomain.getResourceSet());
                    ExternalDataSourceEditor.this.createContextMenuFor((StructuredViewer)ExternalDataSourceEditor.this.contentOutlineViewer);
                    if (!ExternalDataSourceEditor.this.editingDomain.getResourceSet().getResources().isEmpty()) {
                        ExternalDataSourceEditor.this.contentOutlineViewer.setSelection((ISelection)new StructuredSelection(ExternalDataSourceEditor.this.editingDomain.getResourceSet().getResources().get(0)), true);
                    }
                }

                public void makeContributions(IMenuManager iMenuManager, IToolBarManager iToolBarManager, IStatusLineManager iStatusLineManager) {
                    super.makeContributions(iMenuManager, iToolBarManager, iStatusLineManager);
                    ExternalDataSourceEditor.this.contentOutlineStatusLineManager = iStatusLineManager;
                }

                public void setActionBars(IActionBars iActionBars) {
                    super.setActionBars(iActionBars);
                    ExternalDataSourceEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, iActionBars);
                }
            }
            this.contentOutlinePage = new MyContentOutlinePage();
            this.contentOutlinePage.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                    ExternalDataSourceEditor.this.handleContentOutlineSelection(selectionChangedEvent.getSelection());
                }
            });
        }
        return this.contentOutlinePage;
    }

    public IPropertySheetPage getPropertySheetPage() {
        if (this.propertySheetPage == null) {
            this.propertySheetPage = new ExtendedPropertySheetPage(this.editingDomain){

                public void setSelectionToViewer(List<?> list) {
                    ExternalDataSourceEditor.this.setSelectionToViewer(list);
                    ExternalDataSourceEditor.this.setFocus();
                }

                public void setActionBars(IActionBars iActionBars) {
                    super.setActionBars(iActionBars);
                    ExternalDataSourceEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, iActionBars);
                }
            };
            this.propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
        }
        return this.propertySheetPage;
    }

    public void handleContentOutlineSelection(ISelection iSelection) {
        Iterator iterator;
        if (this.currentViewerPane != null && !iSelection.isEmpty() && iSelection instanceof IStructuredSelection && (iterator = ((IStructuredSelection)iSelection).iterator()).hasNext()) {
            Object e = iterator.next();
            if (this.currentViewerPane.getViewer() == this.selectionViewer) {
                ArrayList arrayList = new ArrayList();
                arrayList.add(e);
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next());
                }
                this.selectionViewer.setSelection((ISelection)new StructuredSelection(arrayList));
            } else if (this.currentViewerPane.getViewer().getInput() != e) {
                this.currentViewerPane.getViewer().setInput(e);
                this.currentViewerPane.setTitle(e);
            }
        }
    }

    public boolean isDirty() {
        return ((BasicCommandStack)this.editingDomain.getCommandStack()).isSaveNeeded();
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        final HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor iProgressMonitor) {
                boolean bl = true;
                for (Resource resource : ExternalDataSourceEditor.this.editingDomain.getResourceSet().getResources()) {
                    if (!bl && resource.getContents().isEmpty() && !ExternalDataSourceEditor.this.isPersisted(resource) || ExternalDataSourceEditor.this.editingDomain.isReadOnly(resource)) continue;
                    try {
                        ExternalDataSourceEditor.this.savedResources.add(resource);
                        resource.save(hashMap);
                    }
                    catch (Exception exception) {
                        ExternalDataSourceEditor.this.resourceToDiagnosticMap.put(resource, ExternalDataSourceEditor.this.analyzeResourceProblems(resource, exception));
                    }
                    bl = false;
                }
            }
        };
        this.updateProblemIndication = false;
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, false, (IRunnableWithProgress)workspaceModifyOperation);
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            this.firePropertyChange(257);
        }
        catch (Exception exception) {
            ExternalDataSourceEditorPlugin.INSTANCE.log(exception);
        }
        this.updateProblemIndication = true;
        this.updateProblemIndication();
    }

    protected boolean isPersisted(Resource resource) {
        boolean bl = false;
        try {
            InputStream inputStream = this.editingDomain.getResourceSet().getURIConverter().createInputStream(resource.getURI());
            if (inputStream != null) {
                bl = true;
                inputStream.close();
            }
        }
        catch (IOException iOException) {}
        return bl;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSaveAs() {
        IFile iFile;
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.open();
        IPath iPath = saveAsDialog.getResult();
        if (iPath != null && (iFile = ResourcesPlugin.getWorkspace().getRoot().getFile(iPath)) != null) {
            this.doSaveAs(URI.createPlatformResourceURI((String)iFile.getFullPath().toString(), (boolean)true), (IEditorInput)new FileEditorInput(iFile));
        }
    }

    protected void doSaveAs(URI uRI, IEditorInput iEditorInput) {
        ((Resource)this.editingDomain.getResourceSet().getResources().get(0)).setURI(uRI);
        this.setInputWithNotify(iEditorInput);
        this.setPartName(iEditorInput.getName());
        NullProgressMonitor nullProgressMonitor = this.getActionBars().getStatusLineManager() != null ? this.getActionBars().getStatusLineManager().getProgressMonitor() : new NullProgressMonitor();
        this.doSave((IProgressMonitor)nullProgressMonitor);
    }

    public void gotoMarker(IMarker iMarker) {
        try {
            String string;
            if (iMarker.getType().equals("org.eclipse.emf.ecore.diagnostic") && (string = iMarker.getAttribute("uri", null)) != null) {
                URI uRI = URI.createURI((String)string);
                EObject eObject = this.editingDomain.getResourceSet().getEObject(uRI, true);
                if (eObject != null) {
                    this.setSelectionToViewer(Collections.singleton(this.editingDomain.getWrapper((Object)eObject)));
                }
            }
        }
        catch (CoreException coreException) {
            ExternalDataSourceEditorPlugin.INSTANCE.log((Object)coreException);
        }
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) {
        this.setSite((IWorkbenchPartSite)iEditorSite);
        this.setInputWithNotify(iEditorInput);
        this.setPartName(iEditorInput.getName());
        iEditorSite.setSelectionProvider((ISelectionProvider)this);
        iEditorSite.getPage().addPartListener(this.partListener);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
    }

    public void setFocus() {
        if (this.currentViewerPane != null) {
            this.currentViewerPane.setFocus();
        } else {
            this.getControl(this.getActivePage()).setFocus();
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.selectionChangedListeners.add(iSelectionChangedListener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.selectionChangedListeners.remove(iSelectionChangedListener);
    }

    public ISelection getSelection() {
        return this.editorSelection;
    }

    public void setSelection(ISelection iSelection) {
        this.editorSelection = iSelection;
        for (ISelectionChangedListener iSelectionChangedListener : this.selectionChangedListeners) {
            iSelectionChangedListener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, iSelection));
        }
        this.setStatusLineManager(iSelection);
    }

    public void setStatusLineManager(ISelection iSelection) {
        IStatusLineManager iStatusLineManager;
        IStatusLineManager iStatusLineManager2 = iStatusLineManager = this.currentViewer != null && this.currentViewer == this.contentOutlineViewer ? this.contentOutlineStatusLineManager : this.getActionBars().getStatusLineManager();
        if (iStatusLineManager != null) {
            if (iSelection instanceof IStructuredSelection) {
                List list = ((IStructuredSelection)iSelection).toList();
                switch (list.size()) {
                    case 0: {
                        iStatusLineManager.setMessage(ExternalDataSourceEditor.getString("_UI_NoObjectSelected"));
                        break;
                    }
                    case 1: {
                        String string = new AdapterFactoryItemDelegator((AdapterFactory)this.adapterFactory).getText(list.iterator().next());
                        iStatusLineManager.setMessage(ExternalDataSourceEditor.getString("_UI_SingleObjectSelected", string));
                        break;
                    }
                    default: {
                        iStatusLineManager.setMessage(ExternalDataSourceEditor.getString("_UI_MultiObjectSelected", Integer.toString(list.size())));
                        break;
                    }
                }
            } else {
                iStatusLineManager.setMessage("");
            }
        }
    }

    private static String getString(String string) {
        return ExternalDataSourceEditorPlugin.INSTANCE.getString(string);
    }

    private static String getString(String string, Object object) {
        return ExternalDataSourceEditorPlugin.INSTANCE.getString(string, new Object[]{object});
    }

    public void menuAboutToShow(IMenuManager iMenuManager) {
        ((IMenuListener)this.getEditorSite().getActionBarContributor()).menuAboutToShow(iMenuManager);
    }

    public EditingDomainActionBarContributor getActionBarContributor() {
        return (EditingDomainActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    public IActionBars getActionBars() {
        return this.getActionBarContributor().getActionBars();
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public void dispose() {
        this.updateProblemIndication = false;
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        this.getSite().getPage().removePartListener(this.partListener);
        this.adapterFactory.dispose();
        if (this.getActionBarContributor().getActiveEditor() == this) {
            this.getActionBarContributor().setActiveEditor(null);
        }
        if (this.propertySheetPage != null) {
            this.propertySheetPage.dispose();
        }
        if (this.contentOutlinePage != null) {
            this.contentOutlinePage.dispose();
        }
        super.dispose();
    }

    protected boolean showOutlineView() {
        return true;
    }

    public class ReverseAdapterFactoryContentProvider
    extends AdapterFactoryContentProvider {
        public ReverseAdapterFactoryContentProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Object[] getElements(Object object) {
            Object object2 = super.getParent(object);
            return (object2 == null ? Collections.EMPTY_SET : Collections.singleton(object2)).toArray();
        }

        public Object[] getChildren(Object object) {
            Object object2 = super.getParent(object);
            return (object2 == null ? Collections.EMPTY_SET : Collections.singleton(object2)).toArray();
        }

        public boolean hasChildren(Object object) {
            Object object2 = super.getParent(object);
            return object2 != null;
        }

        public Object getParent(Object object) {
            return null;
        }
    }
}

