/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.standard.presentation;

import java.io.File;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.stem.diseasemodels.standard.StandardFactory;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.diseasemodels.standard.presentation.DiseasemodelsEditorAdvisor;
import org.eclipse.stem.diseasemodels.standard.presentation.DiseasemodelsEditorPlugin;
import org.eclipse.stem.diseasemodels.standard.presentation.StandardEditor;
import org.eclipse.stem.diseasemodels.standard.provider.DiseasemodelsEditPlugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardModelWizard
extends Wizard
implements INewWizard {
    public static final List<String> FILE_EXTENSIONS = Collections.unmodifiableList(Arrays.asList(DiseasemodelsEditorPlugin.INSTANCE.getString("_UI_StandardEditorFilenameExtensions").split("\\s*,\\s*")));
    public static final String FORMATTED_FILE_EXTENSIONS = DiseasemodelsEditorPlugin.INSTANCE.getString("_UI_StandardEditorFilenameExtensions").replaceAll("\\s*,\\s*", ", ");
    protected StandardPackage standardPackage = StandardPackage.eINSTANCE;
    protected StandardFactory standardFactory = this.standardPackage.getStandardFactory();
    protected StandardModelWizardInitialObjectCreationPage initialObjectCreationPage;
    protected IStructuredSelection selection;
    protected IWorkbench workbench;
    protected List<String> initialObjectNames;

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.workbench = iWorkbench;
        this.selection = iStructuredSelection;
        this.setWindowTitle(DiseasemodelsEditorPlugin.INSTANCE.getString("_UI_Wizard_label"));
        this.setDefaultPageImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(DiseasemodelsEditorPlugin.INSTANCE.getImage("full/wizban/NewStandard")));
    }

    protected Collection<String> getInitialObjectNames() {
        if (this.initialObjectNames == null) {
            this.initialObjectNames = new ArrayList<String>();
            for (EClassifier eClassifier : this.standardPackage.getEClassifiers()) {
                EClass eClass;
                if (!(eClassifier instanceof EClass) || (eClass = (EClass)eClassifier).isAbstract()) continue;
                this.initialObjectNames.add(eClass.getName());
            }
            Collections.sort(this.initialObjectNames, Collator.getInstance());
        }
        return this.initialObjectNames;
    }

    protected EObject createInitialModel() {
        EClass eClass = (EClass)this.standardPackage.getEClassifier(this.initialObjectCreationPage.getInitialObjectName());
        EObject eObject = this.standardFactory.create(eClass);
        return eObject;
    }

    public boolean performFinish() {
        URI uRI;
        block3: {
            try {
                uRI = this.getModelURI();
                if (!new File(uRI.toFileString()).exists() || MessageDialog.openQuestion((Shell)this.getShell(), (String)DiseasemodelsEditorPlugin.INSTANCE.getString("_UI_Question_title"), (String)DiseasemodelsEditorPlugin.INSTANCE.getString("_WARN_FileConflict", new String[]{uRI.toFileString()}))) break block3;
                this.initialObjectCreationPage.selectFileField();
                return false;
            }
            catch (Exception exception) {
                DiseasemodelsEditorPlugin.INSTANCE.log(exception);
                return false;
            }
        }
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) {
                try {
                    try {
                        ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
                        Resource resource = resourceSetImpl.createResource(uRI);
                        EObject eObject = StandardModelWizard.this.createInitialModel();
                        if (eObject != null) {
                            resource.getContents().add((Object)eObject);
                        }
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        hashMap.put("ENCODING", StandardModelWizard.this.initialObjectCreationPage.getEncoding());
                        resource.save(hashMap);
                    }
                    catch (Exception exception) {
                        DiseasemodelsEditorPlugin.INSTANCE.log(exception);
                        iProgressMonitor.done();
                    }
                }
                finally {
                    iProgressMonitor.done();
                }
            }
        };
        this.getContainer().run(false, false, iRunnableWithProgress);
        return DiseasemodelsEditorAdvisor.openEditor(this.workbench, uRI);
    }

    public void addPages() {
        this.initialObjectCreationPage = new StandardModelWizardInitialObjectCreationPage("Whatever2");
        this.initialObjectCreationPage.setTitle(DiseasemodelsEditorPlugin.INSTANCE.getString("_UI_StandardModelWizard_label"));
        this.initialObjectCreationPage.setDescription(DiseasemodelsEditorPlugin.INSTANCE.getString("_UI_Wizard_initial_object_description"));
        this.addPage((IWizardPage)this.initialObjectCreationPage);
    }

    public URI getModelURI() {
        return this.initialObjectCreationPage.getFileURI();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class StandardModelWizardInitialObjectCreationPage
    extends WizardPage {
        protected Text fileField;
        protected Combo initialObjectField;
        protected List<String> encodings;
        protected Combo encodingField;
        protected ModifyListener validator;

        public StandardModelWizardInitialObjectCreationPage(String string) {
            super(string);
            this.validator = new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    StandardModelWizardInitialObjectCreationPage.this.setPageComplete(StandardModelWizardInitialObjectCreationPage.this.validatePage());
                }
            };
        }

        public void createControl(Composite composite) {
            Composite composite2 = new Composite(composite, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 1;
            gridLayout.verticalSpacing = 12;
            composite2.setLayout((Layout)gridLayout);
            GridData gridData = new GridData();
            gridData.verticalAlignment = 4;
            gridData.grabExcessVerticalSpace = true;
            gridData.horizontalAlignment = 4;
            composite2.setLayoutData((Object)gridData);
            gridLayout = new Label(composite2, 16384);
            gridLayout.setText(DiseasemodelsEditorPlugin.INSTANCE.getString("_UI_File_label"));
            gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridLayout.setLayoutData((Object)gridData);
            gridData = new Composite(composite2, 0);
            GridData gridData2 = new GridData();
            gridData2.horizontalAlignment = 3;
            gridData.setLayoutData((Object)gridData2);
            GridLayout gridLayout2 = new GridLayout();
            gridData2.horizontalAlignment = 4;
            gridLayout2.marginHeight = 0;
            gridLayout2.marginWidth = 0;
            gridLayout2.numColumns = 2;
            gridData.setLayout((Layout)gridLayout2);
            this.fileField = new Text((Composite)gridData, 2048);
            gridData2 = new GridData();
            gridData2.horizontalAlignment = 4;
            gridData2.grabExcessHorizontalSpace = true;
            gridData2.horizontalSpan = 1;
            this.fileField.setLayoutData((Object)gridData2);
            this.fileField.addModifyListener(this.validator);
            gridData2 = new Button((Composite)gridData, 8);
            gridData2.setText(DiseasemodelsEditorPlugin.INSTANCE.getString("_UI_Browse_label"));
            gridData2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    String[] stringArray = StandardEditor.FILE_EXTENSION_FILTERS.toArray(new String[StandardEditor.FILE_EXTENSION_FILTERS.size()]);
                    String[] stringArray2 = DiseasemodelsEditorAdvisor.openFilePathDialog(StandardModelWizardInitialObjectCreationPage.this.getShell(), 8192, stringArray);
                    if (stringArray2.length > 0) {
                        StandardModelWizardInitialObjectCreationPage.this.fileField.setText(stringArray2[0]);
                    }
                }
            });
            gridLayout2 = new Label(composite2, 16384);
            gridLayout2.setText(DiseasemodelsEditorPlugin.INSTANCE.getString("_UI_ModelObject"));
            GridData object2 = new GridData();
            object2.horizontalAlignment = 4;
            gridLayout2.setLayoutData((Object)object2);
            this.initialObjectField = new Combo(composite2, 2048);
            GridData gridData3 = new GridData();
            gridData3.horizontalAlignment = 4;
            gridData3.grabExcessHorizontalSpace = true;
            this.initialObjectField.setLayoutData((Object)gridData3);
            for (String string : StandardModelWizard.this.getInitialObjectNames()) {
                this.initialObjectField.add(this.getLabel(string));
            }
            if (this.initialObjectField.getItemCount() == 1) {
                this.initialObjectField.select(0);
            }
            this.initialObjectField.addModifyListener(this.validator);
            Label label = new Label(composite2, 16384);
            label.setText(DiseasemodelsEditorPlugin.INSTANCE.getString("_UI_XMLEncoding"));
            GridData gridData4 = new GridData();
            gridData4.horizontalAlignment = 4;
            label.setLayoutData((Object)gridData4);
            this.encodingField = new Combo(composite2, 2048);
            GridData gridData5 = new GridData();
            gridData5.horizontalAlignment = 4;
            gridData5.grabExcessHorizontalSpace = true;
            this.encodingField.setLayoutData((Object)gridData5);
            for (String string : this.getEncodings()) {
                this.encodingField.add(string);
            }
            this.encodingField.select(0);
            this.encodingField.addModifyListener(this.validator);
            this.setPageComplete(this.validatePage());
            this.setControl((Control)composite2);
        }

        protected boolean validatePage() {
            URI uRI = this.getFileURI();
            if (uRI == null || uRI.isEmpty()) {
                this.setErrorMessage(null);
                return false;
            }
            String string = uRI.fileExtension();
            if (string == null || !FILE_EXTENSIONS.contains(string)) {
                String string2 = FILE_EXTENSIONS.size() > 1 ? "_WARN_FilenameExtensions" : "_WARN_FilenameExtension";
                this.setErrorMessage(DiseasemodelsEditorPlugin.INSTANCE.getString(string2, new Object[]{FORMATTED_FILE_EXTENSIONS}));
                return false;
            }
            this.setErrorMessage(null);
            return this.getInitialObjectName() != null && this.getEncodings().contains(this.encodingField.getText());
        }

        public void setVisible(boolean bl) {
            super.setVisible(bl);
            if (bl) {
                this.initialObjectField.clearSelection();
                this.encodingField.clearSelection();
                this.fileField.setFocus();
            }
        }

        public String getInitialObjectName() {
            String string = this.initialObjectField.getText();
            for (String string2 : StandardModelWizard.this.getInitialObjectNames()) {
                if (!this.getLabel(string2).equals(string)) continue;
                return string2;
            }
            return null;
        }

        public String getEncoding() {
            return this.encodingField.getText();
        }

        public URI getFileURI() {
            try {
                return URI.createFileURI((String)this.fileField.getText());
            }
            catch (Exception exception) {
                return null;
            }
        }

        public void selectFileField() {
            this.initialObjectField.clearSelection();
            this.encodingField.clearSelection();
            this.fileField.selectAll();
            this.fileField.setFocus();
        }

        protected String getLabel(String string) {
            try {
                return DiseasemodelsEditPlugin.INSTANCE.getString("_UI_" + string + "_type");
            }
            catch (MissingResourceException missingResourceException) {
                DiseasemodelsEditorPlugin.INSTANCE.log(missingResourceException);
                return string;
            }
        }

        protected Collection<String> getEncodings() {
            if (this.encodings == null) {
                this.encodings = new ArrayList<String>();
                StringTokenizer stringTokenizer = new StringTokenizer(DiseasemodelsEditorPlugin.INSTANCE.getString("_UI_XMLEncodingChoices"));
                while (stringTokenizer.hasMoreTokens()) {
                    this.encodings.add(stringTokenizer.nextToken());
                }
            }
            return this.encodings;
        }
    }
}

