/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.adapters.color;

import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.stem.core.graph.DynamicNodeLabel;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.ui.adapters.color.AbstractRelativeValueColorProviderAdapter;
import org.eclipse.stem.ui.adapters.color.AbstractRelativeValueColorProviderAdapterFactory;
import org.eclipse.stem.ui.preferences.VisualizationPreferencePage;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;

public class IntensityColorsLabelsMappingColorProviderAdapter
extends AbstractRelativeValueColorProviderAdapter
implements AbstractRelativeValueColorProviderAdapterFactory.PropertySelectionListener {
    private final Map<String, Color> colorMap = VisualizationPreferencePage.getColorMapping();
    private ItemPropertyDescriptor selectedProperty;

    public float getRelativeValue() {
        Node node = (Node)this.getTarget();
        for (NodeLabel nodeLabel : node.getLabels()) {
            DynamicNodeLabel dynamicNodeLabel;
            if (!(nodeLabel instanceof DynamicNodeLabel) || (dynamicNodeLabel = (DynamicNodeLabel)nodeLabel).getDecorator() != this.selectedDecorator) continue;
            this.setRVPTarget((Notifier)dynamicNodeLabel);
            return (float)this.rvp.getRelativeValue(this.selectedProperty);
        }
        return 0.0f;
    }

    public void updateGC(GC gC, float f, boolean bl) {
        String string = this.selectedProperty.getDisplayName(null);
        if (this.colorMap.containsKey(string)) {
            this.foregroundFillColor = this.colorMap.get(string);
        }
        float f2 = this.getRelativeValue();
        if ((double)(f2 *= f) > 1.0) {
            f2 = 1.0f;
        }
        if ((double)f2 < 0.0) {
            f2 = 0.0f;
        }
        if (f2 < 1.0E-9f) {
            gC.setAlpha(255);
            gC.setBackground(this.zero_FillColor);
        } else {
            if (bl) {
                f2 = this.performLogScaling(f2);
            }
            gC.setAlpha((int)(f2 * 255.0f));
            gC.setBackground(this.foregroundFillColor);
        }
    }

    private float performLogScaling(float f) {
        double d = f;
        if (d > 1.0) {
            d = 1.0;
        } else if ((double)f < 0.0) {
            d = 0.0;
        }
        double d2 = d * 99.0;
        double d3 = Math.log10(d2 += 1.0);
        return (float)(d3 /= 2.0);
    }

    public void propertySelected(ItemPropertyDescriptor itemPropertyDescriptor) {
        this.selectedProperty = itemPropertyDescriptor;
    }
}

