/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.adapters.diseasemodelpropertyeditor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.stem.diseasemodels.standard.DiseaseModel;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.ui.wizards.DiseaseWizardMessages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public abstract class DiseaseModelPropertyEditor
extends Composite {
    protected final Map<EStructuralFeature, Text> map = new HashMap<EStructuralFeature, Text>();
    protected String errorMessage;

    public static boolean isUserSpecifiedDiseaseModelProperty(EStructuralFeature eStructuralFeature) {
        boolean bl = false;
        EClass eClass = eStructuralFeature.getEContainingClass();
        if (eClass.equals(StandardPackage.eINSTANCE.getDiseaseModel()) || eClass.getEAllSuperTypes().contains((Object)StandardPackage.eINSTANCE.getDiseaseModel())) {
            if (eStructuralFeature.getName().equals("finiteDifference") || eStructuralFeature.getName().equals("relativeTolerance")) {
                return false;
            }
            bl = true;
        }
        return bl;
    }

    public DiseaseModelPropertyEditor(Composite composite, int n) {
        super(composite, n);
    }

    public void populate(DiseaseModel diseaseModel) {
        for (Map.Entry<EStructuralFeature, Text> entry : this.map.entrySet()) {
            switch (entry.getKey().getFeatureID()) {
                case 11: {
                    diseaseModel.setDiseaseName(entry.getValue().getText());
                    break;
                }
                case 9: {
                    diseaseModel.setPopulationIdentifier(entry.getValue().getText());
                    break;
                }
                case 10: {
                    diseaseModel.setTimePeriod(Long.parseLong(entry.getValue().getText()));
                    break;
                }
                case 8: {
                    diseaseModel.setBackgroundMortalityRate(Double.parseDouble(entry.getValue().getText()));
                    break;
                }
            }
        }
    }

    public boolean validate() {
        Text text;
        boolean bl = true;
        if (bl) {
            text = this.map.get(StandardPackage.Literals.DISEASE_MODEL__DISEASE_NAME);
            boolean bl2 = bl = !text.getText().equals("");
            if (!bl) {
                this.errorMessage = DiseaseWizardMessages.getString("NDizWizErr0");
            }
        }
        if (bl) {
            text = this.map.get(StandardPackage.Literals.DISEASE_MODEL__POPULATION_IDENTIFIER);
            boolean bl3 = bl = !text.getText().equals("");
            if (!bl) {
                this.errorMessage = DiseaseWizardMessages.getString("NDizWizErr1");
            }
        }
        if (bl) {
            text = this.map.get(StandardPackage.Literals.DISEASE_MODEL__TIME_PERIOD);
            boolean bl4 = bl = !text.getText().equals("");
            if (!bl) {
                this.errorMessage = DiseaseWizardMessages.getString("NDizWizErr2");
            } else {
                bl = this.isValidLongValue(text.getText(), 1);
                if (!bl) {
                    this.errorMessage = DiseaseWizardMessages.getString("NDizWizErr3");
                }
            }
        }
        return bl;
    }

    private boolean isValidLongValue(String string, int n) {
        boolean bl = true;
        try {
            double d = Long.parseLong(string);
            bl = d >= (double)n;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    protected boolean isValidPercentage(String string) {
        boolean bl = true;
        try {
            double d = Double.parseDouble(string);
            bl = d >= 0.0 && d <= 100.0;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    protected boolean isValidValue(String string, double d) {
        boolean bl = true;
        try {
            double d2 = Double.parseDouble(string);
            bl = d2 >= d;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    protected boolean isValidRelativeTolerance(String string, double d) {
        boolean bl = true;
        try {
            double d2 = Double.parseDouble(string);
            bl = d2 <= d && d2 > 0.0;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    protected String getPropertyDefaultValueString(IItemPropertyDescriptor iItemPropertyDescriptor) {
        String string = "";
        EStructuralFeature eStructuralFeature = (EStructuralFeature)iItemPropertyDescriptor.getFeature(null);
        switch (eStructuralFeature.getFeatureID()) {
            case 10: {
                eStructuralFeature.getDefaultValue();
                string = eStructuralFeature.getDefaultValueLiteral();
                break;
            }
            default: {
                string = eStructuralFeature.getDefaultValueLiteral();
                string = string == null ? "" : string;
            }
        }
        return string;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

