/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.wizards;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.stem.diseasemodels.standard.DiseaseModel;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.wizards.DiseaseModelPropertyComposite;
import org.eclipse.stem.ui.wizards.DiseaseWizardMessages;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DiseaseDefinitionControl
extends Composite {
    private static DiseaseModel[] diseaseModels = null;
    private Combo combo;
    private DiseaseModelPropertyComposite diseaseModelPropertyComposite;

    public DiseaseDefinitionControl(Composite composite, int n, ModifyListener modifyListener) {
        super(composite, n);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        Label label = new Label((Composite)this, 0);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.widthHint = 100;
        label.setLayoutData((Object)gridData);
        label.setText(DiseaseWizardMessages.getString("DDC.0"));
        this.combo = new Combo((Composite)this, 8);
        this.combo.setTextLimit(30);
        GridData gridData2 = new GridData(4, 0x1000000, true, false);
        gridData2.widthHint = 303;
        this.combo.setLayoutData((Object)gridData2);
        this.combo.setToolTipText(DiseaseWizardMessages.getString("DDC.1"));
        this.combo.setItems(this.getDiseaseModelNames(this.getDiseaseModels()));
        this.combo.select(0);
        this.combo.addModifyListener(modifyListener);
        this.diseaseModelPropertyComposite = new DiseaseModelPropertyComposite(this, 0, this.getDiseaseModels(), modifyListener);
        GridData gridData3 = new GridData(4, 0x1000000, true, false, 2, 1);
        this.diseaseModelPropertyComposite.setLayoutData(gridData3);
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DiseaseDefinitionControl.this.diseaseModelPropertyComposite.displayDiseaseModel(DiseaseDefinitionControl.this.getDiseaseModels()[DiseaseDefinitionControl.this.combo.getSelectionIndex()]);
            }
        });
    }

    private DiseaseModel[] getDiseaseModels() {
        if (diseaseModels == null) {
            IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
            IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor("org.eclipse.stem.diseasemodels.diseasemodel");
            ArrayList<DiseaseModel> arrayList = new ArrayList<DiseaseModel>();
            diseaseModels = new DiseaseModel[iConfigurationElementArray.length];
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
                if (iConfigurationElement.getName().equals("classdef")) {
                    try {
                        arrayList.add((DiseaseModel)iConfigurationElement.createExecutableExtension(DiseaseWizardMessages.getString("DDC.2")));
                    }
                    catch (CoreException coreException) {
                        Activator.logError((String)DiseaseWizardMessages.getString("DDC.3"), (Throwable)coreException);
                    }
                }
                ++n;
            }
            diseaseModels = arrayList.toArray(new DiseaseModel[0]);
        }
        return diseaseModels;
    }

    private String[] getDiseaseModelNames(DiseaseModel[] diseaseModelArray) {
        String[] stringArray = new String[diseaseModelArray.length];
        int n = 0;
        while (n < diseaseModelArray.length) {
            String string = diseaseModelArray[n].getDublinCore().getTitle();
            if (string == null || string.equals("")) {
                string = diseaseModelArray[n].getClass().getSimpleName();
            }
            stringArray[n] = string;
            ++n;
        }
        return stringArray;
    }

    DiseaseModel getSelectedDiseaseModel() {
        DiseaseModel diseaseModel = (DiseaseModel)EcoreUtil.copy((EObject)this.getDiseaseModels()[this.combo.getSelectionIndex()]);
        this.diseaseModelPropertyComposite.populateDiseaseModel(diseaseModel);
        return diseaseModel;
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public boolean validate() {
        return this.diseaseModelPropertyComposite.validate();
    }

    public String getErrorMessage() {
        return this.diseaseModelPropertyComposite.getErrorMessage();
    }
}

