/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.wizards;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.stem.data.geography.GeographicNames;
import org.eclipse.stem.ui.wizards.ISOKeyPickedEvent;
import org.eclipse.stem.ui.wizards.ISOKeyPickedEventListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredList;

public class ISOKeyPicker
extends Composite {
    private final List<ISOKeyPickedEventListener> listeners = new CopyOnWriteArrayList<ISOKeyPickedEventListener>();
    private final Label isoKeyLevelDescription;
    private final FilteredList filteredList;
    private final Text text;
    private int isoKeyLevel;

    public ISOKeyPicker(Composite composite, int n, final int n2) {
        super(composite, n);
        this.isoKeyLevel = n2;
        this.setLayout((Layout)new FormLayout());
        this.text = new Text((Composite)this, 2048);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(25, 0);
        formData.right = new FormAttachment(100, 0);
        this.text.setLayoutData((Object)formData);
        this.text.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                ISOKeyPicker.this.filteredList.setFilter(ISOKeyPicker.this.text.getText());
            }
        });
        this.isoKeyLevelDescription = new Label((Composite)this, 0);
        this.isoKeyLevelDescription.setText("Label");
        FormData formData2 = new FormData();
        formData2.top = new FormAttachment((Control)this.text, 2, 128);
        formData2.right = new FormAttachment(25, 0);
        formData2.left = new FormAttachment(0, 0);
        this.isoKeyLevelDescription.setLayoutData((Object)formData2);
        this.filteredList = new FilteredList((Composite)this, 2048, null, false, false, true);
        FormData formData3 = new FormData();
        formData3.top = new FormAttachment((Control)this.text, 5, -1);
        formData3.bottom = new FormAttachment(100, 0);
        formData3.left = new FormAttachment((Control)this.text, 0, 16384);
        formData3.right = new FormAttachment((Control)this.text, 0, 131072);
        this.filteredList.setLayoutData((Object)formData3);
        this.filteredList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Object[] objectArray = ISOKeyPicker.this.filteredList.getSelection();
                if (objectArray.length == 1) {
                    String string = (String)objectArray[0];
                    ISOKeyPicker.this.fireISOKeyPicked(string);
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }
        });
        this.filteredList.setIgnoreCase(true);
        this.filteredList.setFilter("");
        this.filteredList.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object object) {
                return ISOKeyPicker.this.getName((String)object, n2);
            }
        });
        this.filteredList.setElements(new Object[0]);
        this.pack();
    }

    public void setISOKeys(Object[] objectArray) {
        this.filteredList.setElements(objectArray);
        this.text.setText("");
    }

    public void setISOKeyLevelDescription(String string) {
        this.isoKeyLevelDescription.setText(string);
    }

    public int getISOKeyLevel() {
        return this.isoKeyLevel;
    }

    public void setISOKeyLevel(int n) {
        this.isoKeyLevel = n;
    }

    private String getName(String string, int n) {
        return GeographicNames.getName((String)string, (int)n);
    }

    public void addISOKeyPickedListener(ISOKeyPickedEventListener iSOKeyPickedEventListener) {
        this.listeners.add(iSOKeyPickedEventListener);
    }

    public void removeISOKeyPickedListener(ISOKeyPickedEventListener iSOKeyPickedEventListener) {
        this.listeners.remove(iSOKeyPickedEventListener);
    }

    private void fireISOKeyPicked(String string) {
        ISOKeyPickedEvent iSOKeyPickedEvent = new ISOKeyPickedEvent((Object)this, string);
        for (ISOKeyPickedEventListener iSOKeyPickedEventListener : this.listeners) {
            iSOKeyPickedEventListener.isoKeyPicked(iSOKeyPickedEvent);
        }
    }
}

