/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.wizards;

import org.eclipse.stem.data.geography.GeographicNames;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.wizards.DiseaseWizardMessages;
import org.eclipse.stem.ui.wizards.ISOKeyPickedEvent;
import org.eclipse.stem.ui.wizards.ISOKeyPickedEventListener;
import org.eclipse.stem.ui.wizards.ISOKeyPicker;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class InfectorDefinitionComposite
extends Composite {
    private final ISOKeyPicker isoKeyPicker2;
    private final ISOKeyPicker isoKeyPicker1;
    private final ISOKeyPicker isoKeyPicker0;
    private final ISOKeyPicker isoKeyPicker3;
    private String isoKey = "";
    private String tempISOKey = null;
    private final Text numberOfInfectionsText;
    private final Text populationText;
    private final Text diseaseNameText;
    private Label numberOfInfectionsLabel;
    private String errorMessage;
    private Button[] infectorModeRadioButtons = new Button[2];
    private boolean infectorMode = true;

    public InfectorDefinitionComposite(Composite composite, int n, ModifyListener modifyListener) {
        super(composite, n);
        this.setLayout((Layout)new FormLayout());
        Composite composite2 = this.createInfectorModeRadioButtonsComposite(this);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(5, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        composite2.setLayoutData((Object)formData);
        Label label = new Label((Composite)this, 0);
        FormData formData2 = new FormData();
        formData2.left = new FormAttachment(0, 0);
        formData2.right = new FormAttachment(35, 0);
        formData2.top = new FormAttachment((Control)composite2, 5, 1024);
        label.setLayoutData((Object)formData2);
        label.setText(DiseaseWizardMessages.getString("NInfWizDN"));
        this.diseaseNameText = new Text((Composite)this, 2048);
        this.diseaseNameText.setToolTipText(DiseaseWizardMessages.getString("NInfWizDNTT"));
        this.diseaseNameText.addModifyListener(modifyListener);
        FormData formData3 = new FormData();
        formData3.left = new FormAttachment((Control)label, 0);
        formData3.right = new FormAttachment(100, 0);
        formData3.top = new FormAttachment((Control)composite2, 5, 1024);
        this.diseaseNameText.setLayoutData((Object)formData3);
        Label label2 = new Label((Composite)this, 0);
        FormData formData4 = new FormData();
        formData4.left = new FormAttachment(0, 0);
        formData4.right = new FormAttachment(35, 0);
        formData4.top = new FormAttachment((Control)label, 5, 1024);
        label2.setLayoutData((Object)formData4);
        label2.setText(DiseaseWizardMessages.getString("NInfWizPOP"));
        this.populationText = new Text((Composite)this, 2048);
        this.populationText.setText(StandardPackage.Literals.DISEASE_MODEL__POPULATION_IDENTIFIER.getDefaultValueLiteral());
        this.populationText.setToolTipText(DiseaseWizardMessages.getString("NInfWizPOPTT"));
        this.populationText.addModifyListener(modifyListener);
        FormData formData5 = new FormData();
        formData5.top = new FormAttachment((Control)label, 5, 1024);
        formData5.left = new FormAttachment((Control)label2, 0);
        formData5.right = new FormAttachment(100, 0);
        this.populationText.setLayoutData((Object)formData5);
        this.numberOfInfectionsLabel = new Label((Composite)this, 0);
        this.numberOfInfectionsLabel.setText(DiseaseWizardMessages.getString("NInfWizNI"));
        FormData formData6 = new FormData();
        formData6.top = new FormAttachment((Control)label2, 5, 1024);
        formData6.left = new FormAttachment(0, 0);
        formData6.right = new FormAttachment(35, 0);
        this.numberOfInfectionsLabel.setLayoutData((Object)formData6);
        this.numberOfInfectionsText = new Text((Composite)this, 2048);
        this.numberOfInfectionsText.setText(StandardPackage.Literals.SI_INFECTOR__INFECTIOUS_COUNT.getDefaultValueLiteral());
        this.numberOfInfectionsText.setToolTipText(DiseaseWizardMessages.getString("NInfWizNITT"));
        this.numberOfInfectionsText.addModifyListener(modifyListener);
        FormData formData7 = new FormData();
        formData7.left = new FormAttachment((Control)this.numberOfInfectionsLabel, 0);
        formData7.right = new FormAttachment(100, 0);
        formData7.top = new FormAttachment((Control)label2, 5, 1024);
        this.numberOfInfectionsText.setLayoutData((Object)formData7);
        Label label3 = new Label((Composite)this, 0);
        label3.setText(DiseaseWizardMessages.getString("NInfWizISOK"));
        FormData formData8 = new FormData();
        formData8.top = new FormAttachment((Control)this.numberOfInfectionsLabel, 5, 1024);
        formData8.left = new FormAttachment(0, 0);
        formData8.right = new FormAttachment(25, 0);
        label3.setLayoutData((Object)formData8);
        final Label label4 = new Label((Composite)this, 0);
        label4.setText(this.isoKey);
        FormData formData9 = new FormData();
        formData9.top = new FormAttachment((Control)this.numberOfInfectionsLabel, 5, 1024);
        formData9.left = new FormAttachment((Control)label3, 0);
        formData9.right = new FormAttachment(100, 0);
        label4.setLayoutData((Object)formData9);
        this.isoKeyPicker0 = new ISOKeyPicker(this, 0, 0);
        this.isoKeyPicker0.setISOKeyLevel(0);
        this.isoKeyPicker0.setISOKeyLevelDescription(DiseaseWizardMessages.getString("NInfWizCNTRY"));
        this.isoKeyPicker0.addISOKeyPickedListener(new ISOKeyPickedEventListener(){

            public void isoKeyPicked(ISOKeyPickedEvent iSOKeyPickedEvent) {
                Object[] objectArray = GeographicNames.getSubISOKeys((String)GeographicNames.getAlpha2((String)iSOKeyPickedEvent.getIsoKey()), (int)InfectorDefinitionComposite.this.isoKeyPicker1.getISOKeyLevel());
                InfectorDefinitionComposite.this.isoKeyPicker1.setISOKeys(objectArray);
                InfectorDefinitionComposite.this.isoKeyPicker2.setISOKeys(new Object[0]);
                InfectorDefinitionComposite.this.isoKeyPicker3.setISOKeys(new Object[0]);
                InfectorDefinitionComposite.this.isoKey = iSOKeyPickedEvent.getIsoKey();
                InfectorDefinitionComposite.this.tempISOKey = InfectorDefinitionComposite.this.isoKey;
                label4.setText(InfectorDefinitionComposite.this.isoKey);
            }
        });
        this.isoKeyPicker1 = new ISOKeyPicker(this, 0, 1);
        this.isoKeyPicker1.setISOKeyLevelDescription(DiseaseWizardMessages.getString("NInfWizL1"));
        this.isoKeyPicker1.addISOKeyPickedListener(new ISOKeyPickedEventListener(){

            public void isoKeyPicked(ISOKeyPickedEvent iSOKeyPickedEvent) {
                Object[] objectArray = GeographicNames.getSubISOKeys((String)iSOKeyPickedEvent.getIsoKey(), (int)InfectorDefinitionComposite.this.isoKeyPicker2.getISOKeyLevel());
                InfectorDefinitionComposite.this.isoKeyPicker2.setISOKeys(objectArray);
                InfectorDefinitionComposite.this.isoKey = iSOKeyPickedEvent.getIsoKey();
                InfectorDefinitionComposite.this.tempISOKey = InfectorDefinitionComposite.this.tempISOKey == null ? InfectorDefinitionComposite.this.isoKey : InfectorDefinitionComposite.this.tempISOKey;
                if (objectArray.length == 0) {
                    InfectorDefinitionComposite.this.isoKey = InfectorDefinitionComposite.this.tempISOKey;
                    label4.setText(InfectorDefinitionComposite.this.isoKey);
                    InfectorDefinitionComposite.this.tempISOKey = null;
                }
            }
        });
        this.isoKeyPicker2 = new ISOKeyPicker(this, 0, 2);
        this.isoKeyPicker2.setISOKeyLevelDescription(DiseaseWizardMessages.getString("NInfWizL2"));
        this.isoKeyPicker2.addISOKeyPickedListener(new ISOKeyPickedEventListener(){

            public void isoKeyPicked(ISOKeyPickedEvent iSOKeyPickedEvent) {
                Object[] objectArray = GeographicNames.getSubISOKeys((String)iSOKeyPickedEvent.getIsoKey(), (int)InfectorDefinitionComposite.this.isoKeyPicker3.getISOKeyLevel());
                InfectorDefinitionComposite.this.isoKeyPicker3.setISOKeys(objectArray);
                InfectorDefinitionComposite.this.isoKey = iSOKeyPickedEvent.getIsoKey();
                InfectorDefinitionComposite.this.tempISOKey = InfectorDefinitionComposite.this.tempISOKey == null ? InfectorDefinitionComposite.this.isoKey : InfectorDefinitionComposite.this.tempISOKey;
                if (objectArray.length == 0) {
                    InfectorDefinitionComposite.this.isoKey = InfectorDefinitionComposite.this.tempISOKey;
                    label4.setText(InfectorDefinitionComposite.this.isoKey);
                    InfectorDefinitionComposite.this.tempISOKey = null;
                }
            }
        });
        this.isoKeyPicker3 = new ISOKeyPicker(this, 0, 3);
        this.isoKeyPicker3.setISOKeyLevelDescription(DiseaseWizardMessages.getString("NInfWizL3"));
        this.isoKeyPicker3.addISOKeyPickedListener(new ISOKeyPickedEventListener(){

            public void isoKeyPicked(ISOKeyPickedEvent iSOKeyPickedEvent) {
                InfectorDefinitionComposite.this.isoKey = InfectorDefinitionComposite.this.tempISOKey == null ? iSOKeyPickedEvent.getIsoKey() : InfectorDefinitionComposite.this.tempISOKey;
                label4.setText(InfectorDefinitionComposite.this.isoKey);
                InfectorDefinitionComposite.this.tempISOKey = null;
            }
        });
        FormData formData10 = new FormData();
        formData10.top = new FormAttachment((Control)label3, 5, 1024);
        formData10.right = new FormAttachment(100, 0);
        formData10.left = new FormAttachment(0, 0);
        this.isoKeyPicker0.setLayoutData(formData10);
        this.isoKeyPicker0.setISOKeys(GeographicNames.getSubISOKeys((String)"ZZZ", (int)-1));
        FormData formData11 = new FormData();
        formData11.top = new FormAttachment((Control)this.isoKeyPicker0, 5, 1024);
        formData11.left = new FormAttachment((Control)this.isoKeyPicker0, 0, 16384);
        formData11.right = new FormAttachment((Control)this.isoKeyPicker0, 0, 131072);
        this.isoKeyPicker1.setLayoutData(formData11);
        FormData formData12 = new FormData();
        formData12.top = new FormAttachment((Control)this.isoKeyPicker1, 5, 1024);
        formData12.left = new FormAttachment((Control)this.isoKeyPicker0, 0, 16384);
        formData12.right = new FormAttachment((Control)this.isoKeyPicker0, 0, 131072);
        this.isoKeyPicker2.setLayoutData(formData12);
        FormData formData13 = new FormData();
        formData13.top = new FormAttachment((Control)this.isoKeyPicker2, 5, 1024);
        formData13.left = new FormAttachment((Control)this.isoKeyPicker0, 0, 16384);
        formData13.right = new FormAttachment((Control)this.isoKeyPicker0, 0, 131072);
        this.isoKeyPicker3.setLayoutData(formData13);
    }

    Composite createInfectorModeRadioButtonsComposite(Composite composite) {
        Composite composite2 = new Composite(composite, 2048);
        FillLayout fillLayout = new FillLayout();
        fillLayout.type = 512;
        composite2.setLayout((Layout)fillLayout);
        this.infectorModeRadioButtons[0] = new Button(composite2, 16);
        this.infectorModeRadioButtons[0].setSelection(true);
        this.infectorModeRadioButtons[0].setText(DiseaseWizardMessages.getString("NInfectorWiz.infect"));
        this.infectorModeRadioButtons[1] = new Button(composite2, 16);
        this.infectorModeRadioButtons[1].setText(DiseaseWizardMessages.getString("NInfectorWiz.inoculate"));
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (event.widget == InfectorDefinitionComposite.this.infectorModeRadioButtons[0]) {
                    InfectorDefinitionComposite.this.infectorMode = InfectorDefinitionComposite.this.infectorModeRadioButtons[0].getSelection();
                }
                if (InfectorDefinitionComposite.this.infectorMode) {
                    InfectorDefinitionComposite.this.numberOfInfectionsLabel.setText(DiseaseWizardMessages.getString("NInfWizNI"));
                } else {
                    InfectorDefinitionComposite.this.numberOfInfectionsLabel.setText(DiseaseWizardMessages.getString("NInfWizPI"));
                }
                InfectorDefinitionComposite.this.numberOfInfectionsText.setText("");
            }
        };
        this.infectorModeRadioButtons[0].addListener(13, listener);
        return composite2;
    }

    public boolean validate() {
        boolean bl = true;
        if (this.getDiseaseName() == null || this.getDiseaseName().equals("")) {
            this.errorMessage = DiseaseWizardMessages.getString("NInfWizError.1");
            bl = false;
        }
        if (bl && (this.getPopulation() == null || this.getPopulation().equals(""))) {
            this.errorMessage = DiseaseWizardMessages.getString("NInfWizError.2");
            bl = false;
        }
        if (bl) {
            if (this.numberOfInfectionsText.getText() == null || this.numberOfInfectionsText.getText().equals("")) {
                this.errorMessage = DiseaseWizardMessages.getString("NInfWizError.3");
                bl = false;
            } else {
                try {
                    double d = Double.parseDouble(this.numberOfInfectionsText.getText());
                    if (d <= 0.0) {
                        this.errorMessage = DiseaseWizardMessages.getString("NInfWizError.4");
                        bl = false;
                    }
                    if (!this.isInfectorMode() && d > 100.0) {
                        this.errorMessage = DiseaseWizardMessages.getString("NInfWizError.8");
                        bl = false;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.errorMessage = DiseaseWizardMessages.getString("NInfWizError.5");
                    bl = false;
                }
            }
        }
        if (bl && (this.getIsoKey() == null || this.getIsoKey().equals(""))) {
            this.errorMessage = DiseaseWizardMessages.getString("NInfWizError.6");
            bl = false;
        }
        return bl;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean isInfectorMode() {
        return this.infectorMode;
    }

    public final String getIsoKey() {
        return this.isoKey;
    }

    public final String getLocationName() {
        return this.getIsoKey();
    }

    public final String getDiseaseName() {
        return this.diseaseNameText.getText();
    }

    public final String getPopulation() {
        return this.populationText.getText();
    }

    public double getNumberOfInfections() {
        try {
            return Double.parseDouble(this.numberOfInfectionsText.getText());
        }
        catch (NumberFormatException numberFormatException) {
            Activator.logError((String)DiseaseWizardMessages.getString("NInfWizError.7"), (Throwable)numberFormatException);
            return 0.0;
        }
    }

    public double getPercentToInoculate() {
        try {
            return Double.parseDouble(this.numberOfInfectionsText.getText());
        }
        catch (NumberFormatException numberFormatException) {
            Activator.logError((String)DiseaseWizardMessages.getString("NInfWizError.7"), (Throwable)numberFormatException);
            return 0.0;
        }
    }
}

