/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.wizards;

import java.text.MessageFormat;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.diseasemodels.standard.DiseaseModel;
import org.eclipse.stem.ui.wizards.DiseaseDefinitionControl;
import org.eclipse.stem.ui.wizards.DiseaseWizardMessages;
import org.eclipse.stem.ui.wizards.DublinCorePage;
import org.eclipse.stem.ui.wizards.NewIdentifiablePage;
import org.eclipse.stem.ui.wizards.NewIdentifiableWizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class NewDiseaseWizard
extends NewIdentifiableWizard {
    private NewDiseasePage ndp = null;

    protected String getWizardTitle() {
        return DiseaseWizardMessages.getString("NDiseaseWiz.wizard_title");
    }

    protected NewIdentifiablePage createNewIdentifiablePage() {
        this.ndp = new NewDiseasePage(DiseaseWizardMessages.getString("NDiseaseWiz.page_title"));
        this.ndp.setTitle(DiseaseWizardMessages.getString("NDiseaseWiz.page_title"));
        this.ndp.setDescription(DiseaseWizardMessages.getString("NDiseaseWiz.page_description"));
        return this.ndp;
    }

    protected DublinCorePage createDublinCorePage() {
        return new DublinCorePage(){

            protected void initializeDCAttributes() {
                super.initializeDCAttributes();
                this.format.setText("http:///org/eclipse/stem/diseasemodels/standard.ecore");
                this.format.setEnabled(false);
                this.type.setText(STEMURI.createTypeURI((String)"diseasemodel").toString());
                this.type.setEnabled(false);
            }
        };
    }

    protected Identifiable createIdentifiable() {
        DiseaseModel diseaseModel = this.ndp.getSelectedDiseaseModel();
        diseaseModel.setDublinCore(this.newDublinCorePage.createDublinCore());
        return diseaseModel;
    }

    protected String getSerializationFolderName() {
        return "decorators";
    }

    protected String getSerializationFileNameExtension() {
        return "standard";
    }

    protected static class NewDiseasePage
    extends NewIdentifiablePage {
        DiseaseDefinitionControl ddc = null;

        protected NewDiseasePage(String string) {
            super(string);
        }

        protected String getDCDescription() {
            return MessageFormat.format(DiseaseWizardMessages.getString("NDiseaseWiz.DC_DESCRIPTION"), this.serializationFileNameField.getText());
        }

        protected Composite createSpecificComposite(Composite composite) {
            this.ddc = new DiseaseDefinitionControl(composite, 0, this.projectValidator);
            return this.ddc;
        }

        protected boolean validatePage() {
            boolean bl = super.validatePage();
            if (bl) {
                this.setErrorMessage(null);
                bl = this.ddc.validate();
                if (!bl) {
                    this.setErrorMessage(this.ddc.getErrorMessage());
                }
            }
            return bl;
        }

        DiseaseModel getSelectedDiseaseModel() {
            return this.ddc.getSelectedDiseaseModel();
        }
    }

    public static class NewDiseaseWizardCommandHandler
    extends AbstractHandler
    implements IHandler {
        public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
            IWorkbenchWindow iWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)executionEvent);
            NewDiseaseWizard newDiseaseWizard = new NewDiseaseWizard();
            newDiseaseWizard.init(iWorkbenchWindow.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
            WizardDialog wizardDialog = new WizardDialog(iWorkbenchWindow.getShell(), (IWizard)newDiseaseWizard);
            wizardDialog.open();
            return null;
        }
    }
}

