/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.wizards;

import java.text.MessageFormat;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.data.geography.GeographicNames;
import org.eclipse.stem.diseasemodels.standard.Infector;
import org.eclipse.stem.diseasemodels.standard.StandardFactory;
import org.eclipse.stem.diseasemodels.standard.impl.SIRInoculatorImpl;
import org.eclipse.stem.ui.wizards.DiseaseWizardMessages;
import org.eclipse.stem.ui.wizards.DublinCorePage;
import org.eclipse.stem.ui.wizards.InfectorDefinitionComposite;
import org.eclipse.stem.ui.wizards.NewIdentifiablePage;
import org.eclipse.stem.ui.wizards.NewIdentifiableWizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class NewInfectorWizard
extends NewIdentifiableWizard {
    private NewInfectorPage nip = null;

    protected String getWizardTitle() {
        return DiseaseWizardMessages.getString("NInfectorWiz.wizard_title");
    }

    protected NewIdentifiablePage createNewIdentifiablePage() {
        this.nip = new NewInfectorPage(DiseaseWizardMessages.getString("NInfectorWiz.page_title"));
        this.nip.setTitle(DiseaseWizardMessages.getString("NInfectorWiz.page_title"));
        this.nip.setDescription(DiseaseWizardMessages.getString("NInfectorWiz.page_description"));
        return this.nip;
    }

    protected DublinCorePage createDublinCorePage() {
        return new DublinCorePage(){

            protected void initializeDCAttributes() {
                super.initializeDCAttributes();
                this.format.setText("http:///org/eclipse/stem/diseasemodels/standard.ecore");
                this.format.setEnabled(false);
                this.type.setEnabled(false);
            }
        };
    }

    protected Identifiable createIdentifiable() {
        Infector infector = this.nip.getInfector();
        infector.setDublinCore(this.newDublinCorePage.createDublinCore());
        return infector;
    }

    protected String getSerializationFolderName() {
        return "decorators";
    }

    protected String getSerializationFileNameExtension() {
        return "standard";
    }

    protected static class NewInfectorPage
    extends NewIdentifiablePage {
        private InfectorDefinitionComposite idc;

        protected NewInfectorPage(String string) {
            super(string);
        }

        public Infector getInfector() {
            Object object = null;
            object = this.idc.isInfectorMode() ? StandardFactory.eINSTANCE.createSIInfector() : StandardFactory.eINSTANCE.createSIRInoculator();
            object.setDiseaseName(this.idc.getDiseaseName());
            object.setPopulationIdentifier(this.idc.getPopulation());
            object.setTargetISOKey(this.idc.getIsoKey());
            if (this.idc.isInfectorMode()) {
                object.setInfectiousCount(this.idc.getNumberOfInfections());
            } else {
                ((SIRInoculatorImpl)object).setInoculatedPercentage(this.idc.getPercentToInoculate());
                object.setInfectiousCount(0.0);
            }
            return object;
        }

        protected String getDCDescription() {
            if (this.idc.isInfectorMode()) {
                return MessageFormat.format(DiseaseWizardMessages.getString("NInfectorWiz.DC_DESCRIPTION"), this.idc.getNumberOfInfections(), this.idc.getPopulation(), this.idc.getDiseaseName(), GeographicNames.getReverseHierarchyName((String)this.idc.getIsoKey()), this.idc.getIsoKey());
            }
            return MessageFormat.format(DiseaseWizardMessages.getString("NInfectorWiz.DC_DESCRIPTION2"), this.idc.getPercentToInoculate(), this.idc.getPopulation(), this.idc.getDiseaseName(), GeographicNames.getReverseHierarchyName((String)this.idc.getIsoKey()), this.idc.getIsoKey());
        }

        protected Composite createSpecificComposite(Composite composite) {
            this.idc = new InfectorDefinitionComposite(composite, 0, this.projectValidator);
            return this.idc;
        }

        protected boolean validatePage() {
            boolean bl = super.validatePage();
            if (bl) {
                this.setErrorMessage(null);
                bl = this.idc.validate();
                if (!bl) {
                    this.setErrorMessage(this.idc.getErrorMessage());
                }
            }
            return bl;
        }
    }

    public static class NewInfectorWizardCommandHandler
    extends AbstractHandler
    implements IHandler {
        public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
            IWorkbenchWindow iWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)executionEvent);
            NewInfectorWizard newInfectorWizard = new NewInfectorWizard();
            newInfectorWizard.init(iWorkbenchWindow.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
            WizardDialog wizardDialog = new WizardDialog(iWorkbenchWindow.getShell(), (IWizard)newInfectorWizard);
            wizardDialog.open();
            return null;
        }
    }
}

