/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.wizards;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.stem.diseasemodels.standard.DiseaseModel;
import org.eclipse.stem.diseasemodels.standard.SEIR;
import org.eclipse.stem.diseasemodels.standard.SI;
import org.eclipse.stem.diseasemodels.standard.SIR;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModel;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.diseasemodels.standard.StandardStochasticDiseaseModel;
import org.eclipse.stem.diseasemodels.standard.StochasticDiseaseModel;
import org.eclipse.stem.ui.adapters.diseasemodelpropertyeditor.DiseaseModelPropertyEditor;
import org.eclipse.stem.ui.adapters.propertystrings.PropertyStringProvider;
import org.eclipse.stem.ui.adapters.propertystrings.PropertyStringProviderAdapter;
import org.eclipse.stem.ui.adapters.propertystrings.PropertyStringProviderAdapterFactory;
import org.eclipse.stem.ui.wizards.DiseaseWizardMessages;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class StandardDiseaseModelPropertyEditor
extends DiseaseModelPropertyEditor {
    public StandardDiseaseModelPropertyEditor(Composite composite, int n, DiseaseModel diseaseModel, ModifyListener modifyListener) {
        super(composite, n);
        IItemPropertyDescriptor iItemPropertyDescriptor2;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.setLayout((Layout)gridLayout);
        PropertyStringProviderAdapter propertyStringProviderAdapter = (PropertyStringProviderAdapter)PropertyStringProviderAdapterFactory.INSTANCE.adapt((Notifier)diseaseModel, PropertyStringProvider.class);
        ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        IItemPropertySource iItemPropertySource = (IItemPropertySource)composedAdapterFactory.adapt((Notifier)diseaseModel, IItemPropertySource.class);
        List list = iItemPropertySource.getPropertyDescriptors((Object)diseaseModel);
        for (IItemPropertyDescriptor iItemPropertyDescriptor2 : list) {
            RowLayout rowLayout;
            Composite composite2;
            EStructuralFeature eStructuralFeature = (EStructuralFeature)iItemPropertyDescriptor2.getFeature(null);
            if (!StandardDiseaseModelPropertyEditor.isUserSpecifiedDiseaseModelProperty(eStructuralFeature)) continue;
            Label label = new Label((Composite)this, 0);
            label.setText(propertyStringProviderAdapter.getPropertyName(iItemPropertyDescriptor2));
            GridData gridData = new GridData(1);
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalAlignment = 4;
            gridData.horizontalIndent = 0;
            label.setLayoutData((Object)gridData);
            String string = this.getPropertyDefaultValueString(iItemPropertyDescriptor2);
            final Text text = new Text((Composite)this, 133120);
            text.setText(string);
            text.setToolTipText(propertyStringProviderAdapter.getPropertyToolTip(iItemPropertyDescriptor2));
            this.map.put(eStructuralFeature, text);
            GridData gridData2 = new GridData(3);
            gridData2.grabExcessHorizontalSpace = true;
            gridData2.horizontalAlignment = 4;
            text.setLayoutData((Object)gridData2);
            text.addModifyListener(modifyListener);
            boolean bl = false;
            if (eStructuralFeature.getName().equals("dataPath")) {
                bl = true;
                composite2 = new Composite((Composite)this, 0);
                rowLayout = new RowLayout();
                rowLayout.marginTop = 0;
                rowLayout.marginBottom = 0;
                composite2.setLayout((Layout)rowLayout);
                final Shell shell = this.getShell();
                Button button = new Button(composite2, 0);
                button.setText(DiseaseWizardMessages.getString("fileChooserButtonText"));
                button.setToolTipText(DiseaseWizardMessages.getString("fileChooserButtonTooltipText"));
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        FileDialog fileDialog = new FileDialog(shell, 4098);
                        fileDialog.setText(DiseaseWizardMessages.getString("fileChooserDialogTitle"));
                        String[] stringArray = new String[]{"*.txt", "*.csv"};
                        fileDialog.setFilterExtensions(stringArray);
                        String string = "\"" + fileDialog.open() + "\"";
                        String[] stringArray2 = fileDialog.getFileNames();
                        if (stringArray2.length > 1) {
                            int n = 1;
                            while (n < stringArray2.length) {
                                string = String.valueOf(string) + " \"" + stringArray2[n] + "\"";
                                ++n;
                            }
                        }
                        text.setText(string);
                    }
                });
                Button button2 = new Button(composite2, 0);
                button2.setText(DiseaseWizardMessages.getString("dirChooserButtonText"));
                button2.setToolTipText(DiseaseWizardMessages.getString("dirChooserButtonTooltipText"));
                button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        DirectoryDialog directoryDialog = new DirectoryDialog(shell, 4096);
                        directoryDialog.setText(DiseaseWizardMessages.getString("dirChooserDialogTitle"));
                        String string = directoryDialog.open();
                        text.setText(string);
                    }
                });
                GridData gridData3 = new GridData(3);
                composite2.setLayoutData((Object)gridData3);
            }
            if (bl) continue;
            composite2 = new Label((Composite)this, 0);
            composite2.setText(propertyStringProviderAdapter.getPropertyUnits(iItemPropertyDescriptor2));
            rowLayout = new GridData(3);
            rowLayout.verticalAlignment = 2;
            composite2.setLayoutData((Object)rowLayout);
        }
        iItemPropertyDescriptor2 = new Label((Composite)this, 0);
        iItemPropertyDescriptor2.setText(DiseaseWizardMessages.getString("PMTP_Def"));
        GridData gridData = new GridData(3);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        iItemPropertyDescriptor2.setLayoutData((Object)gridData);
    }

    public void populate(DiseaseModel diseaseModel) {
        super.populate(diseaseModel);
        for (Map.Entry entry : this.map.entrySet()) {
            switch (((EStructuralFeature)entry.getKey()).getFeatureID()) {
                case 19: {
                    ((StandardDiseaseModel)diseaseModel).setReferencePopulationDensity(Double.parseDouble(((Text)entry.getValue()).getText()));
                    break;
                }
                case 16: {
                    ((StochasticDiseaseModel)diseaseModel).setSeed(Long.parseLong(((Text)entry.getValue()).getText()));
                    break;
                }
                case 18: {
                    ((StandardStochasticDiseaseModel)diseaseModel).setGain(Double.parseDouble(((Text)entry.getValue()).getText()));
                    break;
                }
                case 20: {
                    ((SI)diseaseModel).setTransmissionRate(Double.parseDouble(((Text)entry.getValue()).getText()));
                    break;
                }
                case 21: {
                    ((SI)diseaseModel).setNonLinearityCoefficient(Double.parseDouble(((Text)entry.getValue()).getText()));
                    break;
                }
                case 22: {
                    ((SI)diseaseModel).setRecoveryRate(Double.parseDouble(((Text)entry.getValue()).getText()));
                    break;
                }
                case 23: {
                    ((SI)diseaseModel).setInfectiousMortalityRate(Double.parseDouble(((Text)entry.getValue()).getText()));
                    break;
                }
                case 24: {
                    ((SI)diseaseModel).setPhysicallyAdjacentInfectiousProportion(Double.parseDouble(((Text)entry.getValue()).getText()));
                    break;
                }
                case 25: {
                    ((SI)diseaseModel).setRoadNetworkInfectiousProportion(Double.parseDouble(((Text)entry.getValue()).getText()));
                    break;
                }
                case 27: {
                    ((SIR)diseaseModel).setImmunityLossRate(Double.parseDouble(((Text)entry.getValue()).getText()));
                    break;
                }
                case 28: {
                    ((SEIR)diseaseModel).setIncubationRate(Double.parseDouble(((Text)entry.getValue()).getText()));
                    break;
                }
            }
        }
    }

    public boolean validate() {
        Text text;
        boolean bl = super.validate();
        if (bl && (text = (Text)this.map.get(StandardPackage.Literals.SI__TRANSMISSION_RATE)) != null) {
            boolean bl2 = bl = !text.getText().equals("");
            if (!bl) {
                this.errorMessage = DiseaseWizardMessages.getString("NDizWizErr6");
            } else {
                bl = this.isValidValue(text.getText(), 0.0);
                if (!bl) {
                    this.errorMessage = DiseaseWizardMessages.getString("NDizWizErr7");
                }
            }
        }
        if (bl && (text = (Text)this.map.get(StandardPackage.Literals.SI__NON_LINEARITY_COEFFICIENT)) != null) {
            boolean bl3 = bl = !text.getText().equals("");
            if (!bl) {
                this.errorMessage = DiseaseWizardMessages.getString("NDizWizErr8");
            } else {
                bl = this.isValidValue(text.getText(), 1.0);
                if (!bl) {
                    this.errorMessage = DiseaseWizardMessages.getString("NDizWizErr9");
                }
            }
        }
        if (bl && (text = (Text)this.map.get(StandardPackage.Literals.SI__RECOVERY_RATE)) != null) {
            boolean bl4 = bl = !text.getText().equals("");
            if (!bl) {
                this.errorMessage = DiseaseWizardMessages.getString("NDizWizErr10");
            } else {
                bl = this.isValidValue(text.getText(), 0.0);
                if (!bl) {
                    this.errorMessage = DiseaseWizardMessages.getString("NDizWizErr11");
                }
            }
        }
        if (bl && (text = (Text)this.map.get(StandardPackage.Literals.SI__INFECTIOUS_MORTALITY_RATE)) != null) {
            boolean bl5 = bl = !text.getText().equals("");
            if (!bl) {
                this.errorMessage = DiseaseWizardMessages.getString("NDizWizErr12");
            } else {
                bl = this.isValidValue(text.getText(), 0.0);
                if (!bl) {
                    this.errorMessage = DiseaseWizardMessages.getString("NDizWizErr13");
                }
            }
        }
        if (bl && (text = (Text)this.map.get(StandardPackage.Literals.SIR__IMMUNITY_LOSS_RATE)) != null) {
            boolean bl6 = bl = !text.getText().equals("");
            if (!bl) {
                this.errorMessage = DiseaseWizardMessages.getString("NDizWizErr16");
            } else {
                bl = this.isValidValue(text.getText(), 0.0);
                if (!bl) {
                    this.errorMessage = DiseaseWizardMessages.getString("NDizWizErr17");
                }
            }
        }
        if (bl && (text = (Text)this.map.get(StandardPackage.Literals.SEIR__INCUBATION_RATE)) != null) {
            boolean bl7 = bl = !text.getText().equals("");
            if (!bl) {
                this.errorMessage = DiseaseWizardMessages.getString("NDizWizErr18");
            } else {
                bl = this.isValidValue(text.getText(), 0.0);
                if (!bl) {
                    this.errorMessage = DiseaseWizardMessages.getString("NDizWizErr19");
                }
            }
        }
        return bl;
    }
}

