/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.diseasemodels.example.presentation;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.stem.diseasemodels.example.ExampleDiseaseModel;
import org.eclipse.stem.diseasemodels.example.ExamplePackage;
import org.eclipse.stem.diseasemodels.standard.DiseaseModel;
import org.eclipse.stem.ui.adapters.diseasemodelpropertyeditor.DiseaseModelPropertyEditor;
import org.eclipse.stem.ui.adapters.propertystrings.PropertyStringProvider;
import org.eclipse.stem.ui.adapters.propertystrings.PropertyStringProviderAdapter;
import org.eclipse.stem.ui.adapters.propertystrings.PropertyStringProviderAdapterFactory;
import org.eclipse.stem.ui.wizards.DiseaseWizardMessages;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExampleDiseaseModelPropertyEditor
extends DiseaseModelPropertyEditor {
    public ExampleDiseaseModelPropertyEditor(Composite composite, int n, DiseaseModel diseaseModel, ModifyListener modifyListener) {
        super(composite, n);
        IItemPropertyDescriptor iItemPropertyDescriptor2;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.setLayout((Layout)gridLayout);
        PropertyStringProviderAdapter propertyStringProviderAdapter = (PropertyStringProviderAdapter)PropertyStringProviderAdapterFactory.INSTANCE.adapt((Notifier)diseaseModel, PropertyStringProvider.class);
        ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        IItemPropertySource iItemPropertySource = (IItemPropertySource)composedAdapterFactory.adapt((Notifier)diseaseModel, IItemPropertySource.class);
        List list = iItemPropertySource.getPropertyDescriptors((Object)diseaseModel);
        for (IItemPropertyDescriptor iItemPropertyDescriptor2 : list) {
            RowLayout rowLayout;
            Composite composite2;
            EStructuralFeature eStructuralFeature = (EStructuralFeature)iItemPropertyDescriptor2.getFeature(null);
            if (!ExampleDiseaseModelPropertyEditor.isUserSpecifiedDiseaseModelProperty((EStructuralFeature)eStructuralFeature)) continue;
            Label label = new Label((Composite)this, 0);
            label.setText(propertyStringProviderAdapter.getPropertyName(iItemPropertyDescriptor2));
            GridData gridData = new GridData(1);
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalAlignment = 4;
            gridData.horizontalIndent = 0;
            label.setLayoutData((Object)gridData);
            String string = this.getPropertyDefaultValueString(iItemPropertyDescriptor2);
            final Text text = new Text((Composite)this, 133120);
            text.setText(string);
            text.setToolTipText(propertyStringProviderAdapter.getPropertyToolTip(iItemPropertyDescriptor2));
            this.map.put(eStructuralFeature, text);
            GridData gridData2 = new GridData(3);
            gridData2.grabExcessHorizontalSpace = true;
            gridData2.horizontalAlignment = 4;
            text.setLayoutData((Object)gridData2);
            text.addModifyListener(modifyListener);
            boolean bl = false;
            if (eStructuralFeature.getName().equals("dataPath")) {
                bl = true;
                composite2 = new Composite((Composite)this, 0);
                rowLayout = new RowLayout();
                rowLayout.marginTop = 0;
                rowLayout.marginBottom = 0;
                composite2.setLayout((Layout)rowLayout);
                final Shell shell = this.getShell();
                Button button = new Button(composite2, 0);
                button.setText(DiseaseWizardMessages.getString((String)"dirChooserButtonText"));
                button.setToolTipText(DiseaseWizardMessages.getString((String)"dirChooserButtonTooltipText"));
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        DirectoryDialog directoryDialog = new DirectoryDialog(shell, 4096);
                        directoryDialog.setText(DiseaseWizardMessages.getString((String)"dirChooserDialogTitle"));
                        String string = directoryDialog.open();
                        text.setText(string);
                    }
                });
                GridData gridData3 = new GridData(3);
                composite2.setLayoutData((Object)gridData3);
            }
            if (bl) continue;
            composite2 = new Label((Composite)this, 0);
            composite2.setText(propertyStringProviderAdapter.getPropertyUnits(iItemPropertyDescriptor2));
            rowLayout = new GridData(3);
            rowLayout.verticalAlignment = 2;
            composite2.setLayoutData((Object)rowLayout);
        }
        iItemPropertyDescriptor2 = new Label((Composite)this, 0);
        iItemPropertyDescriptor2.setText(DiseaseWizardMessages.getString((String)"PMTP_Def"));
        GridData gridData = new GridData(3);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        iItemPropertyDescriptor2.setLayoutData((Object)gridData);
    }

    public void populate(DiseaseModel diseaseModel) {
        super.populate(diseaseModel);
        for (Map.Entry entry : this.map.entrySet()) {
            double d = 0.0;
            switch (((EStructuralFeature)entry.getKey()).getFeatureID()) {
                case 34: {
                    d = new Double(((Text)entry.getValue()).getText());
                    ((ExampleDiseaseModel)diseaseModel).setSeasonalModulationFloor(d);
                    break;
                }
                case 31: {
                    d = new Double(((Text)entry.getValue()).getText());
                    ((ExampleDiseaseModel)diseaseModel).setSeasonalModulationExponent(d);
                    break;
                }
                case 32: {
                    d = new Double(((Text)entry.getValue()).getText());
                    ((ExampleDiseaseModel)diseaseModel).setModulationPeriod(d);
                    break;
                }
                case 33: {
                    d = new Double(((Text)entry.getValue()).getText());
                    ((ExampleDiseaseModel)diseaseModel).setModulationPhaseShift(d);
                    break;
                }
            }
        }
    }

    public boolean validate() {
        boolean bl = super.validate();
        if (bl) {
            Text text = (Text)this.map.get(ExamplePackage.Literals.EXAMPLE_DISEASE_MODEL__MODULATION_PERIOD);
            String string = text.getText();
            try {
                new Double(string);
            }
            catch (Exception exception) {
                bl = false;
                this.errorMessage = DiseaseWizardMessages.getString((String)"NDizWizErr20");
            }
        }
        return bl;
    }
}

