/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.jobs.batch;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.stem.core.experiment.Experiment;
import org.eclipse.stem.jobs.Activator;
import org.eclipse.stem.jobs.batch.BatchEvent;
import org.eclipse.stem.jobs.batch.BatchState;
import org.eclipse.stem.jobs.batch.IBatch;
import org.eclipse.stem.jobs.batch.IBatchListener;
import org.eclipse.stem.jobs.batch.IBatchListenerSync;
import org.eclipse.stem.jobs.batch.Messages;
import org.eclipse.stem.jobs.execution.Executable;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.ISimulationListener;
import org.eclipse.stem.jobs.simulation.SimulationEvent;
import org.eclipse.stem.jobs.simulation.SimulationManager;
import org.eclipse.stem.jobs.simulation.SimulationState;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class Batch
extends Executable
implements IBatch,
ISimulationListener {
    private BatchState batchState = BatchState.PAUSED;
    private Experiment experiment = null;
    private final List<ISimulation> activeSimulations = new ArrayList<ISimulation>();
    private boolean runningSimulationsSequentially = true;
    private boolean runningInBackground = false;
    private boolean keepRunning = true;
    private final List<IBatchListener> listeners = new CopyOnWriteArrayList<IBatchListener>();
    private final List<IBatchListenerSync> listenersSync = new CopyOnWriteArrayList<IBatchListenerSync>();
    private IProgressMonitor monitor;
    private boolean cancelRequested;

    Batch(Experiment experiment, int n) {
        super("Batch: " + n, n);
        this.experiment = experiment;
    }

    protected IStatus run(IProgressMonitor iProgressMonitor) {
        IStatus iStatus = Status.OK_STATUS;
        this.monitor = iProgressMonitor;
        try {
            this.setBatchState(BatchState.RUNNING);
            iProgressMonitor.beginTask("Batch: " + this.getSequenceNumber(), this.getTotalWork());
            this.getExperiment().initScenario();
            ISimulation iSimulation = this.getNextSimulationToRun();
            while (this.keepRunning && iSimulation != null) {
                this.setBatchState(BatchState.RUNNING);
                this.startSimulationRunning(iSimulation);
                if (!this.isRunningSimulationsSequentially()) {
                    if (iProgressMonitor.isCanceled()) {
                        this.cancelRequested = true;
                        this.stopAllSimulations();
                        iStatus = Status.CANCEL_STATUS;
                    }
                    iSimulation = this.getNextSimulationToRun();
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            this.handleException(exception);
            this.keepRunning = false;
            if (this.activeSimulations.size() > 0) {
                this.cancelRequested = true;
                this.stopAllSimulations();
            }
            iProgressMonitor.done();
            this.setBatchState(BatchState.STOPPED);
        }
        return iStatus;
    }

    private void handleException(Exception exception) {
        String string = "";
        boolean bl = false;
        if (exception instanceof NullPointerException) {
            if (this.experiment.getScenario() == null) {
                string = MessageFormat.format(Messages.getString("Exp.MissingScenario"), this.getName());
            } else if (this.experiment.getScenario().getSequencer() == null) {
                string = MessageFormat.format(Messages.getString("Exp.MissingSeq"), this.getName());
            } else if (this.experiment.getScenario().getModel() == null) {
                string = MessageFormat.format(Messages.getString("Exp.MissingModel"), this.getName());
            } else {
                bl = true;
                string = MessageFormat.format(Messages.getString("Exp.IErr"), this.getName());
            }
        } else {
            bl = true;
            string = MessageFormat.format(Messages.getString("Exp.IErr"), this.getName());
        }
        final String string2 = string;
        if (bl) {
            Activator.logError(string2, exception);
        }
        try {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    Status status = new Status(2, "org.eclipse.stem.jobs", 1, string2, null);
                    ErrorDialog.openError((Shell)iWorkbenchWindow.getShell(), null, null, (IStatus)status);
                }
            });
        }
        catch (Error error) {}
    }

    private void stopAllSimulations() {
        for (ISimulation iSimulation : this.activeSimulations) {
            iSimulation.stop();
            iSimulation.cancel();
        }
    }

    private void startSimulationRunning(ISimulation iSimulation) {
        this.activeSimulations.add(iSimulation);
        iSimulation.addSimulationListener(this);
        iSimulation.run();
    }

    protected int getTotalWork() {
        return 1;
    }

    protected ISimulation getNextSimulationToRun() {
        ISimulation iSimulation = null;
        if (!this.experiment.isComplete()) {
            iSimulation = SimulationManager.getManager().createSimulation(this.experiment.updateScenario(), null);
        }
        return iSimulation;
    }

    public void run() {
        this.schedule();
    }

    public void pause() {
        throw new UnsupportedOperationException();
    }

    public void step() {
        throw new UnsupportedOperationException();
    }

    public void reset() {
        throw new UnsupportedOperationException();
    }

    public void stop() {
        this.keepRunning = false;
    }

    public boolean isRunning() {
        return !this.batchState.equals((Object)BatchState.PAUSED);
    }

    public void simulationChanged(SimulationEvent simulationEvent) {
        if (simulationEvent.getSimulationState() == SimulationState.COMPLETED_SEQUENCE) {
            this.monitor.worked(1);
            simulationEvent.getSimulation().stop();
            if (this.keepRunning) {
                if (!this.monitor.isCanceled() && this.runningSimulationsSequentially) {
                    ISimulation iSimulation = this.getNextSimulationToRun();
                    if (iSimulation != null) {
                        this.startSimulationRunning(iSimulation);
                    } else if (this.activeSimulations.size() == 0) {
                        this.monitor.done();
                        this.setBatchState(BatchState.STOPPED);
                    }
                }
            } else if (this.activeSimulations.size() == 0) {
                this.monitor.done();
                this.setBatchState(BatchState.STOPPED);
            }
        } else if (simulationEvent.getSimulationState() == SimulationState.STOPPED) {
            this.activeSimulations.remove(simulationEvent.getSimulation());
            simulationEvent.getSimulation().removeSimulationListener(this);
            if (this.activeSimulations.size() == 0) {
                this.monitor.done();
                this.setBatchState(BatchState.STOPPED);
            }
        }
        if (!this.cancelRequested && this.monitor.isCanceled()) {
            this.keepRunning = false;
            this.cancelRequested = true;
            this.stopAllSimulations();
        }
        if (!this.keepRunning && !this.cancelRequested) {
            this.cancelRequested = true;
            this.stopAllSimulations();
        }
    }

    public Experiment getExperiment() {
        return this.experiment;
    }

    public final BatchState getBatchState() {
        return this.batchState;
    }

    private void setBatchState(BatchState batchState) {
        if (this.getBatchState() != batchState) {
            this.batchState = batchState;
            this.fireBatchChanged(batchState);
        }
    }

    public final boolean isRunningSimulationsSequentially() {
        return this.runningSimulationsSequentially;
    }

    public final void setRunningSimulationsSequentially(boolean bl) {
        this.runningSimulationsSequentially = bl;
    }

    public final boolean isRunningInBackground() {
        return this.runningInBackground;
    }

    public final void setRunningInBackground(boolean bl) {
        this.runningInBackground = bl;
    }

    public final void addBatchListener(IBatchListener iBatchListener) {
        if (!this.listeners.contains(iBatchListener)) {
            this.listeners.add(iBatchListener);
        }
    }

    public final void removeBatchListener(IBatchListener iBatchListener) {
        this.listeners.remove(iBatchListener);
    }

    public void addBatchListenerSync(IBatchListenerSync iBatchListenerSync) {
        if (!this.listenersSync.contains(iBatchListenerSync)) {
            this.listenersSync.add(iBatchListenerSync);
        }
    }

    public void removeBatchListenerSync(IBatchListenerSync iBatchListenerSync) {
        this.listenersSync.remove(iBatchListenerSync);
    }

    private void fireBatchChanged(BatchState batchState) {
        BatchEvent batchEvent = new BatchEvent(this, batchState);
        for (IBatchListener object : this.listeners) {
            object.batchChanged(batchEvent);
        }
        for (IBatchListenerSync iBatchListenerSync : this.listenersSync) {
            iBatchListenerSync.batchChangedSync(batchEvent);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[");
        stringBuilder.append(this.getSequenceNumber());
        stringBuilder.append("] ");
        stringBuilder.append(this.isRunningSimulationsSequentially() ? "S/" : "P/");
        stringBuilder.append(this.isRunningInBackground() ? "B " : "F ");
        stringBuilder.append(this.getBatchState().toString());
        return stringBuilder.toString();
    }
}

