/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.jobs.batch;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.stem.core.experiment.Experiment;
import org.eclipse.stem.jobs.Activator;
import org.eclipse.stem.jobs.batch.Batch;
import org.eclipse.stem.jobs.batch.BatchEvent;
import org.eclipse.stem.jobs.batch.BatchManagerEvent;
import org.eclipse.stem.jobs.batch.BatchState;
import org.eclipse.stem.jobs.batch.IBatch;
import org.eclipse.stem.jobs.batch.IBatchListener;
import org.eclipse.stem.jobs.batch.IBatchListenerSync;
import org.eclipse.stem.jobs.batch.IBatchManagerListener;
import org.eclipse.stem.jobs.batch.IBatchManagerListenerSync;
import org.eclipse.stem.jobs.batch.Messages;
import org.eclipse.stem.jobs.execution.ExecutableManager;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchManager
extends ExecutableManager
implements IBatchListener {
    public static BatchManager INSTANCE = new BatchManager();
    private static int sequenceNumber = 0;
    public static final IBatch[] NONE = new Batch[0];
    private final List<IBatchManagerListener> listeners = new CopyOnWriteArrayList<IBatchManagerListener>();
    private final List<IBatchManagerListenerSync> listenersSync = new CopyOnWriteArrayList<IBatchManagerListenerSync>();
    private final List<IBatch> batches = new ArrayList<IBatch>();

    private BatchManager() {
    }

    private static final synchronized int getAndIncrementBatchSequenceNumber() {
        return sequenceNumber++;
    }

    public List<IBatch> getActiveBatches() {
        return this.batches;
    }

    private void addActiveBatch(IBatch iBatch) {
        this.batches.add(iBatch);
        iBatch.addBatchListener(this);
        this.fireBatchManagerChanged(new IBatch[]{iBatch}, NONE);
    }

    private final void removeActiveBatch(IBatch iBatch) {
        this.batches.remove(iBatch);
        iBatch.removeBatchListener(this);
        this.fireBatchManagerChanged(NONE, new IBatch[]{iBatch});
    }

    public IBatch createBatch(Experiment experiment) {
        Batch batch = new Batch(experiment, BatchManager.getAndIncrementBatchSequenceNumber());
        batch.setPriority(30);
        BatchAdapter batchAdapter = new BatchAdapter(batch);
        this.addActiveBatch(batchAdapter);
        return batchAdapter;
    }

    protected IBatch createBatch(IConfigurationElement iConfigurationElement, IProgressMonitor iProgressMonitor) {
        IBatch iBatch = null;
        String string = iConfigurationElement.getAttribute("identifier");
        try {
            iBatch = this.createBatch(URI.createURI((String)string), iProgressMonitor);
        }
        catch (Exception exception) {
            Activator.logError(MessageFormat.format(Messages.getString("BatchMgr.Deserialization_Error"), string), exception);
            iBatch = null;
        }
        return iBatch;
    }

    private IBatch createBatch(URI uRI, IProgressMonitor iProgressMonitor) {
        IBatch iBatch = null;
        try {
            ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
            Resource resource = resourceSetImpl.getResource(uRI, true);
            iProgressMonitor.subTask("Reading Experiment from file");
            resource.load(null);
            iProgressMonitor.subTask("Creating Batch from Experiment");
            iBatch = this.createBatch((Experiment)resource.getContents().get(0));
        }
        catch (Exception exception) {
            Activator.logError(MessageFormat.format(Messages.getString("BatchMgr.Deserialization_Error"), uRI.toString()), exception);
            iBatch = null;
        }
        return iBatch;
    }

    public void createAndRunBatch(final Experiment experiment) {
        new Job(Messages.getString("BatchMgr.StartBatch")){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                try {
                    IBatch iBatch = BatchManager.this.createBatch(experiment);
                    iProgressMonitor.subTask(Messages.getString("BatchMgr.Run"));
                    iBatch.run();
                }
                catch (Exception exception) {
                    iProgressMonitor.done();
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void createAndRunBatch(final IConfigurationElement iConfigurationElement) {
        new Job(Messages.getString("BatchMgr.StartBatch")){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                iProgressMonitor.beginTask(Messages.getString("BatchMgr.CrtSim"), -1);
                try {
                    IBatch iBatch = BatchManager.this.createBatch(iConfigurationElement, iProgressMonitor);
                    iProgressMonitor.subTask(Messages.getString("BatchMgr.Run"));
                    iBatch.run();
                }
                catch (NullPointerException nullPointerException) {
                    iProgressMonitor.done();
                }
                iProgressMonitor.done();
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public final int getSequenceNumber() {
        return sequenceNumber;
    }

    public void addBatchManagerListener(IBatchManagerListener iBatchManagerListener) {
        if (!this.listeners.contains(iBatchManagerListener)) {
            this.listeners.add(iBatchManagerListener);
        }
    }

    public void addBatchManagerListenerSync(IBatchManagerListenerSync iBatchManagerListenerSync) {
        if (!this.listenersSync.contains(iBatchManagerListenerSync)) {
            this.listenersSync.add(iBatchManagerListenerSync);
        }
    }

    public void removeListener(IBatchManagerListener iBatchManagerListener) {
        this.listeners.remove(iBatchManagerListener);
    }

    public void removeListenerSync(IBatchManagerListenerSync iBatchManagerListenerSync) {
        this.listenersSync.remove(iBatchManagerListenerSync);
    }

    private void fireBatchManagerChanged(IBatch[] iBatchArray, IBatch[] iBatchArray2) {
        final BatchManagerEvent batchManagerEvent = new BatchManagerEvent(this, iBatchArray, iBatchArray2);
        for (final IBatchManagerListener object : this.listeners) {
            try {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        object.batchesChanged(batchManagerEvent);
                    }
                });
            }
            catch (Error error) {
                object.batchesChanged(batchManagerEvent);
            }
        }
        for (final IBatchManagerListenerSync iBatchManagerListenerSync : this.listenersSync) {
            try {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        iBatchManagerListenerSync.batchesChangedSync(batchManagerEvent);
                    }
                });
            }
            catch (Error error) {
                iBatchManagerListenerSync.batchesChangedSync(batchManagerEvent);
            }
        }
    }

    @Override
    public void batchChanged(BatchEvent batchEvent) {
        if (batchEvent.getBatchState().equals((Object)BatchState.STOPPED)) {
            this.removeActiveBatch(batchEvent.getBatch());
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (IBatch iBatch : this.batches) {
            stringBuilder.append(iBatch.toString());
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    static void resetBatchManager() {
        INSTANCE = new BatchManager();
    }

    protected static class BatchAdapter
    implements IBatch,
    IBatchListener,
    IBatchListenerSync {
        private final List<IBatchListener> listeners = new CopyOnWriteArrayList<IBatchListener>();
        private final List<IBatchListenerSync> listenersSync = new CopyOnWriteArrayList<IBatchListenerSync>();
        private final IBatch batch;

        protected BatchAdapter(IBatch iBatch) {
            this.batch = iBatch;
            iBatch.addBatchListener(this);
            iBatch.addBatchListenerSync(this);
        }

        public String getName() {
            return this.batch.getName();
        }

        public String getNameWithSequenceNumber() {
            return this.batch.getNameWithSequenceNumber();
        }

        public Experiment getExperiment() {
            return this.batch.getExperiment();
        }

        public Date getCreationTime() {
            return this.batch.getCreationTime();
        }

        public String getUniqueIDString() {
            return this.batch.getUniqueIDString();
        }

        public BatchState getBatchState() {
            return this.batch.getBatchState();
        }

        public int getSequenceNumber() {
            return this.batch.getSequenceNumber();
        }

        public boolean isRunningInBackground() {
            return this.batch.isRunningInBackground();
        }

        public boolean isRunningSimulationsSequentially() {
            return this.batch.isRunningSimulationsSequentially();
        }

        public void setRunningInBackground(boolean bl) {
            this.batch.setRunningInBackground(bl);
        }

        public void setRunningSimulationsSequentially(boolean bl) {
            this.batch.setRunningSimulationsSequentially(bl);
        }

        public void run() {
            this.batch.run();
        }

        public void pause() {
            this.batch.pause();
        }

        public void step() {
            this.batch.step();
        }

        public void reset() {
            this.batch.reset();
        }

        public void stop() {
            this.batch.stop();
        }

        public boolean isRunning() {
            return this.batch.isRunning();
        }

        public boolean isStoppable() {
            return this.batch.isStoppable();
        }

        public boolean cancel() {
            return this.batch.cancel();
        }

        public void addBatchListener(IBatchListener iBatchListener) {
            if (!this.listeners.contains(iBatchListener)) {
                this.listeners.add(iBatchListener);
            }
        }

        public void removeBatchListener(IBatchListener iBatchListener) {
            this.listeners.remove(iBatchListener);
        }

        public void addBatchListenerSync(IBatchListenerSync iBatchListenerSync) {
            if (!this.listenersSync.contains(iBatchListenerSync)) {
                this.listenersSync.add(iBatchListenerSync);
            }
        }

        public void removeBatchListenerSync(IBatchListenerSync iBatchListenerSync) {
            this.listenersSync.remove(iBatchListenerSync);
        }

        protected void fireBatchChanged(BatchState batchState) {
            BatchEvent batchEvent = new BatchEvent(this, batchState);
            for (IBatchListener iBatchListener : this.listeners) {
                iBatchListener.batchChanged(batchEvent);
            }
        }

        protected void fireBatchChangedSync(BatchState batchState) {
            BatchEvent batchEvent = new BatchEvent(this, batchState);
            for (IBatchListenerSync iBatchListenerSync : this.listenersSync) {
                iBatchListenerSync.batchChangedSync(batchEvent);
            }
        }

        public void batchChanged(final BatchEvent batchEvent) {
            try {
                if (!Display.getDefault().isDisposed()) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            BatchAdapter.this.fireBatchChanged(batchEvent.getBatchState());
                        }
                    });
                }
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (Error error) {
                this.fireBatchChanged(batchEvent.getBatchState());
            }
        }

        public void batchChangedSync(final BatchEvent batchEvent) {
            try {
                if (!Display.getDefault().isDisposed()) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            BatchAdapter.this.fireBatchChangedSync(batchEvent.getBatchState());
                        }
                    });
                }
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (Error error) {
                this.fireBatchChanged(batchEvent.getBatchState());
            }
        }

        public String toString() {
            return this.batch.toString();
        }
    }
}

