/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.jobs.execution;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.stem.core.common.impl.DublinCoreImpl;
import org.eclipse.stem.jobs.execution.IExecutable;

public abstract class Executable
extends Job
implements IExecutable {
    private int sequenceNumber = 0;
    private final Date creationTime;

    public Executable(String string, int n) {
        super(string);
        this.sequenceNumber = n;
        this.creationTime = Calendar.getInstance().getTime();
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(int n) {
        this.sequenceNumber = n;
    }

    public String getNameWithSequenceNumber() {
        StringBuilder stringBuilder = new StringBuilder("[");
        stringBuilder.append(this.getSequenceNumber());
        stringBuilder.append("] ");
        stringBuilder.append(this.getName());
        return stringBuilder.toString();
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public String getUniqueIDString() {
        StringBuilder stringBuilder = new StringBuilder(URI.encodeSegment((String)this.getName(), (boolean)false).replace("%", "-"));
        stringBuilder.append("-");
        stringBuilder.append(this.getSequenceNumber());
        stringBuilder.append("-");
        stringBuilder.append(DublinCoreImpl.createISO8601DateString((Date)this.getCreationTime()));
        return stringBuilder.toString();
    }

    public boolean isStoppable() {
        return true;
    }
}

