/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.jobs.simulation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.scenario.Scenario;
import org.eclipse.stem.core.scenario.impl.ScenarioImpl;
import org.eclipse.stem.core.scenario.provider.ScenarioItemProviderAdapterFactory;
import org.eclipse.stem.core.sequencer.Sequencer;
import org.eclipse.stem.jobs.Activator;
import org.eclipse.stem.jobs.execution.Executable;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.ISimulationListener;
import org.eclipse.stem.jobs.simulation.ISimulationListenerSync;
import org.eclipse.stem.jobs.simulation.Messages;
import org.eclipse.stem.jobs.simulation.SimulationEvent;
import org.eclipse.stem.jobs.simulation.SimulationState;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class Simulation
extends Executable
implements ISimulation,
Preferences.IPropertyChangeListener {
    private final List<ISimulationListener> listeners = Collections.synchronizedList(new ArrayList());
    private final List<ISimulationListenerSync> listenersSync = new CopyOnWriteArrayList<ISimulationListenerSync>();
    public boolean simulationSleep = true;
    private int sleepMilliseconds = 0;
    private SimulationState simulationState;
    private Scenario scenario = null;
    private Adapter adapter = null;
    private boolean keepRunning = true;
    private boolean reset = false;
    private boolean stepping = false;
    private boolean stopping = false;
    ScenarioItemProviderAdapterFactory scenarioItemProviderAdapterFactory = new ScenarioItemProviderAdapterFactory();

    public Simulation(String string, int n) {
        super(string == null ? "" : string, n);
        this.simulationState = SimulationState.PAUSED;
    }

    public Simulation(Scenario scenario, int n) {
        this(scenario.produceTitle(), n);
        this.scenario = scenario;
        this.setPreferences();
        Activator.getDefault().getPluginPreferences().addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
    }

    protected void setPreferences() {
        Preferences preferences = Activator.getDefault().getPluginPreferences();
        this.simulationSleep = preferences.getBoolean("cyclePause");
        this.sleepMilliseconds = preferences.getInt("cyclePauseMilliSeconds");
        ScenarioImpl.reportEachUnresolvedIdentifiable = preferences.getBoolean("reportEachUnresolvedIdentifiable");
        ScenarioImpl.reportDanglingAirTransportEdges = preferences.getBoolean("reportDanglingAirTransportEdges");
        ScenarioImpl.reportNumberofUnresolvedIdentifiables = preferences.getBoolean("reportNumberOfUnresolvedIdentifiable");
    }

    public final SimulationState getSimulationState() {
        return this.simulationState;
    }

    private final void setSimulationState(SimulationState simulationState) {
        this.simulationState = simulationState;
        this.fireSimulationChanged(simulationState);
    }

    protected IStatus run(IProgressMonitor iProgressMonitor) {
        IStatus iStatus = Status.OK_STATUS;
        try {
            this.setSimulationState(SimulationState.RUNNING);
            this.keepRunning = true;
            if (this.reset) {
                this.scenario.reset();
                this.reset = false;
            }
            assert (this.scenario.sane());
            iProgressMonitor.beginTask(this.scenario.produceTitle(), 100);
            Sequencer sequencer = this.scenario.getSequencer();
            iProgressMonitor.worked((int)sequencer.getWorkComplete());
            final Simulation simulation = this;
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification notification) {
                    Scenario scenario = (Scenario)notification.getNotifier();
                    switch (notification.getFeatureID(Scenario.class)) {
                        case 7: {
                            SimulationEvent simulationEvent = new SimulationEvent(simulation, SimulationState.RUNNING, scenario.getProgress());
                            simulation.fireSimulationChangedEvent(simulationEvent);
                        }
                    }
                }
            };
            this.scenario.eAdapters().add((Object)this.adapter);
            if (!sequencer.isTimeToStop()) {
                while (this.keepRunning && !this.reset) {
                    STEMTime sTEMTime = sequencer.getCurrentTime();
                    iProgressMonitor.subTask(sTEMTime.toString());
                    try {
                        this.scenario.step();
                        assert (this.scenario.sane());
                        if (this.simulationSleep) {
                            Thread.sleep(this.sleepMilliseconds);
                        }
                        iProgressMonitor.worked(sequencer.getWorkIncrement());
                        if (sequencer.isTimeToStop()) {
                            this.keepRunning = false;
                            iStatus = Status.OK_STATUS;
                        } else if (iProgressMonitor.isCanceled()) {
                            this.keepRunning = false;
                            iStatus = Status.CANCEL_STATUS;
                        } else if (this.stepping) {
                            this.keepRunning = false;
                        }
                    }
                    catch (Exception exception) {
                        Simulation.handleException(this.scenario, this.getName(), true, exception);
                        this.keepRunning = false;
                        this.stopping = true;
                        iStatus = Status.CANCEL_STATUS;
                    }
                    this.setSimulationState(SimulationState.COMPLETED_CYCLE);
                }
                if (sequencer.isTimeToStop() && iStatus == Status.OK_STATUS) {
                    this.setSimulationState(SimulationState.COMPLETED_SEQUENCE);
                }
            } else {
                Activator.logInformation(MessageFormat.format(Messages.getString("Sim.Time_Error"), sequencer.getCurrentTime().toString(), sequencer.getEndTime().toString()), null);
            }
            if (this.reset) {
                this.scenario.reset();
                this.reset = false;
                this.setSimulationState(SimulationState.RESET);
            }
            iProgressMonitor.done();
        }
        catch (RuntimeException runtimeException) {
            Simulation.handleException(this.scenario, this.getName(), true, runtimeException);
            this.stopping = true;
        }
        this.setSimulationState(this.stopping ? SimulationState.STOPPED : SimulationState.PAUSED);
        return iStatus;
    }

    public static void handleException(Scenario scenario, String string, boolean bl, Exception exception) {
        String string2 = "";
        boolean bl2 = false;
        if (exception instanceof NullPointerException) {
            if (scenario.getSequencer() == null) {
                string2 = MessageFormat.format(Messages.getString("Sim.MissingSeq"), string);
            } else if (scenario.getModel() == null) {
                string2 = MessageFormat.format(Messages.getString("Sim.MissingModel"), string);
            } else {
                bl2 = true;
                string2 = MessageFormat.format(Messages.getString("Sim.IErr"), string);
            }
        } else {
            bl2 = true;
            string2 = MessageFormat.format(Messages.getString("Sim.IErr"), string);
        }
        final String string3 = string2;
        if (bl2 || !bl) {
            Activator.logError(string3, exception);
        }
        if (bl) {
            try {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        try {
                            IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                            Status status = new Status(2, "org.eclipse.stem.jobs", 1, string3, null);
                            ErrorDialog.openError((Shell)iWorkbenchWindow.getShell(), null, null, (IStatus)status);
                        }
                        catch (Exception exception) {}
                    }
                });
            }
            catch (Error error) {}
        }
    }

    public final void run() {
        this.stepping = false;
        this.schedule();
    }

    public final void pause() {
        this.keepRunning = false;
    }

    public final void reset() {
        this.reset = true;
        this.stepping = false;
        if (this.getSimulationState().equals((Object)SimulationState.PAUSED)) {
            this.scenario.reset();
            this.reset = false;
            this.setSimulationState(SimulationState.RESET);
            this.setSimulationState(SimulationState.PAUSED);
        }
    }

    public final void step() {
        this.stepping = true;
        this.schedule();
    }

    public final void stop() {
        this.stopping = true;
        this.keepRunning = false;
        this.setSimulationState(SimulationState.STOPPED);
    }

    public boolean isRunning() {
        return !this.simulationState.equals((Object)SimulationState.PAUSED);
    }

    public final Scenario getScenario() {
        return this.scenario;
    }

    protected final void setScenario(Scenario scenario) {
        this.scenario = scenario;
    }

    public void addSimulationListener(ISimulationListener iSimulationListener) {
        if (!this.listeners.contains(iSimulationListener)) {
            this.listeners.add(iSimulationListener);
        }
    }

    public void addSimulationListenerSync(ISimulationListenerSync iSimulationListenerSync) {
        if (!this.listenersSync.contains(iSimulationListenerSync)) {
            this.listenersSync.add(iSimulationListenerSync);
        }
    }

    public void removeSimulationListener(ISimulationListener iSimulationListener) {
        this.listeners.remove(iSimulationListener);
    }

    public void removeSimulationListenerSync(ISimulationListenerSync iSimulationListenerSync) {
        this.listenersSync.remove(iSimulationListenerSync);
    }

    private void fireSimulationChanged(SimulationState simulationState) {
        SimulationEvent simulationEvent = new SimulationEvent(this, simulationState);
        this.fireSimulationChangedEvent(simulationEvent);
    }

    void fireSimulationChangedEvent(SimulationEvent simulationEvent) {
        for (ISimulationListenerSync object : this.listenersSync) {
            object.simulationChangedSync(simulationEvent);
        }
        for (ISimulationListener iSimulationListener : this.listeners) {
            iSimulationListener.simulationChanged(simulationEvent);
        }
    }

    public void propertyChange(Preferences.PropertyChangeEvent propertyChangeEvent) {
        this.setPreferences();
    }

    public String toString() {
        return this.scenario.produceTitle();
    }

    public boolean interruptRequested() {
        return !this.keepRunning && this.stopping;
    }

    public void destroy() {
        ArrayList<ISimulationListener> arrayList = new ArrayList<ISimulationListener>();
        arrayList.addAll(this.listeners);
        for (ISimulationListener object2 : arrayList) {
            this.removeSimulationListener(object2);
        }
        this.listeners.clear();
        ArrayList<ISimulationListenerSync> arrayList2 = new ArrayList<ISimulationListenerSync>();
        arrayList2.addAll(this.listenersSync);
        for (Object iSimulationListenerSync : arrayList2) {
            this.removeSimulationListenerSync((ISimulationListenerSync)iSimulationListenerSync);
        }
        this.listenersSync.clear();
        arrayList.clear();
        arrayList2.clear();
        this.scenario.eAdapters().remove((Object)this.adapter);
        Activator.getDefault().getPluginPreferences().removePropertyChangeListener((Preferences.IPropertyChangeListener)this);
    }
}

