/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.jobs.simulation;

import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.emf.common.util.URI;
import org.eclipse.stem.core.scenario.Scenario;
import org.eclipse.stem.jobs.Activator;

public class SimulationCaching {
    public static final SimulationCaching INSTANCE = new SimulationCaching();
    private final Map<URI, Scenario> cachedScenarios = new WeakHashMap<URI, Scenario>();
    private boolean toUseCaching = false;

    private SimulationCaching() {
        this.setPreferences();
        Activator.getDefault().getPluginPreferences().addPropertyChangeListener(new Preferences.IPropertyChangeListener(){

            public void propertyChange(Preferences.PropertyChangeEvent propertyChangeEvent) {
                SimulationCaching.this.setPreferences();
            }
        });
    }

    public boolean isScenarioInCache(URI uRI) {
        return this.cachedScenarios.containsKey(uRI);
    }

    public Scenario getCachedScenario(URI uRI) {
        return this.cachedScenarios.get(uRI);
    }

    public void addScenarioToCache(Scenario scenario) {
        if (scenario.getURI() == null) {
            return;
        }
        this.cachedScenarios.put(scenario.getURI(), scenario);
    }

    public boolean toUseCaching() {
        return this.toUseCaching;
    }

    protected void setPreferences() {
        Preferences preferences = Activator.getDefault().getPluginPreferences();
        this.toUseCaching = preferences.getBoolean("useScenariosCaching");
    }
}

