/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.jobs.simulation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.stem.core.Utility;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.model.Model;
import org.eclipse.stem.core.scenario.Scenario;
import org.eclipse.stem.core.sequencer.Sequencer;
import org.eclipse.stem.jobs.Activator;
import org.eclipse.stem.jobs.execution.ExecutableManager;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.ISimulationListener;
import org.eclipse.stem.jobs.simulation.ISimulationListenerSync;
import org.eclipse.stem.jobs.simulation.ISimulationManagerListener;
import org.eclipse.stem.jobs.simulation.ISimulationManagerListenerSync;
import org.eclipse.stem.jobs.simulation.Messages;
import org.eclipse.stem.jobs.simulation.Simulation;
import org.eclipse.stem.jobs.simulation.SimulationCaching;
import org.eclipse.stem.jobs.simulation.SimulationEvent;
import org.eclipse.stem.jobs.simulation.SimulationManagerEvent;
import org.eclipse.stem.jobs.simulation.SimulationState;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimulationManager
extends ExecutableManager
implements ISimulationListener {
    private static SimulationManager INSTANCE = null;
    private static int sequenceNumber = 0;
    private final List<ISimulationManagerListener> listeners = new CopyOnWriteArrayList<ISimulationManagerListener>();
    private final List<ISimulationManagerListenerSync> listenersSync = new CopyOnWriteArrayList<ISimulationManagerListenerSync>();
    public static final ISimulation[] NONE = new Simulation[0];
    private List<ISimulation> activeSimulations = new ArrayList<ISimulation>();

    private SimulationManager() {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("scenario", new XMIResourceFactoryImpl());
    }

    public static final SimulationManager getManager() {
        if (INSTANCE == null) {
            INSTANCE = new SimulationManager();
        }
        return INSTANCE;
    }

    private static final synchronized int getAndIncrementSimulationSequenceNumber() {
        return sequenceNumber++;
    }

    public static final void resetSimulationManager() {
        INSTANCE = null;
        sequenceNumber = 0;
    }

    public final List<ISimulation> getActiveSimulations() {
        return this.activeSimulations;
    }

    private final void addActiveSimulation(ISimulation iSimulation) {
        this.activeSimulations.add(iSimulation);
        iSimulation.addSimulationListener(this);
        this.fireSimulationManagerChanged(new ISimulation[]{iSimulation}, NONE);
    }

    private final void removeActiveSimulation(ISimulation iSimulation) {
        this.activeSimulations.remove(iSimulation);
        iSimulation.removeSimulationListener(this);
        this.fireSimulationManagerChanged(NONE, new ISimulation[]{iSimulation});
    }

    public ISimulation createSimulation(IConfigurationElement iConfigurationElement, IProgressMonitor iProgressMonitor) {
        ISimulation iSimulation = null;
        String string = iConfigurationElement.getAttribute("identifier");
        try {
            iSimulation = this.createSimulation(URI.createURI((String)string), iProgressMonitor);
        }
        catch (Exception exception) {
            Activator.logError(MessageFormat.format(Messages.getString("SimMgr.Deserialization_Error"), string), exception);
            iSimulation = null;
        }
        return iSimulation;
    }

    public ISimulation createSimulation(URI uRI, IProgressMonitor iProgressMonitor) {
        ISimulation iSimulation = null;
        try {
            iProgressMonitor.subTask("Reading Scenario from file");
            Scenario scenario = (Scenario)Utility.getIdentifiable((URI)uRI);
            iProgressMonitor.subTask("Creating Simulation from Scenario");
            iSimulation = this.createSimulation(scenario, iProgressMonitor);
        }
        catch (Exception exception) {
            Activator.logError(MessageFormat.format(Messages.getString("SimMgr.Deserialization_Error"), uRI.toString()), exception);
            iSimulation = null;
        }
        return iSimulation;
    }

    public ISimulation createSimulation(Scenario scenario, IProgressMonitor iProgressMonitor) {
        SimulationAdapter simulationAdapter = null;
        try {
            Preferences preferences = Activator.getDefault().getPluginPreferences();
            boolean bl = preferences.getBoolean("useScenariosCaching");
            Scenario scenario2 = null;
            if (bl) {
                if (SimulationCaching.INSTANCE.isScenarioInCache(scenario.getURI())) {
                    scenario2 = SimulationCaching.INSTANCE.getCachedScenario(scenario.getURI());
                    boolean bl2 = false;
                    for (ISimulation iSimulation : this.getActiveSimulations()) {
                        if (!iSimulation.getScenario().equals(scenario2)) continue;
                        Scenario scenario3 = null;
                        scenario3 = (Scenario)EcoreUtil.copy((EObject)scenario2);
                        if (scenario2.getModel() != null) {
                            scenario3.setModel((Model)EcoreUtil.copy((EObject)scenario2.getModel()));
                        }
                        if (scenario2.getSequencer() != null) {
                            scenario3.setSequencer((Sequencer)EcoreUtil.copy((EObject)scenario2.getSequencer()));
                        }
                        bl2 = true;
                        break;
                    }
                    if (!bl2) {
                        scenario2.reset();
                    }
                } else {
                    SimulationCaching.INSTANCE.addScenarioToCache(scenario);
                }
            }
            Simulation simulation = new Simulation(scenario, SimulationManager.getAndIncrementSimulationSequenceNumber());
            if (scenario.getCanonicalGraph() == null) {
                scenario.initialize();
            } else {
                scenario.reset();
            }
            simulation.setPriority(30);
            simulationAdapter = new SimulationAdapter(simulation);
            this.addActiveSimulation(simulationAdapter);
        }
        catch (RuntimeException runtimeException) {
            Simulation.handleException(scenario, scenario.getDublinCore().getTitle(), true, runtimeException);
            simulationAdapter = null;
        }
        return simulationAdapter;
    }

    public void createAndRunSimulation(final IConfigurationElement iConfigurationElement) {
        new Job(Messages.getString("SimMgr.Start_Sim")){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                iProgressMonitor.beginTask(Messages.getString("SimMgr.CrtSim"), -1);
                try {
                    ISimulation iSimulation = SimulationManager.this.createSimulation(iConfigurationElement, iProgressMonitor);
                    iProgressMonitor.subTask(Messages.getString("SimMgr.Run"));
                    iSimulation.run();
                }
                catch (NullPointerException nullPointerException) {
                    iProgressMonitor.done();
                }
                iProgressMonitor.done();
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void createAndRunSimulation(final Scenario scenario) {
        new Job(Messages.getString("SimMgr.Start_Sim")){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                try {
                    ISimulation iSimulation = SimulationManager.this.createSimulation(scenario, iProgressMonitor);
                    iProgressMonitor.subTask(Messages.getString("SimMgr.Run"));
                    iSimulation.run();
                }
                catch (Exception exception) {
                    iProgressMonitor.done();
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void createAndStepSimulation(final IConfigurationElement iConfigurationElement) {
        new Job(Messages.getString("SimMgr.Start_Sim")){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                try {
                    ISimulation iSimulation = SimulationManager.this.createSimulation(iConfigurationElement, iProgressMonitor);
                    iProgressMonitor.subTask(Messages.getString("SimMgr.Run"));
                    iSimulation.step();
                }
                catch (NullPointerException nullPointerException) {
                    iProgressMonitor.done();
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void createAndStepSimulation(final Scenario scenario) {
        new Job(Messages.getString("SimMgr.Start_Sim")){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                try {
                    ISimulation iSimulation = SimulationManager.this.createSimulation(scenario, iProgressMonitor);
                    iProgressMonitor.subTask(Messages.getString("SimMgr.Run"));
                    iSimulation.step();
                }
                catch (NullPointerException nullPointerException) {
                    iProgressMonitor.done();
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public ISimulation mapGraphToSimulation(Graph graph) {
        ISimulation iSimulation = null;
        for (ISimulation iSimulation2 : this.activeSimulations) {
            Graph graph2 = iSimulation2.getScenario().getCanonicalGraph();
            if (graph != graph2) continue;
            iSimulation = iSimulation2;
            break;
        }
        return iSimulation;
    }

    public void addSimulationManagerListener(ISimulationManagerListener iSimulationManagerListener) {
        if (!this.listeners.contains(iSimulationManagerListener)) {
            this.listeners.add(iSimulationManagerListener);
        }
    }

    public void addSimulationManagerListenerSync(ISimulationManagerListenerSync iSimulationManagerListenerSync) {
        if (!this.listenersSync.contains(iSimulationManagerListenerSync)) {
            this.listenersSync.add(iSimulationManagerListenerSync);
        }
    }

    public void removeListener(ISimulationManagerListener iSimulationManagerListener) {
        this.listeners.remove(iSimulationManagerListener);
    }

    public void removeListenerSync(ISimulationManagerListenerSync iSimulationManagerListenerSync) {
        this.listenersSync.remove(iSimulationManagerListenerSync);
    }

    private void fireSimulationManagerChanged(ISimulation[] iSimulationArray, ISimulation[] iSimulationArray2) {
        final SimulationManagerEvent simulationManagerEvent = new SimulationManagerEvent(this, iSimulationArray, iSimulationArray2);
        for (final ISimulationManagerListener object : this.listeners) {
            try {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        object.simulationsChanged(simulationManagerEvent);
                    }
                });
            }
            catch (Error error) {
                object.simulationsChanged(simulationManagerEvent);
            }
        }
        for (final ISimulationManagerListenerSync iSimulationManagerListenerSync : this.listenersSync) {
            try {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        iSimulationManagerListenerSync.simulationsChangedSync(simulationManagerEvent);
                    }
                });
            }
            catch (Error error) {
                iSimulationManagerListenerSync.simulationsChangedSync(simulationManagerEvent);
            }
        }
    }

    @Override
    public void simulationChanged(SimulationEvent simulationEvent) {
        if (simulationEvent.getSimulationState().equals((Object)SimulationState.STOPPED)) {
            if (simulationEvent.getSimulation() instanceof SimulationAdapter) {
                SimulationAdapter simulationAdapter = (SimulationAdapter)simulationEvent.getSimulation();
                Simulation simulation = (Simulation)simulationAdapter.getSimulation();
                Activator.getDefault().getPluginPreferences().removePropertyChangeListener((Preferences.IPropertyChangeListener)simulation);
            }
            this.removeActiveSimulation(simulationEvent.getSimulation());
        }
    }

    public static class SimulationAdapter
    implements ISimulation,
    ISimulationListener,
    ISimulationListenerSync {
        private final List<ISimulationListener> listeners = new CopyOnWriteArrayList<ISimulationListener>();
        private final List<ISimulationListenerSync> listenersSync = new CopyOnWriteArrayList<ISimulationListenerSync>();
        private final ISimulation simulation;

        protected SimulationAdapter(ISimulation iSimulation) {
            this.simulation = iSimulation;
            iSimulation.addSimulationListener(this);
            iSimulation.addSimulationListenerSync(this);
        }

        public String getName() {
            return this.simulation.getName();
        }

        public String getNameWithSequenceNumber() {
            return this.simulation.getNameWithSequenceNumber();
        }

        public Date getCreationTime() {
            return this.simulation.getCreationTime();
        }

        public String getUniqueIDString() {
            return this.simulation.getUniqueIDString();
        }

        public Scenario getScenario() {
            return this.simulation.getScenario();
        }

        public SimulationState getSimulationState() {
            return this.simulation.getSimulationState();
        }

        public int getSequenceNumber() {
            return this.simulation.getSequenceNumber();
        }

        public void setSequenceNumber(int n) {
            this.simulation.setSequenceNumber(n);
        }

        public void pause() {
            this.simulation.pause();
        }

        public void reset() {
            this.simulation.reset();
        }

        public void run() {
            this.simulation.run();
        }

        public void step() {
            this.simulation.step();
        }

        public void stop() {
            this.simulation.stop();
        }

        public boolean isRunning() {
            return this.simulation.isRunning();
        }

        public boolean isStoppable() {
            return this.simulation.isStoppable();
        }

        public void join() throws InterruptedException {
            this.simulation.join();
        }

        public boolean cancel() {
            return this.simulation.cancel();
        }

        public void addSimulationListener(ISimulationListener iSimulationListener) {
            if (!this.listeners.contains(iSimulationListener)) {
                this.listeners.add(iSimulationListener);
            }
        }

        public void removeSimulationListener(ISimulationListener iSimulationListener) {
            this.listeners.remove(iSimulationListener);
        }

        public void addSimulationListenerSync(ISimulationListenerSync iSimulationListenerSync) {
            if (!this.listenersSync.contains(iSimulationListenerSync)) {
                this.listenersSync.add(iSimulationListenerSync);
            }
        }

        public void removeSimulationListenerSync(ISimulationListenerSync iSimulationListenerSync) {
            this.listenersSync.remove(iSimulationListenerSync);
        }

        protected void fireSimulationChanged(SimulationEvent simulationEvent) {
            SimulationEvent simulationEvent2 = new SimulationEvent(this, simulationEvent.getSimulationState(), simulationEvent.getIterationProgress());
            for (ISimulationListener iSimulationListener : this.listeners) {
                iSimulationListener.simulationChanged(simulationEvent2);
            }
        }

        protected void fireSimulationChangedSync(SimulationEvent simulationEvent) {
            SimulationEvent simulationEvent2 = new SimulationEvent(this, simulationEvent.getSimulationState(), simulationEvent.getIterationProgress());
            for (ISimulationListenerSync iSimulationListenerSync : this.listenersSync) {
                iSimulationListenerSync.simulationChangedSync(simulationEvent2);
            }
        }

        public String toString() {
            return this.simulation.toString();
        }

        public void simulationChanged(final SimulationEvent simulationEvent) {
            try {
                if (!Display.getDefault().isDisposed()) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            SimulationAdapter.this.fireSimulationChanged(simulationEvent);
                        }
                    });
                }
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (Error error) {
                this.fireSimulationChanged(simulationEvent);
            }
        }

        public void simulationChangedSync(final SimulationEvent simulationEvent) {
            try {
                if (!Display.getDefault().isDisposed()) {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            SimulationAdapter.this.fireSimulationChangedSync(simulationEvent);
                        }
                    });
                }
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (Error error) {
                this.fireSimulationChangedSync(simulationEvent);
            }
        }

        public ISimulation getSimulation() {
            return this.simulation;
        }
    }
}

