/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.analysis.automaticexperiment;

import automaticexperiment.AutomaticExperiment;
import automaticexperiment.ModifiableParameter;
import java.util.List;
import org.eclipse.stem.analysis.AnalysisFactory;
import org.eclipse.stem.analysis.ErrorFunction;
import org.eclipse.stem.analysis.ThresholdErrorFunction;
import org.eclipse.stem.analysis.automaticexperiment.ErrorAnalysisAlgorithm;
import org.eclipse.stem.analysis.automaticexperiment.NelderMeadAlgorithm;
import org.eclipse.stem.analysis.automaticexperiment.SimplexAlgorithm;
import org.eclipse.stem.analysis.automaticexperiment.SimplexFunction;
import org.eclipse.stem.core.scenario.Scenario;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractErrorAnalysisAlgorithm
implements ErrorAnalysisAlgorithm {
    protected Scenario baseScenario = null;
    protected SimplexAlgorithm simplexAlgorithm = new NelderMeadAlgorithm();
    protected SimplexFunction simplexFnToMinimize = null;
    protected ErrorFunction errorFunction = null;
    protected double[] initialParamsValues = null;
    protected double[] paramsInitialSteps = null;
    protected double tolerance = -1.0;
    protected String referenceDataDirectory = null;
    protected long maxNumOfIterations = -1L;
    protected List<ModifiableParameter> parameters = null;

    @Override
    public abstract void execute();

    @Override
    public void setBaseScenario(Scenario scenario) {
        this.baseScenario = scenario;
    }

    @Override
    public void setTolerance(double d) {
        this.tolerance = d;
    }

    @Override
    public void setErrorFunction(ErrorFunction errorFunction) {
        this.errorFunction = errorFunction;
    }

    @Override
    public void setReferenceDataDirectory(String string) {
        this.referenceDataDirectory = string;
    }

    @Override
    public void init(AutomaticExperiment automaticExperiment) {
        this.setBaseScenario(automaticExperiment.getBaseScenario());
        this.setParameters((List<ModifiableParameter>)automaticExperiment.getParameters());
        double d = automaticExperiment.getTolerance();
        this.setTolerance(d);
        ThresholdErrorFunction thresholdErrorFunction = null;
        String string = automaticExperiment.getErrorFunction();
        if (string.equals("Threshold error function")) {
            thresholdErrorFunction = AnalysisFactory.eINSTANCE.createThresholdErrorFunction();
        }
        if (string.equals("Simple error function")) {
            thresholdErrorFunction = AnalysisFactory.eINSTANCE.createSimpleErrorFunction();
        }
        this.setErrorFunction((ErrorFunction)thresholdErrorFunction);
        String string2 = automaticExperiment.getReferanceDataDir();
        this.setReferenceDataDirectory(string2);
    }

    @Override
    public double[] getResultParameters() {
        return this.simplexAlgorithm.getMinimumParametersValues();
    }

    @Override
    public double getResultValue() {
        return this.simplexAlgorithm.getMinimumFunctionValue();
    }

    @Override
    public void setMaximumNumberOfIterations(long l) {
        this.maxNumOfIterations = l;
    }

    @Override
    public void setParameters(List<ModifiableParameter> list) {
        this.parameters = list;
        this.paramsInitialSteps = new double[list.size()];
        this.initialParamsValues = new double[list.size()];
        int n = 0;
        for (ModifiableParameter modifiableParameter : list) {
            this.paramsInitialSteps[n] = modifiableParameter.getStep();
            this.initialParamsValues[n] = modifiableParameter.getInitialValue();
            ++n;
        }
    }
}

