/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.analysis.automaticexperiment;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.model.Model;
import org.eclipse.stem.core.scenario.Scenario;
import org.eclipse.stem.core.sequencer.Sequencer;
import org.eclipse.stem.jobs.execution.ExecutableManager;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.Messages;
import org.eclipse.stem.jobs.simulation.Simulation;
import org.eclipse.stem.jobs.simulation.SimulationCaching;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomSimulationManager
extends ExecutableManager {
    private static CustomSimulationManager INSTANCE = null;
    private static int sequenceNumber = 0;
    public static final ISimulation[] NONE = new Simulation[0];
    private List<ISimulation> activeSimulations = new ArrayList<ISimulation>();

    private CustomSimulationManager() {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("scenario", new XMIResourceFactoryImpl());
    }

    public static final CustomSimulationManager getManager() {
        if (INSTANCE == null) {
            INSTANCE = new CustomSimulationManager();
        }
        return INSTANCE;
    }

    private static final synchronized int getAndIncrementSimulationSequenceNumber() {
        return sequenceNumber++;
    }

    public static final void resetSimulationManager() {
        INSTANCE = null;
        sequenceNumber = 0;
    }

    public final List<ISimulation> getActiveSimulations() {
        return this.activeSimulations;
    }

    private final void addActiveSimulation(ISimulation iSimulation) {
        this.activeSimulations.add(iSimulation);
    }

    public final void removeActiveSimulation(ISimulation iSimulation) {
        this.activeSimulations.remove(iSimulation);
    }

    public ISimulation createSimulation(Scenario scenario, IProgressMonitor iProgressMonitor) {
        Simulation simulation = null;
        try {
            boolean bl = false;
            Scenario scenario2 = null;
            if (bl) {
                if (SimulationCaching.INSTANCE.isScenarioInCache(scenario.getURI())) {
                    scenario2 = SimulationCaching.INSTANCE.getCachedScenario(scenario.getURI());
                    boolean bl2 = false;
                    for (ISimulation iSimulation : this.getActiveSimulations()) {
                        if (!iSimulation.getScenario().equals(scenario2)) continue;
                        Scenario scenario3 = null;
                        scenario3 = (Scenario)EcoreUtil.copy((EObject)scenario2);
                        if (scenario2.getModel() != null) {
                            scenario3.setModel((Model)EcoreUtil.copy((EObject)scenario2.getModel()));
                        }
                        if (scenario2.getSequencer() != null) {
                            scenario3.setSequencer((Sequencer)EcoreUtil.copy((EObject)scenario2.getSequencer()));
                        }
                        bl2 = true;
                        break;
                    }
                    if (!bl2) {
                        scenario2.reset();
                    }
                } else {
                    SimulationCaching.INSTANCE.addScenarioToCache(scenario);
                }
            }
            if (scenario.getCanonicalGraph() == null) {
                scenario.initialize();
            } else {
                scenario.reset();
            }
            Simulation simulation2 = new Simulation(scenario, CustomSimulationManager.getAndIncrementSimulationSequenceNumber());
            simulation2.setPriority(30);
            simulation = simulation2;
            this.addActiveSimulation((ISimulation)simulation);
        }
        catch (RuntimeException runtimeException) {
            Simulation.handleException((Scenario)scenario, (String)scenario.getDublinCore().getTitle(), (boolean)true, (Exception)runtimeException);
            simulation = null;
        }
        return simulation;
    }

    public void createAndRunSimulation(final Scenario scenario) {
        new Job(Messages.getString((String)"SimMgr.Start_Sim")){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                try {
                    ISimulation iSimulation = CustomSimulationManager.this.createSimulation(scenario, iProgressMonitor);
                    iProgressMonitor.subTask(Messages.getString((String)"SimMgr.Run"));
                    iSimulation.run();
                }
                catch (Exception exception) {
                    iProgressMonitor.done();
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public ISimulation mapGraphToSimulation(Graph graph) {
        ISimulation iSimulation = null;
        for (ISimulation iSimulation2 : this.activeSimulations) {
            Graph graph2 = iSimulation2.getScenario().getCanonicalGraph();
            if (graph != graph2) continue;
            iSimulation = iSimulation2;
            break;
        }
        return iSimulation;
    }
}

