/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.analysis.automaticexperiment;

import org.eclipse.stem.analysis.automaticexperiment.SimplexAlgorithm;
import org.eclipse.stem.analysis.automaticexperiment.SimplexFunction;

public class NelderMeadAlgorithm
implements SimplexAlgorithm {
    double ccoeff = 0.5;
    double del;
    double dn;
    double dnn;
    double ecoeff = 2.0;
    double eps = 0.001;
    int i;
    int ihi;
    int ilo;
    int j;
    int jcount;
    int l;
    int nn;
    double[] p;
    double[] p2star;
    double[] pbar;
    double[] pstar;
    double rcoeff = 1.0;
    double rq;
    double x;
    double[] y;
    double y2star;
    double ylo;
    double ystar;
    double z;
    int ifault = -1;
    int numres = -1;
    int icount = -1;
    double ynewlo;
    double[] xmin;

    public void execute(SimplexFunction simplexFunction, double[] dArray, double[] dArray2, double d) {
        this.execute(simplexFunction, dArray, d, dArray2, 1, -1);
    }

    private void execute(SimplexFunction simplexFunction, double[] dArray, double d, double[] dArray2, int n, int n2) {
        int n3 = dArray.length;
        if (d <= 0.0) {
            this.ifault = 1;
            return;
        }
        if (n3 < 1) {
            this.ifault = 1;
            return;
        }
        if (n < 1) {
            this.ifault = 1;
            return;
        }
        this.p = new double[n3 * (n3 + 1)];
        this.pstar = new double[n3];
        this.p2star = new double[n3];
        this.pbar = new double[n3];
        this.y = new double[n3 + 1];
        this.xmin = new double[n3];
        this.icount = 0;
        this.numres = 0;
        this.jcount = n;
        this.dn = n3;
        this.nn = n3 + 1;
        this.dnn = this.nn;
        this.del = 1.0;
        this.rq = d * this.dn;
        while (true) {
            this.i = 0;
            while (this.i < n3) {
                this.p[this.i + n3 * n3] = dArray[this.i];
                ++this.i;
            }
            this.y[n3] = simplexFunction.getValue(dArray);
            ++this.icount;
            this.j = 0;
            while (this.j < n3) {
                this.x = dArray[this.j];
                dArray[this.j] = dArray[this.j] + dArray2[this.j] * this.del;
                this.i = 0;
                while (this.i < n3) {
                    this.p[this.i + this.j * n3] = dArray[this.i];
                    ++this.i;
                }
                this.y[this.j] = simplexFunction.getValue(dArray);
                ++this.icount;
                dArray[this.j] = this.x;
                ++this.j;
            }
            this.ylo = this.y[0];
            this.ilo = 0;
            this.i = 1;
            while (this.i < this.nn) {
                if (this.y[this.i] < this.ylo) {
                    this.ylo = this.y[this.i];
                    this.ilo = this.i;
                }
                ++this.i;
            }
            while (n2 == -1 || n2 > this.icount) {
                this.ynewlo = this.y[0];
                this.ihi = 0;
                this.i = 1;
                while (this.i < this.nn) {
                    if (this.ynewlo < this.y[this.i]) {
                        this.ynewlo = this.y[this.i];
                        this.ihi = this.i;
                    }
                    ++this.i;
                }
                this.i = 0;
                while (this.i < n3) {
                    this.z = 0.0;
                    this.j = 0;
                    while (this.j < this.nn) {
                        this.z += this.p[this.i + this.j * n3];
                        ++this.j;
                    }
                    this.z -= this.p[this.i + this.ihi * n3];
                    this.pbar[this.i] = this.z / this.dn;
                    ++this.i;
                }
                this.i = 0;
                while (this.i < n3) {
                    this.pstar[this.i] = this.pbar[this.i] + this.rcoeff * (this.pbar[this.i] - this.p[this.i + this.ihi * n3]);
                    ++this.i;
                }
                this.ystar = simplexFunction.getValue(this.pstar);
                ++this.icount;
                if (this.ystar < this.ylo) {
                    this.i = 0;
                    while (this.i < n3) {
                        this.p2star[this.i] = this.pbar[this.i] + this.ecoeff * (this.pstar[this.i] - this.pbar[this.i]);
                        ++this.i;
                    }
                    this.y2star = simplexFunction.getValue(this.p2star);
                    ++this.icount;
                    if (this.ystar < this.y2star) {
                        this.i = 0;
                        while (this.i < n3) {
                            this.p[this.i + this.ihi * n3] = this.pstar[this.i];
                            ++this.i;
                        }
                        this.y[this.ihi] = this.ystar;
                    } else {
                        this.i = 0;
                        while (this.i < n3) {
                            this.p[this.i + this.ihi * n3] = this.p2star[this.i];
                            ++this.i;
                        }
                        this.y[this.ihi] = this.y2star;
                    }
                } else {
                    this.l = 0;
                    this.i = 0;
                    while (this.i < this.nn) {
                        if (this.ystar < this.y[this.i]) {
                            ++this.l;
                        }
                        ++this.i;
                    }
                    if (1 < this.l) {
                        this.i = 0;
                        while (this.i < n3) {
                            this.p[this.i + this.ihi * n3] = this.pstar[this.i];
                            ++this.i;
                        }
                        this.y[this.ihi] = this.ystar;
                    } else if (this.l == 0) {
                        this.i = 0;
                        while (this.i < n3) {
                            this.p2star[this.i] = this.pbar[this.i] + this.ccoeff * (this.p[this.i + this.ihi * n3] - this.pbar[this.i]);
                            ++this.i;
                        }
                        this.y2star = simplexFunction.getValue(this.p2star);
                        ++this.icount;
                        if (this.y[this.ihi] < this.y2star) {
                            this.j = 0;
                            while (this.j < this.nn) {
                                this.i = 0;
                                while (this.i < n3) {
                                    this.p[this.i + this.j * n3] = (this.p[this.i + this.j * n3] + this.p[this.i + this.ilo * n3]) * 0.5;
                                    this.xmin[this.i] = this.p[this.i + this.j * n3];
                                    ++this.i;
                                }
                                this.y[this.j] = simplexFunction.getValue(this.xmin);
                                ++this.icount;
                                ++this.j;
                            }
                            this.ylo = this.y[0];
                            this.ilo = 0;
                            this.i = 1;
                            while (this.i < this.nn) {
                                if (this.y[this.i] < this.ylo) {
                                    this.ylo = this.y[this.i];
                                    this.ilo = this.i;
                                }
                                ++this.i;
                            }
                            continue;
                        }
                        this.i = 0;
                        while (this.i < n3) {
                            this.p[this.i + this.ihi * n3] = this.p2star[this.i];
                            ++this.i;
                        }
                        this.y[this.ihi] = this.y2star;
                    } else if (this.l == 1) {
                        this.i = 0;
                        while (this.i < n3) {
                            this.p2star[this.i] = this.pbar[this.i] + this.ccoeff * (this.pstar[this.i] - this.pbar[this.i]);
                            ++this.i;
                        }
                        this.y2star = simplexFunction.getValue(this.p2star);
                        ++this.icount;
                        if (this.y2star <= this.ystar) {
                            this.i = 0;
                            while (this.i < n3) {
                                this.p[this.i + this.ihi * n3] = this.p2star[this.i];
                                ++this.i;
                            }
                            this.y[this.ihi] = this.y2star;
                        } else {
                            this.i = 0;
                            while (this.i < n3) {
                                this.p[this.i + this.ihi * n3] = this.pstar[this.i];
                                ++this.i;
                            }
                            this.y[this.ihi] = this.ystar;
                        }
                    }
                }
                if (this.y[this.ihi] < this.ylo) {
                    this.ylo = this.y[this.ihi];
                    this.ilo = this.ihi;
                }
                --this.jcount;
                if (this.jcount > 0 || n2 != -1 && this.icount > n2) continue;
                this.jcount = n;
                this.z = 0.0;
                this.i = 0;
                while (this.i < this.nn) {
                    this.z += this.y[this.i];
                    ++this.i;
                }
                this.x = this.z / this.dnn;
                this.z = 0.0;
                this.i = 0;
                while (this.i < this.nn) {
                    this.z += Math.pow(this.y[this.i] - this.x, 2.0);
                    ++this.i;
                }
                if (!(this.z <= this.rq)) continue;
            }
            this.i = 0;
            while (this.i < n3) {
                this.xmin[this.i] = this.p[this.i + this.ilo * n3];
                ++this.i;
            }
            this.ynewlo = this.y[this.ilo];
            if (n2 != -1 && n2 < this.icount) {
                this.ifault = 2;
                break;
            }
            this.ifault = 0;
            this.i = 0;
            while (this.i < n3) {
                this.del = dArray2[this.i] * this.eps;
                this.xmin[this.i] = this.xmin[this.i] + this.del;
                this.z = simplexFunction.getValue(this.xmin);
                ++this.icount;
                if (this.z < this.ynewlo) {
                    this.ifault = 2;
                    break;
                }
                this.xmin[this.i] = this.xmin[this.i] - this.del - this.del;
                this.z = simplexFunction.getValue(this.xmin);
                ++this.icount;
                if (this.z < this.ynewlo) {
                    this.ifault = 2;
                    break;
                }
                this.xmin[this.i] = this.xmin[this.i] + this.del;
                ++this.i;
            }
            if (this.ifault == 0) break;
            this.i = 0;
            while (this.i < n3) {
                dArray[this.i] = this.xmin[this.i];
                ++this.i;
            }
            this.del = this.eps;
            ++this.numres;
        }
    }

    public double getMinimumFunctionValue() {
        return this.ynewlo;
    }

    public double[] getMinimumParametersValues() {
        return this.xmin;
    }

    public void setParameterLimits(int n, double d, double d2) {
    }
}

