/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.analysis.automaticexperiment;

import automaticexperiment.AutomaticExperiment;
import automaticexperiment.ModifiableParameter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.stem.analysis.ErrorFunction;
import org.eclipse.stem.analysis.ErrorResult;
import org.eclipse.stem.analysis.ReferenceScenarioDataMap;
import org.eclipse.stem.analysis.ScenarioInitializationException;
import org.eclipse.stem.analysis.automaticexperiment.AbstractErrorAnalysisAlgorithm;
import org.eclipse.stem.analysis.automaticexperiment.CustomSimulationManager;
import org.eclipse.stem.analysis.automaticexperiment.SimplexFunction;
import org.eclipse.stem.analysis.impl.ReferenceScenarioDataMapImpl;
import org.eclipse.stem.analysis.util.CSVscenarioLoader;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.core.model.IntegrationDecorator;
import org.eclipse.stem.core.scenario.Scenario;
import org.eclipse.stem.diseasemodels.standard.AggregatingSIDiseaseModel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModel;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.Simulation;
import org.eclipse.stem.util.loggers.views.CustomCSVLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplexAlgorithmExecuter
extends AbstractErrorAnalysisAlgorithm {
    private ISimulation simulation = null;
    private CustomCSVLogger csvLogger = null;
    private static final String SIMULATION_OUTPUT_DIR = Platform.getLocation() + File.separator + "AutoExpTempDir";
    private static final String LOG_FILE_NAME = String.valueOf(SIMULATION_OUTPUT_DIR) + File.separator + "resultLog.csv";
    static String LS = System.getProperty("line.separator");
    private final CustomSimulationManager simMgr = CustomSimulationManager.getManager();
    private ReferenceScenarioDataMapImpl ref;

    @Override
    public void execute() {
        long l = System.currentTimeMillis();
        this.simplexAlgorithm.execute(this.simplexFnToMinimize, this.initialParamsValues, this.paramsInitialSteps, this.tolerance);
        long l2 = System.currentTimeMillis();
        System.out.println("\n\nTime to execute the Nedler-Mead Algorithm: " + (l2 - l) / 1000L + " seconds");
        System.out.println("Minimum value: " + this.simplexAlgorithm.getMinimumFunctionValue());
        System.out.println("Parameters values: " + Arrays.toString(this.simplexAlgorithm.getMinimumParametersValues()));
    }

    @Override
    public void init(AutomaticExperiment automaticExperiment) {
        super.init(automaticExperiment);
        this.simplexFnToMinimize = new NedlearMeadSimplexFunction(this.parameters, this.baseScenario, this.errorFunction);
        try {
            CSVscenarioLoader cSVscenarioLoader = new CSVscenarioLoader(this.referenceDataDirectory);
            this.ref = cSVscenarioLoader.parseAllFiles(2);
        }
        catch (ScenarioInitializationException scenarioInitializationException) {
            scenarioInitializationException.printStackTrace();
        }
    }

    @Override
    public void setParameters(List<ModifiableParameter> list) {
        super.setParameters(list);
        int n = 0;
        for (ModifiableParameter modifiableParameter : list) {
            this.simplexAlgorithm.setParameterLimits(n, modifiableParameter.getLowerBound(), modifiableParameter.getUpperBound());
            ++n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class NedlearMeadSimplexFunction
    implements SimplexFunction {
        private ErrorFunction errorFunction = null;
        private String[] parameterNames = null;
        private FileWriter resultWriter;

        public NedlearMeadSimplexFunction(List<ModifiableParameter> list, Scenario scenario, ErrorFunction errorFunction) {
            try {
                this.resultWriter = new FileWriter(LOG_FILE_NAME);
                SimplexAlgorithmExecuter.this.baseScenario = scenario;
                this.errorFunction = errorFunction;
                if (list != null) {
                    this.parameterNames = new String[list.size()];
                    int n = 0;
                    for (ModifiableParameter modifiableParameter : list) {
                        this.parameterNames[n++] = modifiableParameter.getFeatureName();
                        this.resultWriter.write(this.parameterNames[n - 1]);
                        this.resultWriter.write(",");
                    }
                    this.resultWriter.write("error");
                    this.resultWriter.write(LS);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        @Override
        public double getValue(double[] dArray) {
            int n;
            if (SimplexAlgorithmExecuter.this.simulation != null) {
                SimplexAlgorithmExecuter.this.baseScenario.reset();
            }
            SimplexAlgorithmExecuter.this.simulation = this.createSimulation(SimplexAlgorithmExecuter.this.baseScenario);
            SimplexAlgorithmExecuter.this.simulation.setSequenceNumber(SimplexAlgorithmExecuter.this.simulation.getSequenceNumber() + 1);
            EList eList = SimplexAlgorithmExecuter.this.baseScenario.getCanonicalGraph().getDecorators();
            for (Decorator decorator : eList) {
                if (!(decorator instanceof DiseaseModel)) continue;
                DiseaseModel diseaseModel = (DiseaseModel)decorator;
                for (EAttribute eAttribute : decorator.eClass().getEAllAttributes()) {
                    n = 0;
                    while (n < this.parameterNames.length) {
                        if (eAttribute.getName().equals(this.parameterNames[n])) {
                            diseaseModel.eSet((EStructuralFeature)eAttribute, (Object)new Double(dArray[n]));
                        }
                        ++n;
                    }
                }
                if (diseaseModel instanceof AggregatingSIDiseaseModel) continue;
                SimplexAlgorithmExecuter.this.csvLogger = new CustomCSVLogger(SIMULATION_OUTPUT_DIR, SimplexAlgorithmExecuter.this.simulation, (IntegrationDecorator)diseaseModel);
            }
            System.out.println("Running the simulation with the following parameters: ");
            System.out.println("\tParameters Names: " + Arrays.toString(this.parameterNames));
            System.out.println("\tParameters Values: " + Arrays.toString(dArray));
            double d = 0.0;
            try {
                double[] dArray2 = dArray;
                n = dArray.length;
                int n2 = 0;
                while (n2 < n) {
                    double d2 = dArray2[n2];
                    this.resultWriter.write(String.valueOf(d2) + ",");
                    ++n2;
                }
                this.runSimulation(SimplexAlgorithmExecuter.this.simulation);
                d = this.getErrorValue(SimplexAlgorithmExecuter.this.simulation.getUniqueIDString());
                System.out.println(" Error is: " + d);
                this.resultWriter.write(String.valueOf(d));
                this.resultWriter.write(LS);
                this.resultWriter.flush();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.cleanup();
            return d;
        }

        private double getErrorValue(String string) {
            ErrorResult errorResult = null;
            try {
                CSVscenarioLoader cSVscenarioLoader = new CSVscenarioLoader(String.valueOf(SIMULATION_OUTPUT_DIR) + File.separator + string + "/Flu");
                ReferenceScenarioDataMapImpl referenceScenarioDataMapImpl = cSVscenarioLoader.parseAllFiles(2);
                errorResult = this.errorFunction.calculateError((ReferenceScenarioDataMap)SimplexAlgorithmExecuter.this.ref, (ReferenceScenarioDataMap)referenceScenarioDataMapImpl);
            }
            catch (ScenarioInitializationException scenarioInitializationException) {
                scenarioInitializationException.printStackTrace();
            }
            return errorResult.getError();
        }

        private void runSimulation(ISimulation iSimulation) {
            long l = System.currentTimeMillis();
            iSimulation.run();
            try {
                iSimulation.join();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            iSimulation.stop();
            long l2 = System.currentTimeMillis();
            System.out.println("It took " + (l2 - l) / 1000L + " seconds to run the simulation");
        }

        private void cleanup() {
            if (SimplexAlgorithmExecuter.this.csvLogger != null) {
                SimplexAlgorithmExecuter.this.csvLogger.close();
                SimplexAlgorithmExecuter.this.csvLogger = null;
            }
            SimplexAlgorithmExecuter.this.simMgr.removeActiveSimulation(SimplexAlgorithmExecuter.this.simulation);
            ((Simulation)SimplexAlgorithmExecuter.this.simulation).destroy();
            SimplexAlgorithmExecuter.this.simulation = null;
            CustomSimulationManager.resetSimulationManager();
        }

        private ISimulation createSimulation(Scenario scenario) {
            Simulation simulation = (Simulation)SimplexAlgorithmExecuter.this.simMgr.createSimulation(scenario, null);
            simulation.simulationSleep = false;
            return simulation;
        }
    }
}

