/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.analysis.automaticexperiment.ui;

import automaticexperiment.AutomaticExperiment;
import automaticexperiment.AutomaticexperimentFactory;
import automaticexperiment.ModifiableParameter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.STEMXMIResourceFactoryImpl;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.scenario.Scenario;
import org.eclipse.stem.ui.wizards.DublinCorePage;
import org.eclipse.stem.ui.wizards.NewIdentifiablePage;
import org.eclipse.stem.ui.wizards.NewIdentifiableWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class NewAutomaticExperimentWizard
extends NewIdentifiableWizard {
    protected NewAutomaticExperimentPage2 page2 = null;

    public void addPages() {
        this.setForcePreviousAndNextButtons(false);
        this.newIdentifiablePage = this.createNewIdentifiablePage();
        if (this.newIdentifiablePage == null) {
            return;
        }
        this.page2 = this.createWizardPage2();
        if (this.page2 == null) {
            return;
        }
        this.newDublinCorePage = this.createDublinCorePage();
        if (this.newDublinCorePage == null) {
            return;
        }
        this.addPage((IWizardPage)this.newIdentifiablePage);
        this.addPage((IWizardPage)this.page2);
        this.addPage((IWizardPage)this.newDublinCorePage);
    }

    public IWizardPage getNextPage(IWizardPage iWizardPage) {
        IWizardPage iWizardPage2 = super.getNextPage(iWizardPage);
        if (iWizardPage2 instanceof NewAutomaticExperimentPage2) {
            NewAutomaticExperimentPage1 newAutomaticExperimentPage1 = (NewAutomaticExperimentPage1)this.newIdentifiablePage;
            this.page2.setSelectedParameters(newAutomaticExperimentPage1.parametersList.getSelection());
        }
        return iWizardPage2;
    }

    protected DublinCorePage createDublinCorePage() {
        return new DublinCorePage(){

            protected void initializeDCAttributes() {
                super.initializeDCAttributes();
                this.format.setText("http:///org/eclipse/stem/core/experiment.ecore");
                this.format.setEnabled(false);
                this.type.setText(STEMURI.EXPERIMENT_TYPE_URI.toString());
                this.type.setEnabled(false);
            }
        };
    }

    protected Identifiable createIdentifiable() {
        return this.createAutomaticExperiment();
    }

    protected NewIdentifiablePage createNewIdentifiablePage() {
        NewAutomaticExperimentPage1 newAutomaticExperimentPage1 = new NewAutomaticExperimentPage1(this.getShell(), "New Automatic Experiment Wizard");
        newAutomaticExperimentPage1.setTitle("Title to externalize");
        newAutomaticExperimentPage1.setDescription("Description to externalize");
        return newAutomaticExperimentPage1;
    }

    protected NewAutomaticExperimentPage2 createWizardPage2() {
        NewAutomaticExperimentPage2 newAutomaticExperimentPage2 = new NewAutomaticExperimentPage2("New Automatic Experiment Wizard");
        newAutomaticExperimentPage2.setTitle("Title to externalize");
        newAutomaticExperimentPage2.setDescription("Description to externalize");
        return newAutomaticExperimentPage2;
    }

    protected String getSerializationFileNameExtension() {
        return "automaticexperiment";
    }

    protected String getSerializationFolderName() {
        return "experiments";
    }

    protected String getWizardTitle() {
        return "Automatic Experiment Wizard";
    }

    protected AutomaticExperiment createAutomaticExperiment() {
        Object object2;
        AutomaticExperiment automaticExperiment = AutomaticexperimentFactory.eINSTANCE.createAutomaticExperiment();
        automaticExperiment.setDublinCore(this.newDublinCorePage.createDublinCore());
        NewAutomaticExperimentPage1 newAutomaticExperimentPage1 = (NewAutomaticExperimentPage1)this.newIdentifiablePage;
        String string = newAutomaticExperimentPage1.algorithmCombo.getText();
        automaticExperiment.setErrorAnalysisAlgorithm(string);
        String string2 = newAutomaticExperimentPage1.errorFunctionCombo.getText();
        automaticExperiment.setErrorFunction(string2);
        if (!newAutomaticExperimentPage1.numOfIterationsSpinner.getText().equals("")) {
            object2 = new Long(newAutomaticExperimentPage1.numOfIterationsSpinner.getText());
            automaticExperiment.setMaximumNumberOfIterations((Long)object2);
        }
        if (!newAutomaticExperimentPage1.refDirText.getText().trim().equals("")) {
            automaticExperiment.setReferanceDataDir(newAutomaticExperimentPage1.refDirText.getText());
        }
        if (!newAutomaticExperimentPage1.refDirText.getText().trim().equals("")) {
            object2 = this.createScenario(newAutomaticExperimentPage1.scenarioText.getText());
            automaticExperiment.setBaseScenario((Scenario)object2);
        }
        for (Object object2 : this.page2.paramToDetailsObj.keySet()) {
            NewAutomaticExperimentPage2.ParameterDetails parameterDetails = (NewAutomaticExperimentPage2.ParameterDetails)this.page2.paramToDetailsObj.get(object2);
            ModifiableParameter modifiableParameter = AutomaticexperimentFactory.eINSTANCE.createModifiableParameter();
            modifiableParameter.setFeatureName((String)object2);
            modifiableParameter.setInitialValue(new Double(parameterDetails.initialValueText.getText()));
            modifiableParameter.setStep(new Double(parameterDetails.stepValueText.getText()));
            automaticExperiment.getParameters().add((Object)modifiableParameter);
        }
        return automaticExperiment;
    }

    protected Scenario createScenario(String string) {
        ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
        resourceSetImpl.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", STEMXMIResourceFactoryImpl.INSTANCE);
        resourceSetImpl.getResourceFactoryRegistry().getProtocolToFactoryMap().put("platform", STEMXMIResourceFactoryImpl.INSTANCE);
        Resource resource = resourceSetImpl.getResource(URI.createFileURI((String)string), true);
        try {
            resource.load(null);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        Scenario scenario = (Scenario)resource.getContents().get(0);
        scenario.initialize();
        return scenario;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class NewAutomaticExperimentPage1
    extends NewIdentifiablePage {
        public org.eclipse.swt.widgets.List parametersList = null;
        public Combo algorithmCombo = null;
        public Combo errorFunctionCombo = null;
        public Spinner numOfIterationsSpinner = null;
        public Text refDirText = null;
        public Text scenarioText = null;
        protected Shell shell = null;

        protected NewAutomaticExperimentPage1(Shell shell, String string) {
            super(string);
            this.shell = shell;
        }

        protected Composite createSpecificComposite(Composite composite) {
            String string2;
            Composite composite2 = new Composite(composite, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 3;
            composite2.setLayout((Layout)gridLayout);
            Label label = new Label(composite2, 0);
            label.setText("Base scenario: ");
            this.scenarioText = new Text(composite2, 2048);
            this.scenarioText.setEditable(false);
            Button button = new Button(composite2, 0);
            button.setText("Select Scenario...");
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    FileDialog fileDialog = new FileDialog(NewAutomaticExperimentPage1.this.shell);
                    fileDialog.setFilterExtensions(new String[]{"*.scenario"});
                    String string = Platform.getInstanceLocation().getURL().getPath();
                    if (string.startsWith("/") || string.startsWith("\\")) {
                        string = string.substring(1);
                    }
                    fileDialog.setFilterPath(string);
                    String string2 = fileDialog.open();
                    NewAutomaticExperimentPage1.this.scenarioText.setText(string2);
                }
            });
            Label label2 = new Label(composite2, 0);
            label2.setText("Disease Model Parameters: ");
            this.parametersList = new org.eclipse.swt.widgets.List(composite2, 2050);
            for (String string2 : this.getParametersNames()) {
                this.parametersList.add(string2);
            }
            this.parametersList.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    NewAutomaticExperimentPage1.this.setPageComplete(NewAutomaticExperimentPage1.this.validatePage());
                }
            });
            string2 = new Composite(composite2, 0);
            string2.setLayout((Layout)new RowLayout(512));
            Button button2 = new Button((Composite)string2, 0);
            button2.setText("Select All");
            button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    NewAutomaticExperimentPage1.this.parametersList.selectAll();
                    NewAutomaticExperimentPage1.this.setPageComplete(NewAutomaticExperimentPage1.this.validatePage());
                }
            });
            Button button3 = new Button((Composite)string2, 0);
            button3.setText("Select None");
            button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    NewAutomaticExperimentPage1.this.parametersList.deselectAll();
                    NewAutomaticExperimentPage1.this.setPageComplete(NewAutomaticExperimentPage1.this.validatePage());
                }
            });
            Label label3 = new Label(composite2, 0);
            label3.setText("Error analysis algorithm: ");
            this.algorithmCombo = new Combo(composite2, 8);
            this.algorithmCombo.add("Nedler-Mead Algorithm");
            this.algorithmCombo.select(0);
            GridData gridData = new GridData(32);
            gridData.horizontalSpan = 2;
            this.algorithmCombo.setLayoutData((Object)gridData);
            Label label4 = new Label(composite2, 0);
            label4.setText("Error function: ");
            this.errorFunctionCombo = new Combo(composite2, 8);
            this.errorFunctionCombo.add("Threshold error function");
            this.errorFunctionCombo.add("Simple error function");
            this.errorFunctionCombo.select(0);
            GridData gridData2 = new GridData(32);
            gridData2.horizontalSpan = 2;
            this.errorFunctionCombo.setLayoutData((Object)gridData2);
            Label label5 = new Label(composite2, 0);
            label5.setText("Maximum number of iterations: ");
            this.numOfIterationsSpinner = new Spinner(composite2, 2048);
            GridData gridData3 = new GridData(32);
            gridData3.horizontalSpan = 2;
            this.numOfIterationsSpinner.setLayoutData((Object)gridData3);
            Label label6 = new Label(composite2, 0);
            label6.setText("Reference data directory: ");
            this.refDirText = new Text(composite2, 2048);
            this.refDirText.setEditable(false);
            Button button4 = new Button(composite2, 0);
            button4.setText("Browse...");
            button4.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    DirectoryDialog directoryDialog = new DirectoryDialog(NewAutomaticExperimentPage1.this.shell);
                    String string = directoryDialog.open();
                    NewAutomaticExperimentPage1.this.refDirText.setText(string);
                }
            });
            return composite2;
        }

        private List<String> getParametersNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("transmissionRate");
            arrayList.add("modulationPhaseShift");
            arrayList.add("seasonalModulationFloor");
            return arrayList;
        }

        private Composite parameterValues(Composite composite, String string) {
            Composite composite2 = new Composite(composite, 0);
            composite2.setLayout((Layout)new RowLayout());
            Label label = new Label(composite2, 0);
            label.setText("Initial value: ");
            return composite2;
        }

        protected boolean validatePage() {
            this.setErrorMessage(null);
            if (this.parametersList.getSelectionCount() == 0) {
                this.setErrorMessage("Choose at least one parameter from the list");
                return false;
            }
            return super.validatePage();
        }

        protected String getDCDescription() {
            return "Some description goes here";
        }
    }

    protected static class NewAutomaticExperimentPage2
    extends WizardPage {
        private Map<String, ParameterDetails> paramToDetailsObj = new HashMap<String, ParameterDetails>();
        private Composite pageComposite = null;

        protected NewAutomaticExperimentPage2(String string) {
            super(string);
        }

        public void createControl(Composite composite) {
            this.pageComposite = new Composite(composite, 0);
            this.pageComposite.setLayout((Layout)new RowLayout(512));
            this.setPageComplete(this.validatePage());
            composite.pack();
            this.setControl((Control)this.pageComposite);
        }

        public void setSelectedParameters(String[] stringArray) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : this.paramToDetailsObj.keySet()) {
                arrayList.add(string);
            }
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string;
                string = stringArray2[n2];
                if (!this.paramToDetailsObj.containsKey(string)) {
                    this.addParamGroup(string);
                } else {
                    arrayList.remove(string);
                }
                ++n2;
            }
            for (String string : arrayList) {
                this.removeParamGroup(string);
            }
            this.pageComposite.pack(true);
        }

        private void addParamGroup(String string) {
            Group group = new Group(this.pageComposite, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            group.setLayout((Layout)gridLayout);
            Label label = new Label((Composite)group, 0);
            label.setText("Initial value: ");
            Text text = new Text((Composite)group, 2048);
            Label label2 = new Label((Composite)group, 0);
            label2.setText("Step value: ");
            Text text2 = new Text((Composite)group, 2048);
            Label label3 = new Label((Composite)group, 0);
            label3.setText("Upperbound value: ");
            Text text3 = new Text((Composite)group, 2048);
            group.setText(string);
            ParameterDetails parameterDetails = new ParameterDetails();
            parameterDetails.group = group;
            parameterDetails.initialValueText = text;
            parameterDetails.stepValueText = text2;
            parameterDetails.upperboundValueText = text3;
            this.paramToDetailsObj.put(string, parameterDetails);
        }

        private void removeParamGroup(String string) {
            ParameterDetails parameterDetails = this.paramToDetailsObj.remove(string);
            Group group = parameterDetails.group;
            group.dispose();
        }

        protected boolean validatePage() {
            return true;
        }

        protected static class ParameterDetails {
            public Group group = null;
            public Text initialValueText = null;
            public Text stepValueText = null;
            public Text upperboundValueText = null;

            protected ParameterDetails() {
            }
        }
    }

    public static class NewAutomaticExperimentWizardCommandHandler
    extends AbstractHandler
    implements IHandler {
        public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
            IWorkbenchWindow iWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)executionEvent);
            NewAutomaticExperimentWizard newAutomaticExperimentWizard = new NewAutomaticExperimentWizard();
            newAutomaticExperimentWizard.init(iWorkbenchWindow.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
            WizardDialog wizardDialog = new WizardDialog(iWorkbenchWindow.getShell(), (IWizard)newAutomaticExperimentWizard);
            wizardDialog.open();
            return null;
        }
    }
}

