/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.internal.data.geography.infrastructure.transportation.propertydata;

import java.text.ParseException;
import java.util.StringTokenizer;
import org.eclipse.stem.data.geography.ISOKey;
import org.eclipse.stem.internal.data.geography.propertydata.GeographicRelationshipPropertyData;

public class AirTransportGeographicRelationshipPropertyData
extends GeographicRelationshipPropertyData {
    private double arrivalRate;
    private double departureRate;

    public AirTransportGeographicRelationshipPropertyData(String string, String string2) throws ParseException {
        super(string, string2);
    }

    protected void parseAndProcessProperty(String string, StringTokenizer stringTokenizer) throws ParseException {
        super.parseAndProcessProperty(string, stringTokenizer);
        if (stringTokenizer.hasMoreTokens()) {
            try {
                this.arrivalRate = Double.parseDouble(stringTokenizer.nextToken());
                this.departureRate = Double.parseDouble(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException(String.valueOf(string) + ":" + numberFormatException.getMessage(), 0);
            }
            catch (NullPointerException nullPointerException) {
                throw new ParseException(String.valueOf(string) + ":" + nullPointerException.getMessage(), 0);
            }
        }
    }

    public final ISOKey getTransportationSystemISOKey() {
        return this.getKeyA();
    }

    public final ISOKey getRegionISOKey() {
        return this.getKeyB();
    }

    public final double getArrivalRate() {
        return this.arrivalRate;
    }

    public final double getDepartureRate() {
        return this.departureRate;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("arrivalRate [");
        stringBuilder.append(this.arrivalRate);
        stringBuilder.append("] departureRate[");
        stringBuilder.append(this.departureRate);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

