/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.internal.data.geography.infrastructure.transportation.propertydata;

import java.text.ParseException;
import java.util.StringTokenizer;
import org.eclipse.stem.internal.data.geography.propertydata.GeographicRelationshipPropertyData;

public class RoadTransportGeographicRelationshipPropertyData
extends GeographicRelationshipPropertyData {
    String roadName;
    String roadClass;
    int numCrossings;

    public RoadTransportGeographicRelationshipPropertyData(String string, String string2) throws ParseException {
        super(string, string2);
    }

    protected void parseAndProcessProperty(String string, StringTokenizer stringTokenizer) throws ParseException {
        super.parseAndProcessProperty(string, stringTokenizer);
        if (stringTokenizer.hasMoreTokens()) {
            this.roadName = stringTokenizer.nextToken(",").trim();
            this.roadClass = stringTokenizer.nextToken(",").trim();
            String string2 = stringTokenizer.nextToken(",").trim();
            try {
                this.numCrossings = Integer.parseInt(string2);
                this.directed = false;
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException(String.valueOf(string) + " = \"" + string2 + "\" number format exception.", 0);
            }
        } else {
            throw new ParseException(String.valueOf(string) + " = " + stringTokenizer.toString(), 0);
        }
    }

    public final String getRoadName() {
        return this.roadName;
    }

    public final String getRoadClass() {
        return this.roadClass;
    }

    public final int getNumCrossings() {
        return this.numCrossings;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("road name [");
        stringBuilder.append(this.roadName);
        stringBuilder.append("] class[");
        stringBuilder.append(this.roadClass);
        stringBuilder.append("] crossings[");
        stringBuilder.append(this.numCrossings);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

